/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql;

import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.Cluster;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.KeyspaceTracerFactory;
import com.netflix.astyanax.connectionpool.Connection;
import com.netflix.astyanax.connectionpool.ConnectionFactory;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.ConnectionPoolProxy;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.exceptions.ThrottledException;
import com.netflix.astyanax.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.astyanax.cql.CqlClusterImpl;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.JavaDriverConfigBridge;
import com.netflix.astyanax.cql.JavaDriverConnectionPoolConfigurationImpl;
import com.netflix.astyanax.cql.JavaDriverConnectionPoolMonitorImpl;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.NotImplementedException;

public class CqlFamilyFactory
implements AstyanaxTypeFactory<com.datastax.driver.core.Cluster> {
    private static CqlFamilyFactory Instance = new CqlFamilyFactory();
    private static AtomicBoolean BatchColumnUpdates = new AtomicBoolean(false);

    public static CqlFamilyFactory getInstance() {
        return Instance;
    }

    public Keyspace createKeyspace(String ksName, ConnectionPool<com.datastax.driver.core.Cluster> cp, AstyanaxConfiguration asConfig, KeyspaceTracerFactory tracerFactory) {
        if (!(cp instanceof ConnectionPoolProxy)) {
            throw new RuntimeException("Cannot use CqlFamilyFactory with a connection pool type other than ConnectionPoolType.JAVA_DRIVER");
        }
        ConnectionPoolProxy cpProxy = (ConnectionPoolProxy)cp;
        ConnectionPoolConfiguration jdConfig = this.getOrCreateJDConfiguration(asConfig, cpProxy.getConnectionPoolConfiguration());
        ConnectionPoolMonitor monitor = cpProxy.getConnectionPoolMonitor();
        if (monitor != null && monitor instanceof CountingConnectionPoolMonitor) {
            monitor = new JavaDriverConnectionPoolMonitorImpl();
        }
        CqlKeyspaceImpl keyspace = new CqlKeyspaceImpl(ksName, asConfig, tracerFactory, jdConfig, monitor);
        cpProxy.addListener((ConnectionPoolProxy.SeedHostListener)keyspace);
        return keyspace;
    }

    public Cluster createCluster(ConnectionPool<com.datastax.driver.core.Cluster> cp, AstyanaxConfiguration asConfig, KeyspaceTracerFactory tracerFactory) {
        if (!(cp instanceof ConnectionPoolProxy)) {
            throw new RuntimeException("Cannot use CqlFamilyFactory with a connection pool type other than ConnectionPoolType.JAVA_DRIVER");
        }
        ConnectionPoolProxy cpProxy = (ConnectionPoolProxy)cp;
        ConnectionPoolConfiguration jdConfig = this.getOrCreateJDConfiguration(asConfig, cpProxy.getConnectionPoolConfiguration());
        ConnectionPoolMonitor monitor = cpProxy.getConnectionPoolMonitor();
        if (monitor != null && monitor instanceof CountingConnectionPoolMonitor) {
            monitor = new JavaDriverConnectionPoolMonitorImpl();
        }
        CqlClusterImpl cluster = new CqlClusterImpl(asConfig, tracerFactory, jdConfig, monitor);
        ((ConnectionPoolProxy)cp).addListener((ConnectionPoolProxy.SeedHostListener)cluster);
        return cluster;
    }

    public ConnectionFactory<com.datastax.driver.core.Cluster> createConnectionFactory(AstyanaxConfiguration asConfig, ConnectionPoolConfiguration cfConfig, KeyspaceTracerFactory tracerFactory, ConnectionPoolMonitor monitor) {
        CqlBasedConnectionFactory<com.datastax.driver.core.Cluster> factory = new CqlBasedConnectionFactory<com.datastax.driver.core.Cluster>();
        factory.asConfig = asConfig;
        factory.cfConfig = cfConfig;
        factory.tracerFactory = tracerFactory;
        factory.monitor = monitor;
        return factory;
    }

    public CqlFamilyFactory enableColumnBatchUpdates(boolean condition) {
        BatchColumnUpdates.set(condition);
        return this;
    }

    public static boolean batchColumnUpdates() {
        return BatchColumnUpdates.get();
    }

    private ConnectionPoolConfiguration getOrCreateJDConfiguration(AstyanaxConfiguration asConfig, ConnectionPoolConfiguration cpConfig) {
        JavaDriverConnectionPoolConfigurationImpl jdConfig;
        if (cpConfig instanceof JavaDriverConnectionPoolConfigurationImpl && (jdConfig = (JavaDriverConnectionPoolConfigurationImpl)cpConfig).getJavaDriverConfig() != null) {
            return jdConfig;
        }
        return new JavaDriverConnectionPoolConfigurationImpl(new JavaDriverConfigBridge(asConfig, cpConfig).getJDConfig());
    }

    private static class CqlBasedConnectionFactory<T>
    implements ConnectionFactory<T> {
        protected AstyanaxConfiguration asConfig;
        protected ConnectionPoolConfiguration cfConfig;
        protected KeyspaceTracerFactory tracerFactory;
        protected ConnectionPoolMonitor monitor;

        private CqlBasedConnectionFactory() {
        }

        public Connection<T> createConnection(HostConnectionPool<T> pool) throws ThrottledException {
            throw new NotImplementedException();
        }
    }
}

