/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.impl.TokenRangeImpl;
import com.netflix.astyanax.partitioner.Murmur3Partitioner;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public class CqlRingDescriber {
    private final AtomicReference<List<TokenRange>> cachedReference = new AtomicReference<Object>(null);
    private static CqlRingDescriber Instance = new CqlRingDescriber();

    private CqlRingDescriber() {
    }

    public static CqlRingDescriber getInstance() {
        return Instance;
    }

    public List<TokenRange> getTokenRanges(Session session, boolean cached) {
        if (cached && this.cachedReference.get() != null) {
            return this.cachedReference.get();
        }
        List<TokenRange> ranges = this.getTokenRanges(session, null, null);
        this.cachedReference.set(ranges);
        return ranges;
    }

    public List<TokenRange> getTokenRanges(Session session, String dc, String rack) {
        ArrayList<HostInfo> hosts = new ArrayList<HostInfo>();
        Select query = QueryBuilder.select().all().from("system", "local");
        ResultSet resultSet = session.execute((Statement)query);
        hosts.add(new HostInfo(resultSet.one(), resultSet));
        query = QueryBuilder.select((String[])new String[]{"peer", "data_center", "host_id", "rack", "tokens"}).from("system", "peers");
        resultSet = session.execute((Statement)query);
        for (Row row : resultSet.all()) {
            hosts.add(new HostInfo(row, null));
        }
        Collections.sort(hosts);
        ArrayList<TokenRange> ranges = new ArrayList<TokenRange>();
        for (int index = 0; index < hosts.size(); ++index) {
            String endToken;
            int prevIndex;
            String startToken;
            int nextIndex;
            HostInfo thisNode = (HostInfo)hosts.get(index);
            ArrayList<String> endpoints = new ArrayList<String>();
            if (this.matchNode(dc, rack, thisNode)) {
                endpoints.add(thisNode.endpoint);
            }
            if ((nextIndex = this.getNextIndex(index, hosts.size())) != index) {
                HostInfo nextNode = (HostInfo)hosts.get(nextIndex);
                if (this.matchNode(dc, rack, nextNode)) {
                    endpoints.add(nextNode.endpoint);
                }
                if (this.matchNode(dc, rack, nextNode = (HostInfo)hosts.get(nextIndex = this.getNextIndex(nextIndex, hosts.size())))) {
                    endpoints.add(nextNode.endpoint);
                }
            }
            if ((startToken = ((HostInfo)hosts.get(prevIndex = this.getPrevIndex(index, hosts.size()))).token.toString()).equals(endToken = thisNode.token.toString())) {
                startToken = Murmur3Partitioner.get().getMinToken();
                endToken = Murmur3Partitioner.get().getMinToken();
            }
            ranges.add((TokenRange)new TokenRangeImpl(startToken, endToken, endpoints));
        }
        return ranges;
    }

    private boolean matchNode(String dc, String rack, HostInfo host) {
        if (dc == null && rack == null) {
            return true;
        }
        if (dc != null && !dc.equals(host.datacenter)) {
            return false;
        }
        return rack == null || rack.equals(host.rack);
    }

    private int getNextIndex(int i, int n) {
        int next = ++i;
        if (i >= n) {
            return 0;
        }
        return next;
    }

    private int getPrevIndex(int i, int n) {
        int prev = --i;
        if (i < 0) {
            return n - 1;
        }
        return prev;
    }

    private class HostInfo
    implements Comparable<HostInfo> {
        private final BigInteger token;
        private final String endpoint;
        private final UUID hostId;
        private final String datacenter;
        private final String rack;

        private HostInfo(Row row, ResultSet rs) {
            if (row == null) {
                throw new RuntimeException("RS is empty for system.local query");
            }
            Set tokens = row.getSet("tokens", String.class);
            String theToken = (String)tokens.iterator().next();
            this.token = new BigInteger(theToken);
            this.hostId = row.getUUID("host_id");
            this.datacenter = row.getString("data_center");
            this.rack = row.getString("rack");
            this.endpoint = rs != null ? rs.getExecutionInfo().getQueriedHost().getAddress().getHostAddress() : row.getInet("peer").getHostAddress();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
            result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
            result = 31 * result + (this.hostId == null ? 0 : this.hostId.hashCode());
            result = 31 * result + (this.datacenter == null ? 0 : this.datacenter.hashCode());
            result = 31 * result + (this.rack == null ? 0 : this.rack.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HostInfo other = (HostInfo)obj;
            boolean equal = true;
            equal &= this.token != null ? this.token.equals(other.token) : other.token == null;
            equal &= this.endpoint != null ? this.endpoint.equals(other.endpoint) : other.endpoint == null;
            equal &= this.hostId != null ? this.hostId.equals(other.hostId) : other.hostId == null;
            equal &= this.datacenter != null ? this.datacenter.equals(other.datacenter) : other.datacenter == null;
            return equal &= this.rack != null ? this.rack.equals(other.rack) : other.rack == null;
        }

        public String toString() {
            return "HostInfo [token=" + this.token + ", endpoint=" + this.endpoint + ", hostId=" + this.hostId.toString() + ", datacenter=" + this.datacenter + ", rack=" + this.rack + "]";
        }

        @Override
        public int compareTo(HostInfo o) {
            return this.token.compareTo(o.token);
        }
    }
}

