/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.direct;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.CqlOperationResultImpl;
import com.netflix.astyanax.cql.CqlPreparedStatement;
import com.netflix.astyanax.cql.CqlStatement;
import com.netflix.astyanax.cql.CqlStatementResult;
import com.netflix.astyanax.cql.direct.DirectCqlPreparedStatement;
import com.netflix.astyanax.cql.direct.DirectCqlStatementResultImpl;
import com.netflix.astyanax.cql.util.AsyncOperationResult;
import com.netflix.astyanax.cql.util.ConsistencyLevelTransform;
import com.netflix.astyanax.model.ConsistencyLevel;

public class DirectCqlStatement
implements CqlStatement {
    private final Session session;
    private ConsistencyLevel cLevel = ConsistencyLevel.CL_ONE;
    private String cqlQuery;

    public DirectCqlStatement(Session session) {
        this.session = session;
    }

    public CqlStatement withConsistencyLevel(ConsistencyLevel cl) {
        this.cLevel = cl;
        return this;
    }

    public CqlStatement withCql(String cql) {
        this.cqlQuery = cql;
        return this;
    }

    public OperationResult<CqlStatementResult> execute() throws ConnectionException {
        SimpleStatement q = new SimpleStatement(this.cqlQuery);
        q.setConsistencyLevel(ConsistencyLevelTransform.getConsistencyLevel(this.cLevel));
        ResultSet resultSet = this.session.execute((Statement)q);
        DirectCqlStatementResultImpl result = new DirectCqlStatementResultImpl(resultSet);
        return new CqlOperationResultImpl<CqlStatementResult>(resultSet, result);
    }

    public ListenableFuture<OperationResult<CqlStatementResult>> executeAsync() throws ConnectionException {
        SimpleStatement q = new SimpleStatement(this.cqlQuery);
        q.setConsistencyLevel(ConsistencyLevelTransform.getConsistencyLevel(this.cLevel));
        ResultSetFuture rsFuture = this.session.executeAsync((Statement)q);
        return new AsyncOperationResult<CqlStatementResult>(rsFuture){

            @Override
            public OperationResult<CqlStatementResult> getOperationResult(ResultSet rs) {
                DirectCqlStatementResultImpl result = new DirectCqlStatementResultImpl(rs);
                return new CqlOperationResultImpl<CqlStatementResult>(rs, result);
            }
        };
    }

    public CqlPreparedStatement asPreparedStatement() {
        PreparedStatement pStmt = this.session.prepare(this.cqlQuery);
        pStmt.setConsistencyLevel(ConsistencyLevelTransform.getConsistencyLevel(this.cLevel));
        return new DirectCqlPreparedStatement(this.session, pStmt);
    }
}

