/**
 * Copyright 2013 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.netflix.astyanax.cql.writes;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

import com.datastax.driver.core.PreparedStatement;

public class StatementCache {

	private final ConcurrentHashMap<Integer, PreparedStatement> statementCache = new ConcurrentHashMap<Integer, PreparedStatement>();
	
	private StatementCache() {
		
	}
	
	public PreparedStatement getStatement(Integer id) {
		return statementCache.get(id);
	}
	
	public PreparedStatement getStatement(Integer id, Callable<PreparedStatement> func) {
		
		PreparedStatement stmt = statementCache.get(id);
		if (stmt == null) {
			try {
				stmt = func.call();
				statementCache.putIfAbsent(id, stmt);
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
		return stmt;
	}
	
	private static final StatementCache Instance = new StatementCache();
	
	public static StatementCache getInstance() {
		return Instance;
	}
}
