/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql;

import com.codahale.metrics.MetricRegistryListener;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.Cluster;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.KeyspaceTracerFactory;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.ConnectionPoolProxy;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.CqlSchemaVersionReader;
import com.netflix.astyanax.cql.JavaDriverConnectionPoolConfigurationImpl;
import com.netflix.astyanax.cql.JavaDriverConnectionPoolMonitorImpl;
import com.netflix.astyanax.cql.schema.CqlColumnDefinitionImpl;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.cql.schema.CqlKeyspaceDefinitionImpl;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.ddl.SchemaChangeResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CqlClusterImpl
implements Cluster,
ConnectionPoolProxy.SeedHostListener {
    public volatile com.datastax.driver.core.Cluster cluster;
    private volatile Session session;
    private final AstyanaxConfiguration astyanaxConfig;
    private final KeyspaceTracerFactory tracerFactory;
    private final Configuration javaDriverConfig;
    private final ConnectionPoolMonitor cpMonitor;
    private final MetricRegistryListener metricsRegListener;

    public CqlClusterImpl(AstyanaxConfiguration asConfig, KeyspaceTracerFactory tracerFactory, ConnectionPoolConfiguration cpConfig, ConnectionPoolMonitor cpMonitor) {
        this.astyanaxConfig = asConfig;
        this.tracerFactory = tracerFactory;
        this.javaDriverConfig = ((JavaDriverConnectionPoolConfigurationImpl)cpConfig).getJavaDriverConfig();
        this.cpMonitor = cpMonitor;
        this.metricsRegListener = ((JavaDriverConnectionPoolMonitorImpl)cpMonitor).getMetricsRegistryListener();
    }

    public String describeClusterName() throws ConnectionException {
        return this.cluster.getMetadata().getClusterName();
    }

    public String getVersion() throws ConnectionException {
        Select.Where query = QueryBuilder.select((String[])new String[]{"release_version"}).from("system", "local").where(QueryBuilder.eq((String)"key", (Object)"local"));
        return this.session.execute((Statement)query).one().getString("release_version");
    }

    public void shutdown() {
        this.cluster.close();
    }

    public String describeSnitch() throws ConnectionException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public String describePartitioner() throws ConnectionException {
        Select.Where query = QueryBuilder.select((String[])new String[]{"partitioner"}).from("system", "local").where(QueryBuilder.eq((String)"key", (Object)"local"));
        return this.session.execute((Statement)query).one().getString("partitioner");
    }

    public Map<String, List<String>> describeSchemaVersions() throws ConnectionException {
        return new CqlSchemaVersionReader(this.session).exec();
    }

    public KeyspaceDefinition makeKeyspaceDefinition() {
        return new CqlKeyspaceDefinitionImpl(this.session);
    }

    public Properties getAllKeyspaceProperties() throws ConnectionException {
        Properties properties = new Properties();
        try {
            List<KeyspaceDefinition> ksDefs = this.describeKeyspaces();
            for (KeyspaceDefinition ksDef : ksDefs) {
                Properties ksProps = ksDef.getProperties();
                for (Object key : ksProps.keySet()) {
                    properties.put(ksDef.getName() + "." + key, ksProps.get(key));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    public Properties getKeyspaceProperties(String keyspace) throws ConnectionException {
        try {
            return this.describeKeyspace(keyspace.toLowerCase()).getProperties();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<KeyspaceDefinition> describeKeyspaces() throws ConnectionException {
        Select query = QueryBuilder.select().all().from("system", "schema_keyspaces");
        ArrayList<KeyspaceDefinition> ksDefs = new ArrayList<KeyspaceDefinition>();
        try {
            for (Row row : this.session.execute((Statement)query).all()) {
                String keyspaceName = row.getString("keyspace_name");
                if (keyspaceName.equals("system") || keyspaceName.startsWith("system_")) continue;
                ksDefs.add(new CqlKeyspaceDefinitionImpl(this.session, row));
            }
            return ksDefs;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public KeyspaceDefinition describeKeyspace(String ksName) throws ConnectionException {
        return new CqlKeyspaceImpl(this.session, ksName, this.astyanaxConfig, this.tracerFactory, this.cpMonitor).describeKeyspace();
    }

    public Keyspace getKeyspace(String keyspace) throws ConnectionException {
        return new CqlKeyspaceImpl(this.session, keyspace, this.astyanaxConfig, this.tracerFactory, this.cpMonitor);
    }

    public OperationResult<SchemaChangeResult> dropKeyspace(String keyspaceName) throws ConnectionException {
        return new CqlKeyspaceImpl(this.session, keyspaceName.toLowerCase(), this.astyanaxConfig, this.tracerFactory, this.cpMonitor).dropKeyspace();
    }

    public OperationResult<SchemaChangeResult> addKeyspace(KeyspaceDefinition def) throws ConnectionException {
        return ((CqlKeyspaceDefinitionImpl)def).execute();
    }

    public OperationResult<SchemaChangeResult> updateKeyspace(KeyspaceDefinition def) throws ConnectionException {
        return ((CqlKeyspaceDefinitionImpl)def).alterKeyspace().execute();
    }

    public OperationResult<SchemaChangeResult> createKeyspace(Map<String, Object> options) throws ConnectionException {
        String keyspaceName = (String)options.remove("name");
        if (keyspaceName == null) {
            throw new RuntimeException("Options missing 'name' property for keyspace name");
        }
        return new CqlKeyspaceDefinitionImpl(this.session, options).setName(keyspaceName).execute();
    }

    public OperationResult<SchemaChangeResult> createKeyspace(Properties props) throws ConnectionException {
        String keyspaceName = (String)props.remove("name");
        if (keyspaceName == null) {
            throw new RuntimeException("Options missing 'name' property for keyspace name");
        }
        return new CqlKeyspaceDefinitionImpl(this.session, props).setName(keyspaceName).execute();
    }

    public OperationResult<SchemaChangeResult> updateKeyspace(Map<String, Object> options) throws ConnectionException {
        String keyspaceName = (String)options.remove("name");
        if (keyspaceName == null) {
            throw new RuntimeException("Options missing 'name' property for keyspace name");
        }
        return new CqlKeyspaceDefinitionImpl(this.session, options).setName(keyspaceName).alterKeyspace().execute();
    }

    public OperationResult<SchemaChangeResult> updateKeyspace(Properties props) throws ConnectionException {
        String keyspaceName = (String)props.remove("name");
        if (keyspaceName == null) {
            throw new RuntimeException("Options missing 'name' property for keyspace name");
        }
        return new CqlKeyspaceDefinitionImpl(this.session, props).setName(keyspaceName).alterKeyspace().execute();
    }

    public AstyanaxConfiguration getConfig() {
        return this.astyanaxConfig;
    }

    public ColumnFamilyDefinition makeColumnFamilyDefinition() {
        return new CqlColumnFamilyDefinitionImpl(this.session);
    }

    public ColumnDefinition makeColumnDefinition() {
        return new CqlColumnDefinitionImpl();
    }

    public Properties getColumnFamilyProperties(String keyspace, String columnfamilyName) throws ConnectionException {
        try {
            return new CqlKeyspaceDefinitionImpl(this.session).setName(keyspace).getColumnFamily(columnfamilyName).getProperties();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public OperationResult<SchemaChangeResult> createColumnFamily(Map<String, Object> options) throws ConnectionException {
        return new CqlColumnFamilyDefinitionImpl(this.session, null, options).execute();
    }

    public OperationResult<SchemaChangeResult> createColumnFamily(Properties props) throws ConnectionException {
        return new CqlColumnFamilyDefinitionImpl(this.session, null, props).execute();
    }

    public OperationResult<SchemaChangeResult> updateColumnFamily(Map<String, Object> options) throws ConnectionException {
        return new CqlColumnFamilyDefinitionImpl(this.session, null, options).alterTable().execute();
    }

    public OperationResult<SchemaChangeResult> updateColumnFamily(Properties props) throws ConnectionException {
        return new CqlColumnFamilyDefinitionImpl(this.session, null, props).alterTable().execute();
    }

    public OperationResult<SchemaChangeResult> dropColumnFamily(String keyspaceName, String columnFamilyName) throws ConnectionException {
        return new CqlKeyspaceImpl(this.session, keyspaceName, this.astyanaxConfig, this.tracerFactory, this.cpMonitor).dropColumnFamily(columnFamilyName);
    }

    public OperationResult<SchemaChangeResult> addColumnFamily(ColumnFamilyDefinition def) throws ConnectionException {
        return ((CqlColumnFamilyDefinitionImpl)def).execute();
    }

    public OperationResult<SchemaChangeResult> updateColumnFamily(ColumnFamilyDefinition def) throws ConnectionException {
        return ((CqlColumnFamilyDefinitionImpl)def).alterTable().execute();
    }

    public void setHosts(Collection<Host> hosts, int port) {
        ArrayList hostList = Lists.newArrayList(hosts);
        List contactPoints = Lists.transform((List)hostList, (Function)new Function<Host, String>(){

            public String apply(Host input) {
                if (input != null) {
                    return input.getHostName();
                }
                return null;
            }
        });
        Configuration config = this.javaDriverConfig;
        Cluster.Builder builder = com.datastax.driver.core.Cluster.builder().addContactPoints(contactPoints.toArray(new String[0])).withPort(port).withLoadBalancingPolicy(config.getPolicies().getLoadBalancingPolicy()).withReconnectionPolicy(config.getPolicies().getReconnectionPolicy()).withRetryPolicy(config.getPolicies().getRetryPolicy()).withCompression(config.getProtocolOptions().getCompression()).withPoolingOptions(config.getPoolingOptions()).withSocketOptions(config.getSocketOptions()).withQueryOptions(config.getQueryOptions());
        if (config.getMetricsOptions() == null) {
            builder.withoutMetrics();
        } else if (!config.getMetricsOptions().isJMXReportingEnabled()) {
            builder.withoutJMXReporting();
        }
        this.cluster = builder.build();
        if (!(this.cpMonitor instanceof JavaDriverConnectionPoolMonitorImpl)) {
            this.cluster.getMetrics().getRegistry().addListener(this.metricsRegListener);
        }
        this.session = this.cluster.connect();
    }
}

