/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.MetricsOptions;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AuthenticationCredentials;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.cql.util.ConsistencyLevelTransform;

public class JavaDriverConfigBridge {
    private final AstyanaxConfiguration asConfig;
    private final ConnectionPoolConfiguration cpConfig;

    public JavaDriverConfigBridge(AstyanaxConfiguration asConfig, ConnectionPoolConfiguration cpConfig) {
        this.asConfig = asConfig;
        this.cpConfig = cpConfig;
    }

    public Configuration getJDConfig() {
        return Configuration.builder().withPolicies(this.getPolicies()).withProtocolOptions(this.getProtocolOptions()).withPoolingOptions(this.getPoolingOptions()).withSocketOptions(this.getSocketOptions()).withMetricsOptions(this.getMetricsOptions()).withQueryOptions(this.getQueryOptions()).build();
    }

    private Policies getPolicies() {
        return Policies.builder().withLoadBalancingPolicy(this.getLB()).build();
    }

    private LoadBalancingPolicy getLB() {
        switch (this.asConfig.getConnectionPoolType()) {
            case ROUND_ROBIN: {
                return new RoundRobinPolicy();
            }
            case TOKEN_AWARE: {
                return new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy());
            }
            case BAG: {
                throw new RuntimeException("Unsupported connection pool type, use ROUND_ROBIN or TOKEN_AWARE");
            }
        }
        return new RoundRobinPolicy();
    }

    private ProtocolOptions getProtocolOptions() {
        int port = this.cpConfig.getPort();
        AuthProvider authProvider = AuthProvider.NONE;
        AuthenticationCredentials creds = this.cpConfig.getAuthenticationCredentials();
        if (creds != null) {
            authProvider = new PlainTextAuthProvider(creds.getUsername(), creds.getPassword());
        }
        return new ProtocolOptions(port, ProtocolVersion.NEWEST_SUPPORTED, 10, null, authProvider);
    }

    private PoolingOptions getPoolingOptions() {
        return new CpConfigBasedPoolingOptions();
    }

    private SocketOptions getSocketOptions() {
        return new CpConfigBasedSocketOptions();
    }

    private MetricsOptions getMetricsOptions() {
        return new MetricsOptions();
    }

    private QueryOptions getQueryOptions() {
        return new ConfigBasedQueryOptions();
    }

    private class ConfigBasedQueryOptions
    extends QueryOptions {
        private ConfigBasedQueryOptions() {
        }

        public ConsistencyLevel getConsistencyLevel() {
            return ConsistencyLevelTransform.getConsistencyLevel(JavaDriverConfigBridge.this.asConfig.getDefaultReadConsistencyLevel());
        }
    }

    private class CpConfigBasedSocketOptions
    extends SocketOptions {
        private CpConfigBasedSocketOptions() {
        }

        public int getConnectTimeoutMillis() {
            return JavaDriverConfigBridge.this.cpConfig.getConnectTimeout();
        }

        public int getReadTimeoutMillis() {
            return JavaDriverConfigBridge.this.cpConfig.getSocketTimeout();
        }
    }

    private class CpConfigBasedPoolingOptions
    extends PoolingOptions {
        private CpConfigBasedPoolingOptions() {
        }

        public int getCoreConnectionsPerHost(HostDistance distance) {
            return JavaDriverConfigBridge.this.cpConfig.getMaxConnsPerHost() > 4 ? JavaDriverConfigBridge.this.cpConfig.getMaxConnsPerHost() / 2 : JavaDriverConfigBridge.this.cpConfig.getMaxConnsPerHost();
        }

        public int getMaxConnectionsPerHost(HostDistance distance) {
            return JavaDriverConfigBridge.this.cpConfig.getMaxConnsPerHost();
        }
    }
}

