/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads.model;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.util.CqlTypeMapping;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.serializers.DateSerializer;
import com.netflix.astyanax.serializers.DoubleSerializer;
import com.netflix.astyanax.serializers.FloatSerializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.ShortSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;

public class CqlColumnImpl<C>
implements Column<C> {
    private Row row;
    private C columnName;
    private int index;
    private ComparatorType cType;
    private boolean isBlob = false;

    public CqlColumnImpl() {
    }

    public CqlColumnImpl(C colName, Row row, int index) {
        this.columnName = colName;
        this.row = row;
        this.index = index;
        ColumnDefinitions.Definition colDefinition = (ColumnDefinitions.Definition)row.getColumnDefinitions().asList().get(index);
        this.isBlob = colDefinition.getType() == DataType.blob();
    }

    public CqlColumnImpl(C colName, Row row, int index, ColumnDefinitions.Definition colDefinition) {
        this.columnName = colName;
        this.row = row;
        this.index = index;
        this.isBlob = colDefinition.getType() == DataType.blob();
    }

    public C getName() {
        return this.columnName;
    }

    public ByteBuffer getRawName() {
        return StringSerializer.get().toByteBuffer(String.valueOf(this.columnName));
    }

    public long getTimestamp() {
        return this.row.getLong(this.index + 2);
    }

    public <V> V getValue(Serializer<V> valSer) {
        return (V)valSer.fromByteBuffer(this.row.getBytes(this.index));
    }

    public String getStringValue() {
        return this.isBlob ? StringSerializer.get().fromByteBuffer(this.row.getBytes(this.index)) : this.row.getString(this.index);
    }

    public String getCompressedStringValue() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public byte getByteValue() {
        return this.row.getBytes(this.index).get();
    }

    public short getShortValue() {
        Integer i = this.isBlob ? (int)ShortSerializer.get().fromByteBuffer(this.row.getBytes(this.index)).shortValue() : this.row.getInt(this.index);
        return i.shortValue();
    }

    public int getIntegerValue() {
        return this.isBlob ? IntegerSerializer.get().fromByteBuffer(this.row.getBytes(this.index)).intValue() : this.row.getInt(this.index);
    }

    public float getFloatValue() {
        return this.isBlob ? FloatSerializer.get().fromByteBuffer(this.row.getBytes(this.index)).floatValue() : this.row.getFloat(this.index);
    }

    public double getDoubleValue() {
        return this.isBlob ? DoubleSerializer.get().fromByteBuffer(this.row.getBytes(this.index)).doubleValue() : this.row.getDouble(this.index);
    }

    public long getLongValue() {
        return this.isBlob ? LongSerializer.get().fromByteBuffer(this.row.getBytes(this.index)).longValue() : this.row.getLong(this.index);
    }

    public byte[] getByteArrayValue() {
        return this.row.getBytes(this.index).array();
    }

    public boolean getBooleanValue() {
        return this.isBlob ? BooleanSerializer.get().fromByteBuffer(this.row.getBytes(this.index)).booleanValue() : this.row.getBool(this.index);
    }

    public ByteBuffer getByteBufferValue() {
        return this.row.getBytes(this.index);
    }

    public Date getDateValue() {
        return this.isBlob ? DateSerializer.get().fromByteBuffer(this.row.getBytes(this.index)) : this.row.getTimestamp(this.index);
    }

    public UUID getUUIDValue() {
        return this.isBlob ? UUIDSerializer.get().fromByteBuffer(this.row.getBytes(this.index)) : this.row.getUUID(this.index);
    }

    @Deprecated
    public <C2> ColumnList<C2> getSubColumns(Serializer<C2> ser) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Deprecated
    public boolean isParentColumn() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public int getTtl() {
        return this.row.getInt(this.index + 1);
    }

    public boolean hasValue() {
        return this.row != null && !this.row.isNull(this.index);
    }

    public Object getGenericValue() {
        ComparatorType cType = this.getComparatorType();
        return CqlTypeMapping.getDynamicColumn(this.row, cType.getSerializer(), this.index, null);
    }

    public ComparatorType getComparatorType() {
        if (this.cType != null) {
            return this.cType;
        }
        DataType type = this.row.getColumnDefinitions().getType(this.index);
        if (type.isCollection()) {
            throw new RuntimeException("This operation does not work for collection objects");
        }
        String typeString = type.getName().name().toUpperCase();
        this.cType = CqlTypeMapping.getComparatorFromCqlType(typeString);
        return this.cType;
    }
}

