/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.writes;

import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.cql.util.CFQueryContext;
import com.netflix.astyanax.cql.writes.CqlColumnMutationImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class CqlStyleMutationQuery {
    protected final CqlKeyspaceImpl.KeyspaceContext ksContext;
    protected final CFQueryContext<?, ?> cfContext;
    protected final List<CqlColumnMutationImpl<?, ?>> mutationList;
    protected AtomicReference<Boolean> deleteRow;
    protected final AtomicReference<Long> defaultTimestamp;
    protected final AtomicReference<Integer> defaultTTL;
    protected final ConsistencyLevel consistencyLevel;
    private static final String USING = " USING ";
    private static final String TTL = " TTL ";
    private static final String AND = " AND";
    private static final String TIMESTAMP = " TIMESTAMP ";

    public CqlStyleMutationQuery(CqlKeyspaceImpl.KeyspaceContext ksCtx, CFQueryContext<?, ?> cfCtx, List<CqlColumnMutationImpl<?, ?>> mutationList, AtomicReference<Boolean> deleteRow, AtomicReference<Integer> ttl, AtomicReference<Long> timestamp, ConsistencyLevel consistencyLevel) {
        this.ksContext = ksCtx;
        this.cfContext = cfCtx;
        this.mutationList = mutationList;
        this.deleteRow = deleteRow;
        this.defaultTTL = ttl;
        this.defaultTimestamp = timestamp;
        this.consistencyLevel = consistencyLevel;
        if (this.consistencyLevel != null) {
            this.cfContext.setConsistencyLevel(consistencyLevel);
        }
    }

    public String getDeleteEntireRowQuery() {
        ColumnFamily<?, ?> cf = this.cfContext.getColumnFamily();
        CqlColumnFamilyDefinitionImpl cfDef = (CqlColumnFamilyDefinitionImpl)cf.getColumnFamilyDefinition();
        return "DELETE FROM " + this.ksContext.getKeyspace() + "." + cf.getName() + " WHERE " + cfDef.getPartitionKeyColumnDefinition().getName() + " = ?;";
    }

    public void appendWriteOptions(StringBuilder sb, Integer overrideTTL, Long overrideTimestamp) {
        Long timestamp;
        Integer ttl = overrideTTL != null ? overrideTTL : this.defaultTTL.get();
        Long l = timestamp = overrideTimestamp != null ? overrideTimestamp : this.defaultTimestamp.get();
        if (ttl != null || timestamp != null) {
            sb.append(USING);
        }
        if (ttl != null) {
            sb.append(TTL + ttl);
        }
        if (timestamp != null) {
            if (ttl != null) {
                sb.append(AND);
            }
            sb.append(TIMESTAMP + timestamp);
        }
    }
}

