/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.entitystore.AbstractColumnMapper;
import com.netflix.astyanax.entitystore.ColumnMapper;
import com.netflix.astyanax.entitystore.CompositeColumnMapper;
import com.netflix.astyanax.entitystore.LeafColumnMapper;
import com.netflix.astyanax.entitystore.MapColumnMapper;
import com.netflix.astyanax.entitystore.MappingUtils;
import com.netflix.astyanax.entitystore.SetColumnMapper;
import com.netflix.astyanax.entitystore.TTL;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.StringUtils;

class EntityMapper<T, K> {
    private final Class<T> clazz;
    private final Integer ttl;
    private final Method ttlMethod;
    private final Field idField;
    private final Map<String, ColumnMapper> columnList;
    private final ColumnMapper uniqueColumn;
    private final String entityName;

    EntityMapper(Class<T> clazz, Integer ttl) {
        TTL ttlAnnotation;
        this.clazz = clazz;
        Entity entityAnnotation = clazz.getAnnotation(Entity.class);
        if (entityAnnotation == null) {
            throw new IllegalArgumentException("class is NOT annotated with @java.persistence.Entity: " + clazz.getName());
        }
        this.entityName = MappingUtils.getEntityName(entityAnnotation, clazz);
        Integer tmpTtlValue = ttl;
        if (tmpTtlValue == null && (ttlAnnotation = clazz.getAnnotation(TTL.class)) != null) {
            int ttlAnnotationValue = ttlAnnotation.value();
            Preconditions.checkState((ttlAnnotationValue > 0 ? 1 : 0) != 0, (Object)("cannot define non-positive value for TTL annotation at class level: " + ttlAnnotationValue));
            tmpTtlValue = ttlAnnotationValue;
        }
        this.ttl = tmpTtlValue;
        Method tmpTtlMethod = null;
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(TTL.class)) continue;
            Preconditions.checkState((tmpTtlMethod == null ? 1 : 0) != 0, (Object)("Duplicate TTL method annotation on " + method.getName()));
            tmpTtlMethod = method;
            tmpTtlMethod.setAccessible(true);
        }
        this.ttlMethod = tmpTtlMethod;
        Field[] declaredFields = clazz.getDeclaredFields();
        this.columnList = Maps.newHashMapWithExpectedSize((int)declaredFields.length);
        HashSet usedColumnNames = Sets.newHashSet();
        Field tmpIdField = null;
        LeafColumnMapper tempUniqueMapper = null;
        for (Field field : declaredFields) {
            javax.persistence.Column columnAnnotation;
            Id idAnnotation = field.getAnnotation(Id.class);
            if (idAnnotation != null) {
                Preconditions.checkArgument((tmpIdField == null ? 1 : 0) != 0, (Object)"there are multiple fields with @Id annotation");
                field.setAccessible(true);
                tmpIdField = field;
            }
            if ((columnAnnotation = field.getAnnotation(javax.persistence.Column.class)) == null) continue;
            field.setAccessible(true);
            AbstractColumnMapper columnMapper = null;
            Entity compositeAnnotation = field.getType().getAnnotation(Entity.class);
            if (Map.class.isAssignableFrom(field.getType())) {
                columnMapper = new MapColumnMapper(field);
            } else if (Set.class.isAssignableFrom(field.getType())) {
                columnMapper = new SetColumnMapper(field);
            } else if (compositeAnnotation == null) {
                if (columnAnnotation.unique()) {
                    Preconditions.checkArgument((tempUniqueMapper == null ? 1 : 0) != 0, (Object)("can't have multiple unique columns '" + field.getName() + "'"));
                    tempUniqueMapper = new LeafColumnMapper(field);
                } else {
                    columnMapper = new LeafColumnMapper(field);
                }
            } else {
                columnMapper = new CompositeColumnMapper(field);
            }
            Preconditions.checkArgument((!usedColumnNames.contains(columnMapper.getColumnName()) ? 1 : 0) != 0, (Object)String.format("duplicate case-insensitive column name: %s", columnMapper.getColumnName().toLowerCase()));
            this.columnList.put(columnMapper.getColumnName(), columnMapper);
            usedColumnNames.add(columnMapper.getColumnName().toLowerCase());
        }
        Preconditions.checkNotNull(tmpIdField, (Object)"there are no field with @Id annotation");
        this.idField = tmpIdField;
        this.uniqueColumn = tempUniqueMapper;
    }

    void fillMutationBatch(MutationBatch mb, ColumnFamily<K, String> columnFamily, T entity) {
        try {
            Object rowKey = this.idField.get(entity);
            ColumnListMutation clm = mb.withRow(columnFamily, rowKey);
            clm.setDefaultTtl(this.getTtl(entity));
            for (ColumnMapper mapper : this.columnList.values()) {
                mapper.fillMutationBatch(entity, (ColumnListMutation<String>)clm, "");
            }
        }
        catch (Exception e) {
            throw new PersistenceException("failed to fill mutation batch", (Throwable)e);
        }
    }

    private Integer getTtl(T entity) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Integer retTtl = this.ttl;
        if (this.ttlMethod != null) {
            Object retobj = this.ttlMethod.invoke(entity, new Object[0]);
            retTtl = (Integer)retobj;
        }
        return retTtl;
    }

    T constructEntity(K id, ColumnList<String> cl) {
        try {
            T entity = this.clazz.newInstance();
            this.idField.set(entity, id);
            for (Object column : cl) {
                ArrayList name = Lists.newArrayList((Object[])StringUtils.split((String)((String)column.getName()), (String)"."));
                this.setField(entity, name.iterator(), (Column<String>)column);
            }
            for (Object column : this.columnList.values()) {
                column.validate(entity);
            }
            return entity;
        }
        catch (Exception e) {
            throw new PersistenceException("failed to construct entity", (Throwable)e);
        }
    }

    void setField(T entity, Iterator<String> name, Column<String> column) throws Exception {
        String fieldName = name.next();
        ColumnMapper mapper = this.columnList.get(fieldName);
        if (mapper != null) {
            mapper.setField(entity, name, column);
        }
    }

    K getEntityId(T entity) throws Exception {
        return (K)this.idField.get(entity);
    }

    @VisibleForTesting
    Field getId() {
        return this.idField;
    }

    @VisibleForTesting
    Collection<ColumnMapper> getColumnList() {
        return this.columnList.values();
    }

    String getEntityName() {
        return this.entityName;
    }

    public String toString() {
        return String.format("EntityMapper(%s)", this.clazz);
    }
}

