/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;

public class LifecycleEvents<T> {
    private final Class<T> clazz;
    private Method prePersist;
    private Method postPersist;
    private Method postRemove;
    private Method preRemove;
    private Method postLoad;

    public LifecycleEvents(Class<T> clazz) {
        this.clazz = clazz;
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (method.isAnnotationPresent(PrePersist.class)) {
                Preconditions.checkState((this.prePersist == null ? 1 : 0) != 0, (Object)("Duplicate PrePersist annotation on " + method.getName()));
                this.prePersist = method;
                this.prePersist.setAccessible(true);
            }
            if (method.isAnnotationPresent(PostPersist.class)) {
                Preconditions.checkState((this.postPersist == null ? 1 : 0) != 0, (Object)("Duplicate PostPersist annotation on " + method.getName()));
                this.postPersist = method;
                this.postPersist.setAccessible(true);
            }
            if (method.isAnnotationPresent(PostRemove.class)) {
                Preconditions.checkState((this.postRemove == null ? 1 : 0) != 0, (Object)("Duplicate PostRemove annotation on " + method.getName()));
                this.postRemove = method;
                this.postRemove.setAccessible(true);
            }
            if (method.isAnnotationPresent(PreRemove.class)) {
                Preconditions.checkState((this.preRemove == null ? 1 : 0) != 0, (Object)("Duplicate PreRemove annotation on " + method.getName()));
                this.preRemove = method;
                this.preRemove.setAccessible(true);
            }
            if (!method.isAnnotationPresent(PostLoad.class)) continue;
            Preconditions.checkState((this.postLoad == null ? 1 : 0) != 0, (Object)("Duplicate PostLoad annotation on " + method.getName()));
            this.postLoad = method;
            this.postLoad.setAccessible(true);
        }
    }

    public void onPrePersist(T obj) throws Exception {
        if (this.prePersist != null) {
            this.prePersist.invoke(obj, new Object[0]);
        }
    }

    public void onPostPersist(T obj) throws Exception {
        if (this.postPersist != null) {
            this.postPersist.invoke(obj, new Object[0]);
        }
    }

    public void onPreRemove(T obj) throws Exception {
        if (this.preRemove != null) {
            this.preRemove.invoke(obj, new Object[0]);
        }
    }

    public void onPostRemove(T obj) throws Exception {
        if (this.postRemove != null) {
            this.postRemove.invoke(obj, new Object[0]);
        }
    }

    public void onPostLoad(T obj) throws Exception {
        if (this.postLoad != null) {
            this.postLoad.invoke(obj, new Object[0]);
        }
    }
}

