/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.MutationBatchManager;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.ThreadLocalMutationBatchManager;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.entitystore.CompositeEntityMapper;
import com.netflix.astyanax.entitystore.EntityManager;
import com.netflix.astyanax.entitystore.LifecycleEvents;
import com.netflix.astyanax.entitystore.MappingUtils;
import com.netflix.astyanax.entitystore.NativeQuery;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.model.CqlResult;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.query.ColumnFamilyQuery;
import com.netflix.astyanax.query.RowSliceQuery;
import com.netflix.astyanax.recipes.reader.AllRowsReader;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.util.RangeBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeEntityManager<T, K>
implements EntityManager<T, K> {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeEntityManager.class);
    private static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.CL_ONE;
    private final Keyspace keyspace;
    private final CompositeEntityMapper<T, K> entityMapper;
    private final RetryPolicy retryPolicy;
    private final LifecycleEvents<T> lifecycleHandler;
    private final boolean autoCommit;
    private final ColumnFamily<K, ByteBuffer> columnFamily;
    private final ConsistencyLevel readConsitency;
    private final MutationBatchManager batchManager;
    private final boolean verbose;

    public static <T, K> Builder<T, K> builder() {
        return new Builder();
    }

    public CompositeEntityManager(Builder<T, K> builder) {
        this.entityMapper = ((Builder)builder).entityMapper;
        this.keyspace = ((Builder)builder).keyspace;
        this.columnFamily = ((Builder)builder).columnFamily;
        this.readConsitency = ((Builder)builder).readConsitency;
        this.retryPolicy = ((Builder)builder).retryPolicy;
        this.lifecycleHandler = ((Builder)builder).lifecycleHandler;
        this.autoCommit = ((Builder)builder).autoCommit;
        this.batchManager = ((Builder)builder).batchManager;
        this.verbose = ((Builder)builder).verbose;
    }

    @Override
    public void put(T entity) throws PersistenceException {
        try {
            if (this.verbose) {
                LOG.info(String.format("%s : Adding entity '%s'", this.columnFamily.getName(), entity));
            }
            this.lifecycleHandler.onPrePersist(entity);
            MutationBatch mb = this.getMutationBatch();
            this.entityMapper.fillMutationBatch(mb, this.columnFamily, entity);
            if (this.autoCommit) {
                mb.execute();
            }
            this.lifecycleHandler.onPostPersist(entity);
        }
        catch (Exception e) {
            throw new PersistenceException("failed to put entity ", (Throwable)e);
        }
    }

    @Override
    public T get(K id) throws PersistenceException {
        throw new UnsupportedOperationException("Call newNativeQuery().withId().equal({id}) instead");
    }

    @Override
    public void delete(K id) throws PersistenceException {
        try {
            if (this.verbose) {
                LOG.info(String.format("%s : Deleting id '%s'", this.columnFamily.getName(), id));
            }
            MutationBatch mb = this.getMutationBatch();
            mb.withRow(this.columnFamily, id).delete();
            if (this.autoCommit) {
                mb.execute();
            }
        }
        catch (Exception e) {
            throw new PersistenceException("failed to delete entity " + id, (Throwable)e);
        }
    }

    @Override
    public void remove(T entity) throws PersistenceException {
        Object id = null;
        try {
            if (this.verbose) {
                LOG.info(String.format("%s : Removing entity '%s'", this.columnFamily.getName(), entity));
            }
            this.lifecycleHandler.onPreRemove(entity);
            id = this.entityMapper.getEntityId(entity);
            MutationBatch mb = this.getMutationBatch();
            this.entityMapper.fillMutationBatchForDelete(mb, this.columnFamily, entity);
            if (this.autoCommit) {
                mb.execute();
            }
            this.lifecycleHandler.onPostRemove(entity);
        }
        catch (Exception e) {
            throw new PersistenceException("failed to delete entity " + id, (Throwable)e);
        }
    }

    @Override
    public List<T> getAll() throws PersistenceException {
        final ArrayList entities = Lists.newArrayList();
        this.visitAll(new Function<T, Boolean>(){

            public synchronized Boolean apply(T entity) {
                entities.add(entity);
                try {
                    CompositeEntityManager.this.lifecycleHandler.onPostLoad(entity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        });
        return entities;
    }

    @Override
    public List<T> get(Collection<K> ids) throws PersistenceException {
        try {
            if (this.verbose) {
                LOG.info(String.format("%s : Reading entities '%s'", this.columnFamily.getName(), ids.toString()));
            }
            ColumnFamilyQuery<K, ByteBuffer> cfq = this.newQuery();
            return this.convertRowsToEntities((Rows)cfq.getRowSlice(ids).execute().getResult());
        }
        catch (Exception e) {
            throw new PersistenceException("failed to get entities " + ids, (Throwable)e);
        }
    }

    private List<T> convertRowsToEntities(Rows<K, ByteBuffer> rows) throws Exception {
        ArrayList entities = Lists.newArrayList();
        for (Row row : rows) {
            ColumnList cl = row.getColumns();
            if (cl.isEmpty()) continue;
            for (Column column : cl) {
                T entity = this.entityMapper.constructEntity(row.getKey(), (Column<ByteBuffer>)column);
                this.lifecycleHandler.onPostLoad(entity);
                entities.add(entity);
            }
        }
        return entities;
    }

    @Override
    public void delete(Collection<K> ids) throws PersistenceException {
        MutationBatch mb = this.getMutationBatch();
        try {
            if (this.verbose) {
                LOG.info(String.format("%s : Delete ids '%s'", this.columnFamily.getName(), ids.toString()));
            }
            for (K id : ids) {
                mb.withRow(this.columnFamily, id).delete();
            }
            if (this.autoCommit) {
                mb.execute();
            }
        }
        catch (Exception e) {
            throw new PersistenceException("failed to delete entities " + ids, (Throwable)e);
        }
    }

    @Override
    public void remove(Collection<T> entities) throws PersistenceException {
        MutationBatch mb = this.getMutationBatch();
        try {
            for (T entity : entities) {
                this.lifecycleHandler.onPreRemove(entity);
                if (this.verbose) {
                    LOG.info(String.format("%s : Deleting '%s'", this.columnFamily.getName(), entity));
                }
                this.entityMapper.fillMutationBatchForDelete(mb, this.columnFamily, entity);
            }
            mb.execute();
            for (T entity : entities) {
                this.lifecycleHandler.onPostRemove(entity);
            }
        }
        catch (Exception e) {
            throw new PersistenceException("failed to delete entities ", (Throwable)e);
        }
    }

    @Override
    public void put(Collection<T> entities) throws PersistenceException {
        MutationBatch mb = this.getMutationBatch();
        try {
            for (T entity : entities) {
                this.lifecycleHandler.onPrePersist(entity);
                if (this.verbose) {
                    LOG.info(String.format("%s : Writing '%s'", this.columnFamily.getName(), entity));
                }
                this.entityMapper.fillMutationBatch(mb, this.columnFamily, entity);
            }
            if (this.autoCommit) {
                mb.execute();
            }
            for (T entity : entities) {
                this.lifecycleHandler.onPostPersist(entity);
            }
        }
        catch (Exception e) {
            throw new PersistenceException("failed to put entities ", (Throwable)e);
        }
    }

    @Override
    public void visitAll(final Function<T, Boolean> callback) throws PersistenceException {
        try {
            new AllRowsReader.Builder(this.keyspace, this.columnFamily).withIncludeEmptyRows(Boolean.valueOf(false)).forEachRow(new Function<Row<K, ByteBuffer>, Boolean>(){

                public Boolean apply(Row<K, ByteBuffer> row) {
                    if (row.getColumns().isEmpty()) {
                        return true;
                    }
                    for (Column column : row.getColumns()) {
                        Object entity = CompositeEntityManager.this.entityMapper.constructEntity(row.getKey(), (Column<ByteBuffer>)column);
                        try {
                            CompositeEntityManager.this.lifecycleHandler.onPostLoad(entity);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (((Boolean)callback.apply(entity)).booleanValue()) continue;
                        return false;
                    }
                    return true;
                }
            }).build().call();
        }
        catch (Exception e) {
            throw new PersistenceException("Failed to fetch all entites", (Throwable)e);
        }
    }

    @Override
    public List<T> find(String cql) throws PersistenceException {
        Preconditions.checkArgument((boolean)StringUtils.left((String)cql, (int)6).equalsIgnoreCase("SELECT"), (Object)"CQL must be SELECT statement");
        try {
            CqlResult results = (CqlResult)this.newQuery().withCql(cql).execute().getResult();
            ArrayList entities = Lists.newArrayListWithExpectedSize((int)results.getRows().size());
            for (Row row : results.getRows()) {
                if (row.getColumns().isEmpty()) continue;
                T entity = this.entityMapper.constructEntityFromCql((ColumnList<ByteBuffer>)row.getColumns());
                this.lifecycleHandler.onPostLoad(entity);
                entities.add(entity);
            }
            return entities;
        }
        catch (Exception e) {
            throw new PersistenceException("Failed to execute cql query", (Throwable)e);
        }
    }

    private MutationBatch getMutationBatch() {
        return this.batchManager.getSharedMutationBatch();
    }

    private ColumnFamilyQuery<K, ByteBuffer> newQuery() {
        ColumnFamilyQuery cfq = this.keyspace.prepareQuery(this.columnFamily);
        if (this.readConsitency != null) {
            cfq.setConsistencyLevel(this.readConsitency);
        }
        if (this.retryPolicy != null) {
            cfq.withRetryPolicy(this.retryPolicy);
        }
        return cfq;
    }

    @Override
    public void createStorage(Map<String, Object> options) throws PersistenceException {
        try {
            Properties props = new Properties();
            props.put("key_validation_class", this.entityMapper.getKeyType());
            props.put("default_validation_class", this.entityMapper.getValueType());
            props.put("comparator_type", this.entityMapper.getComparatorType());
            props.put("name", this.columnFamily.getName());
            LOG.info("Creating column family : " + props.toString());
            this.keyspace.createColumnFamily(props);
        }
        catch (ConnectionException e) {
            throw new PersistenceException("Unable to create column family " + this.columnFamily.getName(), (Throwable)e);
        }
    }

    @Override
    public void deleteStorage() throws PersistenceException {
        try {
            LOG.info(String.format("%s : Deleting storage", this.columnFamily.getName()));
            this.keyspace.dropColumnFamily(this.columnFamily);
        }
        catch (ConnectionException e) {
            throw new PersistenceException("Unable to drop column family " + this.columnFamily.getName(), (Throwable)e);
        }
    }

    @Override
    public void truncate() throws PersistenceException {
        try {
            LOG.info(String.format("%s : Truncating", this.columnFamily.getName()));
            this.keyspace.truncateColumnFamily(this.columnFamily);
        }
        catch (ConnectionException e) {
            throw new PersistenceException("Unable to drop column family " + this.columnFamily.getName(), (Throwable)e);
        }
    }

    @Override
    public void commit() throws PersistenceException {
        MutationBatch mb;
        if (this.verbose) {
            LOG.info(String.format("%s : Commit mutation", this.columnFamily.getName()));
        }
        if ((mb = this.getMutationBatch()) != null) {
            try {
                mb.execute();
            }
            catch (ConnectionException e) {
                throw new PersistenceException("Failed to commit mutation batch", (Throwable)e);
            }
        } else if (this.verbose) {
            LOG.info(String.format("%s : Nothing to commit", this.columnFamily.getName()));
        }
    }

    @Override
    public NativeQuery<T, K> createNativeQuery() {
        return new NativeQuery<T, K>(){

            @Override
            public T getSingleResult() throws PersistenceException {
                return Iterables.getFirst(this.getResultSet(), null);
            }

            @Override
            public Collection<T> getResultSet() throws PersistenceException {
                Preconditions.checkArgument((!this.ids.isEmpty() ? 1 : 0) != 0, (Object)"Must specify at least one row key (ID) to fetch");
                RowSliceQuery rowQuery = this.prepareQuery();
                try {
                    List entities = CompositeEntityManager.this.convertRowsToEntities((Rows)rowQuery.execute().getResult());
                    return entities;
                }
                catch (Exception e) {
                    throw new PersistenceException("Error executing query", (Throwable)e);
                }
            }

            @Override
            public Map<K, Collection<T>> getResultSetById() throws Exception {
                LinkedHashMap result = Maps.newLinkedHashMap();
                for (Object entity : this.getResultSet()) {
                    Object id = ((CompositeEntityManager)CompositeEntityManager.this).entityMapper.idMapper.getValue(entity);
                    Collection children = (Collection)result.get(id);
                    if (children == null) {
                        children = Lists.newArrayListWithCapacity((int)1);
                        result.put(id, children);
                    }
                    children.add(entity);
                }
                return result;
            }

            @Override
            public Map<K, Integer> getResultSetCounts() throws Exception {
                Preconditions.checkArgument((!this.ids.isEmpty() ? 1 : 0) != 0, (Object)"Must specify at least one row key (ID) to fetch");
                RowSliceQuery rowQuery = this.prepareQuery();
                try {
                    Map counts = (Map)rowQuery.getColumnCounts().execute().getResult();
                    return counts;
                }
                catch (Exception e) {
                    throw new PersistenceException("Error executing query", (Throwable)e);
                }
            }

            private RowSliceQuery<K, ByteBuffer> prepareQuery() {
                RowSliceQuery rowQuery = CompositeEntityManager.this.keyspace.prepareQuery(CompositeEntityManager.this.columnFamily).setConsistencyLevel(CompositeEntityManager.this.readConsitency).getRowSlice((Collection)this.ids);
                if (this.predicates != null && !this.predicates.isEmpty()) {
                    ByteBuffer[] endpoints = CompositeEntityManager.this.entityMapper.getQueryEndpoints(this.predicates);
                    rowQuery = rowQuery.withColumnRange(new RangeBuilder().setStart(endpoints[0]).setEnd(endpoints[1]).setLimit(this.columnLimit).build());
                }
                return rowQuery;
            }
        };
    }

    static /* synthetic */ ConsistencyLevel access$000() {
        return DEFAULT_CONSISTENCY_LEVEL;
    }

    public static class Builder<T, K> {
        private Keyspace keyspace;
        private Class<T> clazz;
        private ColumnFamily<K, ByteBuffer> columnFamily = null;
        private ConsistencyLevel readConsitency = CompositeEntityManager.access$000();
        private ConsistencyLevel writeConsistency = CompositeEntityManager.access$000();
        private CompositeEntityMapper<T, K> entityMapper;
        private Integer ttl = null;
        private RetryPolicy retryPolicy = null;
        private LifecycleEvents<T> lifecycleHandler = null;
        private String columnFamilyName = null;
        private boolean autoCommit = true;
        private MutationBatchManager batchManager = null;
        private boolean verbose = false;
        private ByteBuffer prefix = null;

        public Builder<T, K> withEntityType(Class<T> clazz) {
            Preconditions.checkNotNull(clazz);
            this.clazz = clazz;
            return this;
        }

        public Builder<T, K> withKeyspace(Keyspace keyspace) {
            Preconditions.checkNotNull((Object)keyspace);
            this.keyspace = keyspace;
            return this;
        }

        public Builder<T, K> withColumnFamily(String columnFamilyName) {
            Preconditions.checkState((this.columnFamilyName == null && this.columnFamily == null ? 1 : 0) != 0, (Object)"withColumnFamily called multiple times");
            Preconditions.checkNotNull((Object)columnFamilyName);
            this.columnFamilyName = columnFamilyName;
            return this;
        }

        public Builder<T, K> withReadConsistency(ConsistencyLevel level) {
            Preconditions.checkNotNull((Object)level);
            this.readConsitency = level;
            return this;
        }

        public Builder<T, K> withWriteConsistency(ConsistencyLevel level) {
            Preconditions.checkNotNull((Object)level);
            this.writeConsistency = level;
            return this;
        }

        public Builder<T, K> withConsistency(ConsistencyLevel level) {
            Preconditions.checkNotNull((Object)level);
            this.readConsitency = level;
            this.writeConsistency = level;
            return this;
        }

        public Builder<T, K> withTTL(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder<T, K> withRetryPolicy(RetryPolicy policy) {
            Preconditions.checkNotNull((Object)policy);
            this.retryPolicy = policy;
            return this;
        }

        public Builder<T, K> withAutoCommit(boolean autoCommit) {
            Preconditions.checkArgument((!autoCommit && this.batchManager == null ? 1 : 0) != 0, (Object)"Cannot use autoCommit with an externally supplied MutationBatchManager");
            this.autoCommit = autoCommit;
            return this;
        }

        public Builder<T, K> withVerboseTracing(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder<T, K> withMutationBatchManager(MutationBatchManager batchManager) {
            this.batchManager = batchManager;
            this.autoCommit = false;
            return this;
        }

        public Builder<T, K> withKeyPrefix(String prefix) {
            this.prefix = StringSerializer.get().toByteBuffer(prefix);
            return this;
        }

        public CompositeEntityManager<T, K> build() {
            Preconditions.checkNotNull(this.clazz, (Object)"withEntityType(...) is not set");
            Preconditions.checkNotNull((Object)this.keyspace, (Object)"withKeyspace(...) is not set");
            this.entityMapper = new CompositeEntityMapper(this.clazz, this.ttl, this.prefix);
            this.lifecycleHandler = new LifecycleEvents<T>(this.clazz);
            if (this.columnFamily == null) {
                if (this.columnFamilyName == null) {
                    this.columnFamilyName = this.entityMapper.getEntityName();
                }
                this.columnFamily = new ColumnFamily(this.columnFamilyName, MappingUtils.getSerializerForField(this.entityMapper.getId()), (Serializer)ByteBufferSerializer.get());
            }
            if (this.batchManager == null) {
                this.batchManager = new ThreadLocalMutationBatchManager(this.keyspace, this.writeConsistency, this.retryPolicy);
            }
            return new CompositeEntityManager(this);
        }
    }
}

