/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.uniqueness;

import com.google.common.base.Function;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.recipes.locks.ColumnPrefixDistributedRowLock;
import com.netflix.astyanax.recipes.uniqueness.NotUniqueException;
import com.netflix.astyanax.recipes.uniqueness.UniquenessConstraint;
import java.util.Map;

public class ColumnPrefixUniquenessConstraint<K>
implements UniquenessConstraint {
    private final ColumnPrefixDistributedRowLock<K> lock;

    public ColumnPrefixUniquenessConstraint(Keyspace keyspace, ColumnFamily<K, String> columnFamily, K key) {
        this.lock = new ColumnPrefixDistributedRowLock<K>(keyspace, columnFamily, key);
    }

    public ColumnPrefixUniquenessConstraint<K> withTtl(Integer ttl) {
        this.lock.withTtl(ttl);
        return this;
    }

    public ColumnPrefixUniquenessConstraint<K> withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.lock.withConsistencyLevel(consistencyLevel);
        return this;
    }

    public ColumnPrefixUniquenessConstraint<K> withPrefix(String prefix) {
        this.lock.withColumnPrefix(prefix);
        return this;
    }

    public ColumnPrefixUniquenessConstraint<K> withUniqueId(String unique) {
        this.lock.withLockId(unique);
        return this;
    }

    public String readUniqueColumn() throws Exception {
        String column = null;
        for (Map.Entry<String, Long> entry : this.lock.readLockColumns().entrySet()) {
            if (entry.getValue() != 0L) continue;
            if (column == null) {
                column = entry.getKey().substring(this.lock.getPrefix().length());
                continue;
            }
            throw new IllegalStateException("Key has multiple locks");
        }
        if (column == null) {
            throw new NotFoundException("Unique column not found for " + this.lock.getKey());
        }
        return column;
    }

    @Override
    public void acquire() throws NotUniqueException, Exception {
        this.acquireAndApplyMutation(null);
    }

    @Override
    @Deprecated
    public void acquireAndMutate(MutationBatch m) throws NotUniqueException, Exception {
        this.lock.acquire();
        m.lockCurrentTimestamp();
        this.lock.fillReleaseMutation(m, true);
        this.lock.fillLockMutation(m, null, null);
        m.setConsistencyLevel(this.lock.getConsistencyLevel()).execute();
    }

    @Override
    public void acquireAndApplyMutation(Function<MutationBatch, Boolean> callback) throws NotUniqueException, Exception {
        this.lock.acquire();
        MutationBatch mb = this.lock.getKeyspace().prepareMutationBatch();
        if (callback != null) {
            callback.apply((Object)mb);
        }
        this.lock.fillReleaseMutation(mb, true);
        this.lock.fillLockMutation(mb, null, null);
        mb.setConsistencyLevel(this.lock.getConsistencyLevel()).execute();
    }

    @Override
    public void release() throws Exception {
        this.lock.release();
    }
}

