/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.functions;

import com.google.common.base.Function;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.Row;
import java.io.IOException;
import java.io.OutputStream;

public class TraceFunction<K, C>
implements Function<Row<K, C>, Boolean> {
    private final OutputStream out;
    private final boolean showColumns;

    public static <K, C> Builder<K, C> builder(ColumnFamily<K, C> columnFamily) {
        return new Builder<K, C>(columnFamily);
    }

    private TraceFunction(Builder<K, C> builder) {
        this.out = ((Builder)builder).out;
        this.showColumns = ((Builder)builder).showColumns;
    }

    public synchronized Boolean apply(Row<K, C> row) {
        long size = 0L;
        for (Column column : row.getColumns()) {
            size += (long)(column.getRawName().limit() + column.getByteBufferValue().limit());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("- row: '%s' size: '%dl' count: '%dl' \n", row.getKey(), size, row.getColumns().size()));
        if (this.showColumns) {
            for (Column column : row.getColumns()) {
                sb.append(String.format("  '%s' (ts='%dl', ttl='%d')\n", column.getName(), column.getTimestamp(), column.getTtl()));
            }
        }
        try {
            this.out.write(sb.toString().getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static class Builder<K, C> {
        private OutputStream out = System.out;
        private boolean showColumns = false;

        public Builder(ColumnFamily<K, C> columnFamily) {
        }

        public Builder<K, C> withOutputStream(OutputStream out) {
            this.out = out;
            return this;
        }

        public Builder<K, C> withShowColumns(boolean showColumns) {
            this.showColumns = showColumns;
            return this;
        }

        public TraceFunction<K, C> build() {
            return new TraceFunction(this);
        }
    }
}

