/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class StaticColumnFamilyTests
extends KeyspaceTests {
    private static ColumnFamily<String, String> CF_ACCOUNTS = new ColumnFamily("accounts", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        StaticColumnFamilyTests.initContext();
        keyspace.prepareQuery(CF_ACCOUNTS).withCql("CREATE TABLE astyanaxunittests.accounts (userid text PRIMARY KEY, user text, pswd text)").execute();
        CF_ACCOUNTS.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_ACCOUNTS);
    }

    @Test
    public void testReadWriteOpsWithStaticNamedColumns() throws Exception {
        StaticColumnFamilyTests.populateRowsForAccountsTable(keyspace);
        Thread.sleep(200L);
        boolean rowDeleted = false;
        this.performSimpleRowQuery(rowDeleted);
        this.performSimpleRowQueryWithColumnCollection(rowDeleted);
        this.performSimpleRowSingleColumnQuery(rowDeleted);
        this.performRowSliceQueryWithAllColumns(rowDeleted);
        this.performRowSliceQueryWithColumnSlice(rowDeleted);
        StaticColumnFamilyTests.deleteRowsForAccountsTable(keyspace);
        Thread.sleep(200L);
        rowDeleted = true;
        this.performSimpleRowQuery(rowDeleted);
        this.performSimpleRowQueryWithColumnCollection(rowDeleted);
        this.performSimpleRowSingleColumnQuery(rowDeleted);
        this.performRowSliceQueryWithAllColumns(rowDeleted);
        this.performRowSliceQueryWithColumnSlice(rowDeleted);
    }

    private void performSimpleRowQuery(boolean rowDeleted) throws Exception {
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            String key = Character.toString(keyName);
            this.performSimpleRowQueryForRow(key, rowDeleted, key);
        }
    }

    private void performSimpleRowQueryForRow(String rowKey, boolean rowDeleted, String expectedChar) throws Exception {
        ColumnList result = (ColumnList)keyspace.prepareQuery(CF_ACCOUNTS).getRow((Object)rowKey).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)result.isEmpty());
        } else {
            Assert.assertFalse((boolean)result.isEmpty());
            Column col = result.getColumnByName((Object)"user");
            Assert.assertEquals((String)("user" + expectedChar), (String)col.getStringValue());
            col = result.getColumnByName((Object)"pswd");
            Assert.assertEquals((String)("pswd" + expectedChar), (String)col.getStringValue());
        }
    }

    private void performSimpleRowQueryWithColumnCollection(boolean rowDeleted) throws Exception {
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            String key = Character.toString(keyName);
            this.performSimpleRowQueryWithColumnCollectionForRow(key, rowDeleted, key);
        }
    }

    private void performSimpleRowQueryWithColumnCollectionForRow(String rowKey, boolean rowDeleted, String expectedChar) throws Exception {
        Column col;
        Column col2;
        ColumnList result = (ColumnList)keyspace.prepareQuery(CF_ACCOUNTS).getRow((Object)rowKey).withColumnSlice((Object[])new String[]{"user", "pswd"}).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)result.isEmpty());
        } else {
            Assert.assertFalse((boolean)result.isEmpty());
            col2 = result.getColumnByName((Object)"user");
            Assert.assertEquals((String)("user" + expectedChar), (String)col2.getStringValue());
            col2 = result.getColumnByName((Object)"pswd");
            Assert.assertEquals((String)("pswd" + expectedChar), (String)col2.getStringValue());
        }
        result = (ColumnList)keyspace.prepareQuery(CF_ACCOUNTS).getRow((Object)rowKey).withColumnSlice((Object[])new String[]{"user"}).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)result.isEmpty());
        } else {
            Assert.assertFalse((boolean)result.isEmpty());
            col2 = result.getColumnByName((Object)"user");
            Assert.assertEquals((String)("user" + expectedChar), (String)col2.getStringValue());
        }
        result = (ColumnList)keyspace.prepareQuery(CF_ACCOUNTS).getRow((Object)rowKey).withColumnSlice((Object[])new String[]{"pswd"}).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)result.isEmpty());
        } else {
            Assert.assertFalse((boolean)result.isEmpty());
            col2 = result.getColumnByName((Object)"pswd");
            Assert.assertEquals((String)("pswd" + expectedChar), (String)col2.getStringValue());
        }
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("user");
        cols.add("pswd");
        result = (ColumnList)keyspace.prepareQuery(CF_ACCOUNTS).getRow((Object)rowKey).withColumnSlice(cols).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)result.isEmpty());
        } else {
            Assert.assertFalse((boolean)result.isEmpty());
            col = result.getColumnByName((Object)"user");
            Assert.assertEquals((String)("user" + expectedChar), (String)col.getStringValue());
            col = result.getColumnByName((Object)"pswd");
            Assert.assertEquals((String)("pswd" + expectedChar), (String)col.getStringValue());
        }
        cols.remove("user");
        result = (ColumnList)keyspace.prepareQuery(CF_ACCOUNTS).getRow((Object)rowKey).withColumnSlice(cols).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)result.isEmpty());
        } else {
            Assert.assertFalse((boolean)result.isEmpty());
            col = result.getColumnByName((Object)"pswd");
            Assert.assertEquals((String)("pswd" + expectedChar), (String)col.getStringValue());
        }
    }

    private void performSimpleRowSingleColumnQuery(boolean rowDeleted) throws Exception {
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            String key = Character.toString(keyName);
            this.performSimpleRowSingleColumnQueryForRow(key, rowDeleted, key);
        }
    }

    private void performSimpleRowSingleColumnQueryForRow(String rowKey, boolean rowDeleted, String expectedChar) throws Exception {
        Column col = (Column)keyspace.prepareQuery(CF_ACCOUNTS).getRow((Object)rowKey).getColumn((Object)"user").execute().getResult();
        if (rowDeleted) {
            Assert.assertNull((Object)col);
        } else {
            Assert.assertTrue((boolean)col.hasValue());
            Assert.assertEquals((String)("user" + expectedChar), (String)col.getStringValue());
        }
        col = (Column)keyspace.prepareQuery(CF_ACCOUNTS).getRow((Object)rowKey).getColumn((Object)"pswd").execute().getResult();
        if (rowDeleted) {
            Assert.assertNull((Object)col);
        } else {
            Assert.assertTrue((boolean)col.hasValue());
            Assert.assertEquals((String)("pswd" + expectedChar), (String)col.getStringValue());
        }
    }

    private void performRowSliceQueryWithAllColumns(boolean rowDeleted) throws Exception {
        ArrayList<String> keys = new ArrayList<String>();
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            keys.add(Character.toString(keyName));
        }
        int index = 0;
        Rows rows = (Rows)keyspace.prepareQuery(CF_ACCOUNTS).getRowSlice(keys).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)rows.isEmpty());
        } else {
            Assert.assertFalse((boolean)rows.isEmpty());
            for (Row row : rows) {
                Assert.assertEquals((String)((String)keys.get(index)), (String)((String)row.getKey()));
                ColumnList cols = row.getColumns();
                Assert.assertFalse((boolean)cols.isEmpty());
                Column col = cols.getColumnByName((Object)"user");
                Assert.assertEquals((String)("user" + (String)keys.get(index)), (String)col.getStringValue());
                col = cols.getColumnByName((Object)"pswd");
                Assert.assertEquals((String)("pswd" + (String)keys.get(index)), (String)col.getStringValue());
                ++index;
            }
        }
    }

    private void performRowSliceQueryWithColumnSlice(boolean rowDeleted) throws Exception {
        Column col;
        ColumnList cols;
        ArrayList<String> keys = new ArrayList<String>();
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            keys.add(Character.toString(keyName));
        }
        int index = 0;
        Rows rows = (Rows)keyspace.prepareQuery(CF_ACCOUNTS).getRowSlice(keys).withColumnSlice((Object[])new String[]{"user", "pswd"}).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)rows.isEmpty());
        } else {
            Assert.assertFalse((boolean)rows.isEmpty());
            for (Row row : rows) {
                Assert.assertEquals((String)((String)keys.get(index)), (String)((String)row.getKey()));
                cols = row.getColumns();
                Assert.assertFalse((boolean)cols.isEmpty());
                col = cols.getColumnByName((Object)"user");
                Assert.assertEquals((String)("user" + (String)keys.get(index)), (String)col.getStringValue());
                col = cols.getColumnByName((Object)"pswd");
                Assert.assertEquals((String)("pswd" + (String)keys.get(index)), (String)col.getStringValue());
                ++index;
            }
        }
        index = 0;
        rows = (Rows)keyspace.prepareQuery(CF_ACCOUNTS).getRowSlice(keys).withColumnSlice((Object[])new String[]{"user"}).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)rows.isEmpty());
        } else {
            Assert.assertFalse((boolean)rows.isEmpty());
            for (Row row : rows) {
                Assert.assertEquals((String)((String)keys.get(index)), (String)((String)row.getKey()));
                cols = row.getColumns();
                Assert.assertFalse((boolean)cols.isEmpty());
                col = cols.getColumnByName((Object)"user");
                Assert.assertEquals((String)("user" + (String)keys.get(index)), (String)col.getStringValue());
                ++index;
            }
        }
        index = 0;
        rows = (Rows)keyspace.prepareQuery(CF_ACCOUNTS).getRowSlice(keys).withColumnSlice((Object[])new String[]{"pswd"}).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)rows.isEmpty());
        } else {
            Assert.assertFalse((boolean)rows.isEmpty());
            for (Row row : rows) {
                Assert.assertEquals((String)((String)keys.get(index)), (String)((String)row.getKey()));
                cols = row.getColumns();
                Assert.assertFalse((boolean)cols.isEmpty());
                col = cols.getColumnByName((Object)"pswd");
                Assert.assertEquals((String)("pswd" + (String)keys.get(index)), (String)col.getStringValue());
                ++index;
            }
        }
    }

    public static void populateRowsForAccountsTable(Keyspace keyspace) throws Exception {
        MutationBatch m = keyspace.prepareMutationBatch();
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            String character = Character.toString(keyName);
            ColumnListMutation colMutation = m.withRow(CF_ACCOUNTS, (Object)character);
            colMutation.putColumn((Object)"user", "user" + character).putColumn((Object)"pswd", "pswd" + character);
            m.execute();
            m.discardMutations();
        }
    }

    public static void deleteRowsForAccountsTable(Keyspace keyspace) throws Exception {
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            MutationBatch m = keyspace.prepareMutationBatch();
            String rowKey = Character.toString(keyName);
            m.withRow(CF_ACCOUNTS, (Object)rowKey).delete();
            m.execute();
            m.discardMutations();
        }
    }
}

