/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test.recipes;

import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.recipes.locks.BusyLockException;
import com.netflix.astyanax.recipes.locks.ColumnPrefixDistributedRowLock;
import com.netflix.astyanax.recipes.locks.StaleLockException;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ColumnPrefixDistributedLockTest
extends KeyspaceTests {
    public static ColumnFamily<String, String> CF_DIST_LOCK = ColumnFamily.newColumnFamily((String)"distlock", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        ColumnPrefixDistributedLockTest.initContext();
        keyspace.createColumnFamily(CF_DIST_LOCK, null);
        CF_DIST_LOCK.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_DIST_LOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLockSuccess() throws Exception {
        ColumnPrefixDistributedRowLock lock = new ColumnPrefixDistributedRowLock(keyspace, CF_DIST_LOCK, (Object)"RowKeyToLock").expireLockAfter(1L, TimeUnit.SECONDS).withConsistencyLevel(ConsistencyLevel.CL_ONE);
        try {
            lock.acquire();
            System.out.println("Successfully acquired lock");
        }
        catch (StaleLockException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (BusyLockException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            lock.release();
        }
        ColumnList result = (ColumnList)keyspace.prepareQuery(CF_DIST_LOCK).getRow((Object)"RowKeyToLock").execute().getResult();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testStaleLock() throws Exception {
        String rowKey = "StaleRowKeyToLock";
        String lockPrefix = "TestLockPrefix";
        Long pastTime = System.currentTimeMillis() - 2000L;
        Long timeInMicros = TimeUnit.MICROSECONDS.convert(pastTime, TimeUnit.MILLISECONDS);
        MutationBatch m = keyspace.prepareMutationBatch();
        m.withRow(CF_DIST_LOCK, (Object)rowKey).putColumn((Object)(lockPrefix + "1"), timeInMicros.longValue());
        m.execute();
        ColumnPrefixDistributedRowLock lock = new ColumnPrefixDistributedRowLock(keyspace, CF_DIST_LOCK, (Object)rowKey).withColumnPrefix(lockPrefix).expireLockAfter(1L, TimeUnit.SECONDS).failOnStaleLock(true).withConsistencyLevel(ConsistencyLevel.CL_ONE);
        try {
            lock.acquire();
            Assert.fail((String)"Acquired lock when there was a STALE LOCK");
        }
        catch (StaleLockException e) {
            System.out.println("STALE LOCK " + e.getMessage());
            lock.releaseExpiredLocks();
            lock.release();
        }
        ColumnList result = (ColumnList)keyspace.prepareQuery(CF_DIST_LOCK).getRow((Object)rowKey).execute().getResult();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testBusyLock() throws Exception {
        String rowKey = "BusyRowKeyToLock";
        String lockPrefix = "TestLockPrefix";
        Long futureTime = System.currentTimeMillis() + 20000L;
        Long timeInMicros = TimeUnit.MICROSECONDS.convert(futureTime, TimeUnit.MILLISECONDS);
        MutationBatch m = keyspace.prepareMutationBatch();
        m.withRow(CF_DIST_LOCK, (Object)rowKey).putColumn((Object)(lockPrefix + "1"), timeInMicros.longValue());
        m.execute();
        ColumnPrefixDistributedRowLock lock = new ColumnPrefixDistributedRowLock(keyspace, CF_DIST_LOCK, (Object)rowKey).withColumnPrefix(lockPrefix).expireLockAfter(1L, TimeUnit.SECONDS).failOnStaleLock(true).withConsistencyLevel(ConsistencyLevel.CL_ONE);
        try {
            lock.acquire();
            Assert.fail((String)"Acquired lock when there was a STALE LOCK");
        }
        catch (BusyLockException e) {
            System.out.println("BUSY LOCK " + e.getMessage());
            lock.releaseAllLocks();
        }
        ColumnList result = (ColumnList)keyspace.prepareQuery(CF_DIST_LOCK).getRow((Object)rowKey).execute().getResult();
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

