/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test.utils;

import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.MetricsOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.Policies;
import com.google.common.base.Supplier;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.Cluster;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.NodeDiscoveryType;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolType;
import com.netflix.astyanax.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.astyanax.cql.CqlFamilyFactory;
import com.netflix.astyanax.cql.JavaDriverConnectionPoolConfigurationImpl;
import com.netflix.astyanax.cql.test.utils.ClusterConfiguration;
import com.netflix.astyanax.impl.AstyanaxConfigurationImpl;
import com.netflix.astyanax.thrift.ThriftFamilyFactory;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.PropertyConfigurator;

public class AstyanaxContextFactory {
    private static final AtomicReference<Keyspace> keyspaceReference = new AtomicReference<Object>(null);

    public static AstyanaxContext<Cluster> getCluster() {
        return AstyanaxContextFactory.getCluster(ClusterConfiguration.TEST_CLUSTER_NAME, ClusterConfiguration.TheDriver);
    }

    public static AstyanaxContext<Cluster> getCluster(String clusterName, ClusterConfiguration.Driver driver) {
        if (driver == ClusterConfiguration.Driver.JAVA_DRIVER) {
            return AstyanaxContextFactory.clusterWithJavaDriver(clusterName);
        }
        return AstyanaxContextFactory.clusterWithThriftDriver(clusterName);
    }

    private static AstyanaxContext<Cluster> clusterWithJavaDriver(String clusterName) {
        String SEEDS = "localhost";
        Supplier<List<Host>> HostSupplier = new Supplier<List<Host>>(){

            public List<Host> get() {
                Host host = new Host("localhost", -1);
                return Collections.singletonList(host);
            }
        };
        AstyanaxContext context = new AstyanaxContext.Builder().forCluster(clusterName).withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setDiscoveryType(NodeDiscoveryType.RING_DESCRIBE).setDiscoveryDelayInSeconds(60000)).withConnectionPoolConfiguration((ConnectionPoolConfiguration)new ConnectionPoolConfigurationImpl(ClusterConfiguration.TEST_CLUSTER_NAME + "_" + ClusterConfiguration.TEST_KEYSPACE_NAME).setSocketTimeout(30000).setMaxTimeoutWhenExhausted(2000).setMaxConnsPerHost(20).setInitConnsPerHost(10).setSeeds("localhost").setPort(9042)).withHostSupplier((Supplier)HostSupplier).withConnectionPoolMonitor((ConnectionPoolMonitor)new CountingConnectionPoolMonitor()).buildCluster((AstyanaxTypeFactory)CqlFamilyFactory.getInstance());
        return context;
    }

    private static AstyanaxContext<Cluster> clusterWithThriftDriver(String clusterName) {
        String SEEDS = "localhost";
        Supplier<List<Host>> HostSupplier = new Supplier<List<Host>>(){

            public List<Host> get() {
                Host host = new Host("localhost", -1);
                return Collections.singletonList(host);
            }
        };
        AstyanaxContext context = new AstyanaxContext.Builder().forCluster(clusterName).withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setDiscoveryType(NodeDiscoveryType.DISCOVERY_SERVICE).setConnectionPoolType(ConnectionPoolType.ROUND_ROBIN).setDiscoveryDelayInSeconds(60000)).withConnectionPoolConfiguration((ConnectionPoolConfiguration)new ConnectionPoolConfigurationImpl(ClusterConfiguration.TEST_CLUSTER_NAME + "_" + ClusterConfiguration.TEST_KEYSPACE_NAME).setSocketTimeout(30000).setMaxTimeoutWhenExhausted(2000).setMaxConnsPerHost(20).setInitConnsPerHost(10).setSeeds("localhost").setPort(9160)).withHostSupplier((Supplier)HostSupplier).withConnectionPoolMonitor((ConnectionPoolMonitor)new CountingConnectionPoolMonitor()).buildCluster((AstyanaxTypeFactory)ThriftFamilyFactory.getInstance());
        return context;
    }

    public static AstyanaxContext<Keyspace> getKeyspace() {
        return AstyanaxContextFactory.getKeyspace(ClusterConfiguration.TEST_KEYSPACE_NAME, ClusterConfiguration.TheDriver);
    }

    public static AstyanaxContext<Keyspace> getKeyspace(String keyspaceName) {
        return AstyanaxContextFactory.getKeyspace(keyspaceName, ClusterConfiguration.TheDriver);
    }

    public static AstyanaxContext<Keyspace> getKeyspace(String keyspaceName, ClusterConfiguration.Driver driver) {
        if (driver == ClusterConfiguration.Driver.THRIFT) {
            return AstyanaxContextFactory.keyspaceWithThriftDriver(keyspaceName);
        }
        return AstyanaxContextFactory.keyspaceWithJavaDriver(keyspaceName);
    }

    private static AstyanaxContext<Keyspace> keyspaceWithJavaDriver(String keyspaceName) {
        String SEEDS = "localhost";
        Supplier<List<Host>> HostSupplier = new Supplier<List<Host>>(){

            public List<Host> get() {
                Host host = new Host("localhost", -1);
                return Collections.singletonList(host);
            }
        };
        ProtocolOptions protocolOptions = new ProtocolOptions(9042);
        Configuration jdConfig = new Configuration(new Policies(), protocolOptions, new PoolingOptions(), new SocketOptions(), new MetricsOptions(), new QueryOptions());
        AstyanaxContext context = new AstyanaxContext.Builder().forKeyspace(keyspaceName).withHostSupplier((Supplier)HostSupplier).withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl()).withConnectionPoolConfiguration((ConnectionPoolConfiguration)new JavaDriverConnectionPoolConfigurationImpl(jdConfig)).buildKeyspace((AstyanaxTypeFactory)CqlFamilyFactory.getInstance());
        return context;
    }

    private static AstyanaxContext<Keyspace> keyspaceWithThriftDriver(String keyspaceName) {
        String SEEDS = "localhost";
        Supplier<List<Host>> HostSupplier = new Supplier<List<Host>>(){

            public List<Host> get() {
                Host host = new Host("localhost", 9160);
                return Collections.singletonList(host);
            }
        };
        AstyanaxContext context = new AstyanaxContext.Builder().forCluster(ClusterConfiguration.TEST_CLUSTER_NAME).forKeyspace(keyspaceName).withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setDiscoveryType(NodeDiscoveryType.DISCOVERY_SERVICE).setConnectionPoolType(ConnectionPoolType.ROUND_ROBIN).setDiscoveryDelayInSeconds(60000).setTargetCassandraVersion("1.2")).withConnectionPoolConfiguration((ConnectionPoolConfiguration)new ConnectionPoolConfigurationImpl(ClusterConfiguration.TEST_CLUSTER_NAME + "_" + ClusterConfiguration.TEST_KEYSPACE_NAME).setSocketTimeout(30000).setMaxTimeoutWhenExhausted(2000).setMaxConnsPerHost(20).setInitConnsPerHost(10).setSeeds("localhost").setPort(9160)).withHostSupplier((Supplier)HostSupplier).withConnectionPoolMonitor((ConnectionPoolMonitor)new CountingConnectionPoolMonitor()).buildKeyspace((AstyanaxTypeFactory)ThriftFamilyFactory.getInstance());
        return context;
    }

    public static Keyspace getCachedKeyspace() {
        return keyspaceReference.get();
    }

    static {
        PropertyConfigurator.configure((String)"./src/main/java/test-log4j.properties");
        AstyanaxContext<Keyspace> context = AstyanaxContextFactory.getKeyspace();
        context.start();
        keyspaceReference.set((Keyspace)context.getClient());
    }
}

