/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.google.common.collect.ImmutableMap;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.annotations.Component;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.serializers.AnnotatedCompositeSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.Map;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class MockCompositeTypeTests
extends KeyspaceTests {
    private static final Logger LOG = Logger.getLogger(MockCompositeTypeTests.class);
    private static AnnotatedCompositeSerializer<MockCompositeType> M_SERIALIZER = new AnnotatedCompositeSerializer(MockCompositeType.class);
    private static ColumnFamily<String, MockCompositeType> CF_COMPOSITE = ColumnFamily.newColumnFamily((String)"mockcompositetype", (Serializer)StringSerializer.get(), M_SERIALIZER);

    @BeforeClass
    public static void init() throws Exception {
        MockCompositeTypeTests.initContext();
        keyspace.createColumnFamily(CF_COMPOSITE, (Map)ImmutableMap.builder().put((Object)"comparator_type", (Object)"CompositeType(AsciiType, IntegerType, IntegerType, BytesType, UTF8Type)").build());
        CF_COMPOSITE.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_COMPOSITE);
    }

    @Test
    public void testComposite() throws Exception {
        String rowKey = "Composite1";
        boolean bool = false;
        MutationBatch m = keyspace.prepareMutationBatch();
        ColumnListMutation mRow = m.withRow(CF_COMPOSITE, (Object)rowKey);
        int columnCount = 0;
        for (char part1 = 'a'; part1 <= 'b'; part1 = (char)((char)(part1 + 1))) {
            for (int part2 = 0; part2 < 10; ++part2) {
                for (int part3 = 10; part3 < 11; ++part3) {
                    bool = !bool;
                    ++columnCount;
                    mRow.putEmptyColumn((Object)new MockCompositeType(Character.toString(part1), part2, part3, bool, "UTF"), null);
                }
            }
        }
        m.execute();
        LOG.info((Object)("Created " + columnCount + " columns"));
        OperationResult result = keyspace.prepareQuery(CF_COMPOSITE).getKey((Object)rowKey).execute();
        Assert.assertEquals((int)columnCount, (int)((ColumnList)result.getResult()).size());
        for (Column col : (ColumnList)result.getResult()) {
            LOG.info((Object)("COLUMN: " + ((MockCompositeType)col.getName()).toString()));
        }
        Column column = (Column)keyspace.prepareQuery(CF_COMPOSITE).getKey((Object)rowKey).getColumn((Object)new MockCompositeType("a", 0, 10, true, "UTF")).execute().getResult();
        LOG.info((Object)("Got single column: " + ((MockCompositeType)column.getName()).toString()));
        Assert.assertNotNull((Object)column);
        Assert.assertEquals((String)"MockCompositeType[a,0,10,true,UTF]", (String)((MockCompositeType)column.getName()).toString());
        LOG.info((Object)"Range builder");
        result = keyspace.prepareQuery(CF_COMPOSITE).getKey((Object)rowKey).withColumnRange((ByteBufferRange)M_SERIALIZER.buildRange().withPrefix((Object)"a").greaterThanEquals((Object)1).lessThanEquals((Object)1).build()).execute();
        Assert.assertTrue((1 == ((ColumnList)result.getResult()).size() ? 1 : 0) != 0);
        for (Column col : (ColumnList)result.getResult()) {
            LOG.info((Object)("COLUMN: " + ((MockCompositeType)col.getName()).toString()));
            Assert.assertEquals((String)"MockCompositeType[a,1,10,false,UTF]", (String)((MockCompositeType)col.getName()).toString());
        }
    }

    public static class MockCompositeType {
        @Component
        private String stringPart;
        @Component
        private Integer intPart;
        @Component
        private Integer intPart2;
        @Component
        private boolean boolPart;
        @Component
        private String utf8StringPart;

        public MockCompositeType() {
        }

        public MockCompositeType(String part1, Integer part2, Integer part3, boolean boolPart, String utf8StringPart) {
            this.stringPart = part1;
            this.intPart = part2;
            this.intPart2 = part3;
            this.boolPart = boolPart;
            this.utf8StringPart = utf8StringPart;
        }

        public MockCompositeType setStringPart(String part) {
            this.stringPart = part;
            return this;
        }

        public String getStringPart() {
            return this.stringPart;
        }

        public MockCompositeType setIntPart1(int value) {
            this.intPart = value;
            return this;
        }

        public int getIntPart1() {
            return this.intPart;
        }

        public MockCompositeType setIntPart2(int value) {
            this.intPart2 = value;
            return this;
        }

        public int getIntPart2() {
            return this.intPart2;
        }

        public MockCompositeType setBoolPart(boolean boolPart) {
            this.boolPart = boolPart;
            return this;
        }

        public boolean getBoolPart() {
            return this.boolPart;
        }

        public MockCompositeType setUtf8StringPart(String str) {
            this.utf8StringPart = str;
            return this;
        }

        public String getUtf8StringPart() {
            return this.utf8StringPart;
        }

        public String toString() {
            return "MockCompositeType[" + this.stringPart + ',' + this.intPart + ',' + this.intPart2 + ',' + this.boolPart + ',' + this.utf8StringPart + ']';
        }
    }
}

