/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test.recipes;

import com.google.common.base.Function;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.partitioner.Murmur3Partitioner;
import com.netflix.astyanax.recipes.reader.AllRowsReader;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class AllRowsReaderTest
extends KeyspaceTests {
    public static ColumnFamily<String, String> CF_ALL_ROWS_READER = ColumnFamily.newColumnFamily((String)"allrowsreader", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        AllRowsReaderTest.initContext();
        keyspace.createColumnFamily(CF_ALL_ROWS_READER, null);
        CF_ALL_ROWS_READER.describe(keyspace);
        MutationBatch m = keyspace.prepareMutationBatch();
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            String rowKey = Character.toString(keyName);
            ColumnListMutation cfmStandard = m.withRow(CF_ALL_ROWS_READER, (Object)rowKey);
            for (char cName = 'a'; cName <= 'z'; cName = (char)(cName + '\u0001')) {
                cfmStandard.putColumn((Object)Character.toString(cName), cName - 97 + 1, null);
            }
            m.execute();
            m.discardMutations();
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_ALL_ROWS_READER);
    }

    @Test
    public void testAllRowsReader() throws Exception {
        final AtomicInteger rowCount = new AtomicInteger(0);
        new AllRowsReader.Builder(keyspace, CF_ALL_ROWS_READER).withPageSize(100).withConcurrencyLevel(10).withPartitioner(Murmur3Partitioner.get()).forEachPage((Function)new Function<Rows<String, String>, Boolean>(){

            public Boolean apply(Rows<String, String> rows) {
                for (Row row : rows) {
                    ColumnList colList = row.getColumns();
                    Assert.assertTrue((String)("ColList: " + colList.size()), (26 == colList.size() ? 1 : 0) != 0);
                    rowCount.incrementAndGet();
                }
                return true;
            }
        }).build().call();
        Assert.assertTrue((String)("RowCount: " + rowCount.get()), (26 == rowCount.get() ? 1 : 0) != 0);
    }
}

