/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.grpc.server;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.grpc.server.GrpcServerRequestContext;
import com.netflix.concurrency.limits.internal.Preconditions;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrencyLimitServerInterceptor
implements ServerInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ConcurrencyLimitServerInterceptor.class);
    private static final Status LIMIT_EXCEEDED_STATUS = Status.UNAVAILABLE.withDescription("Server concurrency limit reached");
    private final Limiter<GrpcServerRequestContext> grpcLimiter;
    private final Supplier<Status> statusSupplier;
    private Supplier<Metadata> trailerSupplier;

    public static Builder newBuilder(Limiter<GrpcServerRequestContext> grpcLimiter) {
        return new Builder(grpcLimiter);
    }

    @Deprecated
    public ConcurrencyLimitServerInterceptor(Limiter<GrpcServerRequestContext> grpcLimiter) {
        Preconditions.checkArgument((grpcLimiter != null ? 1 : 0) != 0, (Object)"grpcLimiter cannot be null");
        this.grpcLimiter = grpcLimiter;
        this.statusSupplier = () -> LIMIT_EXCEEDED_STATUS;
        this.trailerSupplier = Metadata::new;
    }

    private ConcurrencyLimitServerInterceptor(Builder builder) {
        this.grpcLimiter = builder.grpcLimiter;
        this.statusSupplier = builder.statusSupplier;
        this.trailerSupplier = builder.trailerSupplier;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, final ServerCallHandler<ReqT, RespT> next) {
        if (!call.getMethodDescriptor().getType().serverSendsOneMessage() || !call.getMethodDescriptor().getType().clientSendsOneMessage()) {
            return next.startCall(call, headers);
        }
        return this.grpcLimiter.acquire((Object)new GrpcServerRequestContext(){

            @Override
            public ServerCall<?, ?> getCall() {
                return call;
            }

            @Override
            public Metadata getHeaders() {
                return headers;
            }
        }).map(new Function<Limiter.Listener, ServerCall.Listener<ReqT>>(){
            final AtomicBoolean done = new AtomicBoolean(false);

            void safeComplete(Runnable action) {
                if (this.done.compareAndSet(false, true)) {
                    try {
                        action.run();
                    }
                    catch (Throwable t) {
                        LOG.error("Critical error releasing limit", t);
                    }
                }
            }

            @Override
            public ServerCall.Listener<ReqT> apply(final Limiter.Listener listener) {
                ServerCall.Listener delegate;
                try {
                    delegate = next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                        public void close(Status status, Metadata trailers) {
                            try {
                                super.close(status, trailers);
                            }
                            finally {
                                this.safeComplete(() -> {
                                    switch (status.getCode()) {
                                        case CANCELLED: 
                                        case DEADLINE_EXCEEDED: {
                                            listener.onDropped();
                                            break;
                                        }
                                        default: {
                                            listener.onSuccess();
                                        }
                                    }
                                });
                            }
                        }
                    }, headers);
                }
                catch (Exception e) {
                    LOG.warn("Failed to create call", (Throwable)e);
                    this.safeComplete(() -> ((Limiter.Listener)listener).onIgnore());
                    throw e;
                }
                return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(delegate){

                    public void onMessage(ReqT message) {
                        try {
                            super.onMessage(message);
                        }
                        catch (Throwable t) {
                            LOG.error("Uncaught exception. Force releasing limit. ", t);
                            this.safeComplete(() -> ((Limiter.Listener)listener).onIgnore());
                            throw t;
                        }
                    }

                    public void onHalfClose() {
                        try {
                            super.onHalfClose();
                        }
                        catch (Throwable t) {
                            LOG.error("Uncaught exception. Force releasing limit. ", t);
                            this.safeComplete(() -> ((Limiter.Listener)listener).onIgnore());
                            throw t;
                        }
                    }

                    public void onCancel() {
                        try {
                            super.onCancel();
                        }
                        finally {
                            this.safeComplete(() -> ((Limiter.Listener)listener).onDropped());
                        }
                    }
                };
            }
        }).orElseGet(() -> {
            call.close(this.statusSupplier.get(), this.trailerSupplier.get());
            return new ServerCall.Listener<ReqT>(){};
        });
    }

    public static class Builder {
        private Supplier<Status> statusSupplier = () -> ConcurrencyLimitServerInterceptor.access$100();
        private Supplier<Metadata> trailerSupplier = Metadata::new;
        private final Limiter<GrpcServerRequestContext> grpcLimiter;

        public Builder(Limiter<GrpcServerRequestContext> grpcLimiter) {
            Preconditions.checkArgument((grpcLimiter != null ? 1 : 0) != 0, (Object)"grpcLimiter cannot be null");
            this.grpcLimiter = grpcLimiter;
        }

        public Builder statusSupplier(Supplier<Status> supplier) {
            Preconditions.checkArgument((supplier != null ? 1 : 0) != 0, (Object)"statusSupplier cannot be null");
            this.statusSupplier = supplier;
            return this;
        }

        public Builder trailerSupplier(Supplier<Metadata> supplier) {
            Preconditions.checkArgument((supplier != null ? 1 : 0) != 0, (Object)"trailerSupplier cannot be null");
            this.trailerSupplier = supplier;
            return this;
        }

        public ConcurrencyLimitServerInterceptor build() {
            return new ConcurrencyLimitServerInterceptor(this);
        }
    }
}

