/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.servlet.jakarta;

import com.netflix.concurrency.limits.Limiter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;

public class ConcurrencyLimitServletFilter
implements Filter {
    private static final int STATUS_TOO_MANY_REQUESTS = 429;
    private final Limiter<HttpServletRequest> limiter;
    private final int throttleStatus;

    public ConcurrencyLimitServletFilter(Limiter<HttpServletRequest> limiter) {
        this(limiter, 429);
    }

    public ConcurrencyLimitServletFilter(Limiter<HttpServletRequest> limiter, int throttleStatus) {
        this.limiter = limiter;
        this.throttleStatus = throttleStatus;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Optional listener = this.limiter.acquire((Object)((HttpServletRequest)request));
        if (listener.isPresent()) {
            try {
                chain.doFilter(request, response);
                ((Limiter.Listener)listener.get()).onSuccess();
            }
            catch (Exception e) {
                ((Limiter.Listener)listener.get()).onIgnore();
                throw e;
            }
        } else {
            this.outputThrottleError((HttpServletResponse)response);
        }
    }

    protected void outputThrottleError(HttpServletResponse response) {
        try {
            response.setStatus(this.throttleStatus);
            response.getWriter().print("Concurrency limit exceeded");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void destroy() {
    }
}

