/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.contribs.queue.amqp.config;

import com.netflix.conductor.contribs.queue.amqp.AMQPObservableQueue;
import com.netflix.conductor.contribs.queue.amqp.config.AMQPEventQueueProperties;
import com.netflix.conductor.contribs.queue.amqp.config.AMQPEventQueueProvider;
import com.netflix.conductor.core.config.ConductorProperties;
import com.netflix.conductor.core.events.EventQueueProvider;
import com.netflix.conductor.core.events.queue.ObservableQueue;
import com.netflix.conductor.model.TaskModel;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={AMQPEventQueueProperties.class})
@ConditionalOnProperty(name={"conductor.event-queues.amqp.enabled"}, havingValue="true")
public class AMQPEventQueueConfiguration {
    @Bean
    public EventQueueProvider amqpEventQueueProvider(AMQPEventQueueProperties properties) {
        return new AMQPEventQueueProvider(properties, QUEUE_TYPE.AMQP_QUEUE.getType(), false);
    }

    @Bean
    public EventQueueProvider amqpExchangeEventQueueProvider(AMQPEventQueueProperties properties) {
        return new AMQPEventQueueProvider(properties, QUEUE_TYPE.AMQP_EXCHANGE.getType(), true);
    }

    @ConditionalOnProperty(name={"conductor.default-event-queue.type"}, havingValue="amqp")
    @Bean
    public Map<TaskModel.Status, ObservableQueue> getQueues(ConductorProperties conductorProperties, AMQPEventQueueProperties properties) {
        Object stack = "";
        if (conductorProperties.getStack() != null && conductorProperties.getStack().length() > 0) {
            stack = conductorProperties.getStack() + "_";
        }
        boolean useExchange = properties.isUseExchange();
        TaskModel.Status[] statuses = new TaskModel.Status[]{TaskModel.Status.COMPLETED, TaskModel.Status.FAILED};
        HashMap<TaskModel.Status, ObservableQueue> queues = new HashMap<TaskModel.Status, ObservableQueue>();
        for (TaskModel.Status status : statuses) {
            String queuePrefix = StringUtils.isBlank((CharSequence)properties.getListenerQueuePrefix()) ? conductorProperties.getAppId() + "_amqp_notify_" + (String)stack : properties.getListenerQueuePrefix();
            String queueName = queuePrefix + status.name();
            AMQPObservableQueue queue = new AMQPObservableQueue.Builder(properties).build(useExchange, queueName);
            queues.put(status, queue);
        }
        return queues;
    }

    private static enum QUEUE_TYPE {
        AMQP_QUEUE("amqp_queue"),
        AMQP_EXCHANGE("amqp_exchange");

        private final String type;

        private QUEUE_TYPE(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

