/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.contribs.queue.amqp.util;

import com.netflix.conductor.contribs.queue.amqp.config.AMQPEventQueueProperties;
import com.netflix.conductor.contribs.queue.amqp.util.AMQPConfigurations;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPSettings {
    private static final Pattern URI_PATTERN = Pattern.compile("^(?:amqp\\_(queue|exchange))?\\:?(?<name>[^\\?]+)\\??(?<params>.*)$", 2);
    private String queueOrExchangeName;
    private String eventName;
    private String exchangeType;
    private String exchangeBoundQueueName;
    private String queueType;
    private String routingKey;
    private final String contentEncoding;
    private final String contentType;
    private boolean durable;
    private boolean exclusive;
    private boolean autoDelete;
    private boolean sequentialProcessing;
    private int deliveryMode;
    private final Map<String, Object> arguments = new HashMap<String, Object>();
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQPSettings.class);

    public AMQPSettings(AMQPEventQueueProperties properties) {
        this.durable = properties.isDurable();
        this.exclusive = properties.isExclusive();
        this.autoDelete = properties.isAutoDelete();
        this.contentType = properties.getContentType();
        this.contentEncoding = properties.getContentEncoding();
        this.exchangeType = properties.getExchangeType();
        this.routingKey = "";
        this.queueType = properties.getQueueType();
        this.sequentialProcessing = properties.isSequentialMsgProcessing();
        this.setDeliveryMode(properties.getDeliveryMode());
    }

    public final boolean isDurable() {
        return this.durable;
    }

    public final boolean isExclusive() {
        return this.exclusive;
    }

    public final boolean autoDelete() {
        return this.autoDelete;
    }

    public final Map<String, Object> getArguments() {
        return this.arguments;
    }

    public final String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setQueue(String queueName) {
        if (StringUtils.isEmpty((CharSequence)queueName)) {
            throw new IllegalArgumentException("Queue name for publishing is undefined");
        }
        this.queueOrExchangeName = queueName;
    }

    public String getQueueOrExchangeName() {
        return this.queueOrExchangeName;
    }

    public String getExchangeBoundQueueName() {
        if (StringUtils.isEmpty((CharSequence)this.exchangeBoundQueueName)) {
            return String.format("bound_to_%s", this.queueOrExchangeName);
        }
        return this.exchangeBoundQueueName;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public AMQPSettings setDeliveryMode(int deliveryMode) {
        if (deliveryMode != 1 && deliveryMode != 2) {
            throw new IllegalArgumentException("Delivery mode must be 1 or 2");
        }
        this.deliveryMode = deliveryMode;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public final AMQPSettings fromURI(String queueURI) {
        String queryParams;
        Matcher matcher = URI_PATTERN.matcher(queueURI);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Queue URI doesn't matches the expected regexp");
        }
        LOGGER.info("Queue URI:{}", (Object)queueURI);
        this.queueOrExchangeName = matcher.group("name");
        this.eventName = queueURI;
        if (matcher.groupCount() > 1 && StringUtils.isNotEmpty((CharSequence)(queryParams = matcher.group("params")))) {
            Arrays.stream(queryParams.split("\\s*\\&\\s*")).forEach(param -> {
                String[] kv = param.split("\\s*=\\s*");
                if (kv.length == 2) {
                    String value;
                    if (kv[0].equalsIgnoreCase(String.valueOf((Object)AMQPConfigurations.PARAM_EXCHANGE_TYPE))) {
                        value = kv[1];
                        if (StringUtils.isEmpty((CharSequence)value)) {
                            throw new IllegalArgumentException("The provided exchange type is empty");
                        }
                        this.exchangeType = value;
                    }
                    if (kv[0].equalsIgnoreCase(String.valueOf((Object)AMQPConfigurations.PARAM_QUEUE_NAME))) {
                        this.exchangeBoundQueueName = kv[1];
                    }
                    if (kv[0].equalsIgnoreCase(String.valueOf((Object)AMQPConfigurations.PARAM_ROUTING_KEY))) {
                        value = kv[1];
                        if (StringUtils.isEmpty((CharSequence)value)) {
                            throw new IllegalArgumentException("The provided routing key is empty");
                        }
                        this.routingKey = value;
                    }
                    if (kv[0].equalsIgnoreCase(String.valueOf((Object)AMQPConfigurations.PARAM_DURABLE))) {
                        this.durable = Boolean.parseBoolean(kv[1]);
                    }
                    if (kv[0].equalsIgnoreCase(String.valueOf((Object)AMQPConfigurations.PARAM_EXCLUSIVE))) {
                        this.exclusive = Boolean.parseBoolean(kv[1]);
                    }
                    if (kv[0].equalsIgnoreCase(String.valueOf((Object)AMQPConfigurations.PARAM_AUTO_DELETE))) {
                        this.autoDelete = Boolean.parseBoolean(kv[1]);
                    }
                    if (kv[0].equalsIgnoreCase(String.valueOf((Object)AMQPConfigurations.PARAM_DELIVERY_MODE))) {
                        this.setDeliveryMode(Integer.parseInt(kv[1]));
                    }
                    if (kv[0].equalsIgnoreCase(String.valueOf((Object)AMQPConfigurations.PARAM_MAX_PRIORITY))) {
                        this.arguments.put("x-max-priority", Integer.valueOf(kv[1]));
                    }
                }
            });
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AMQPSettings)) {
            return false;
        }
        AMQPSettings other = (AMQPSettings)obj;
        return Objects.equals(this.arguments, other.arguments) && this.autoDelete == other.autoDelete && Objects.equals(this.contentEncoding, other.contentEncoding) && Objects.equals(this.contentType, other.contentType) && this.deliveryMode == other.deliveryMode && this.durable == other.durable && Objects.equals(this.eventName, other.eventName) && Objects.equals(this.exchangeType, other.exchangeType) && this.exclusive == other.exclusive && Objects.equals(this.queueOrExchangeName, other.queueOrExchangeName) && Objects.equals(this.exchangeBoundQueueName, other.exchangeBoundQueueName) && Objects.equals(this.queueType, other.queueType) && Objects.equals(this.routingKey, other.routingKey) && this.sequentialProcessing == other.sequentialProcessing;
    }

    public int hashCode() {
        return Objects.hash(this.arguments, this.autoDelete, this.contentEncoding, this.contentType, this.deliveryMode, this.durable, this.eventName, this.exchangeType, this.exclusive, this.queueOrExchangeName, this.exchangeBoundQueueName, this.queueType, this.routingKey, this.sequentialProcessing);
    }

    public String toString() {
        return "AMQPSettings [queueOrExchangeName=" + this.queueOrExchangeName + ", eventName=" + this.eventName + ", exchangeType=" + this.exchangeType + ", exchangeQueueName=" + this.exchangeBoundQueueName + ", queueType=" + this.queueType + ", routingKey=" + this.routingKey + ", contentEncoding=" + this.contentEncoding + ", contentType=" + this.contentType + ", durable=" + this.durable + ", exclusive=" + this.exclusive + ", autoDelete=" + this.autoDelete + ", sequentialProcessing=" + this.sequentialProcessing + ", deliveryMode=" + this.deliveryMode + ", arguments=" + this.arguments + "]";
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getQueueType() {
        return this.queueType;
    }

    public boolean isSequentialProcessing() {
        return this.sequentialProcessing;
    }
}

