/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sqs.config;

import com.amazonaws.services.sqs.AmazonSQSClient;
import com.netflix.conductor.core.events.EventQueueProvider;
import com.netflix.conductor.core.events.queue.ObservableQueue;
import com.netflix.conductor.sqs.config.SQSEventQueueProperties;
import com.netflix.conductor.sqs.eventqueue.SQSObservableQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import rx.Scheduler;

public class SQSEventQueueProvider
implements EventQueueProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQSEventQueueProvider.class);
    private final Map<String, ObservableQueue> queues = new ConcurrentHashMap<String, ObservableQueue>();
    private final AmazonSQSClient client;
    private final int batchSize;
    private final long pollTimeInMS;
    private final int visibilityTimeoutInSeconds;
    private final Scheduler scheduler;

    public SQSEventQueueProvider(AmazonSQSClient client, SQSEventQueueProperties properties, Scheduler scheduler) {
        this.client = client;
        this.batchSize = properties.getBatchSize();
        this.pollTimeInMS = properties.getPollTimeDuration().toMillis();
        this.visibilityTimeoutInSeconds = (int)properties.getVisibilityTimeout().getSeconds();
        this.scheduler = scheduler;
    }

    public String getQueueType() {
        return "sqs";
    }

    @NonNull
    public ObservableQueue getQueue(String queueURI) {
        return this.queues.computeIfAbsent(queueURI, q -> new SQSObservableQueue.Builder().withBatchSize(this.batchSize).withClient(this.client).withPollTimeInMS(this.pollTimeInMS).withQueueName(queueURI).withVisibilityTimeout(this.visibilityTimeoutInSeconds).withScheduler(this.scheduler).build());
    }
}

