/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.cassandra.config;

import com.datastax.driver.core.ConsistencyLevel;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="conductor.cassandra")
public class CassandraProperties {
    private String hostAddress = "127.0.0.1";
    private int port = 9142;
    private String cluster = "";
    private String keyspace = "conductor";
    private int shardSize = 100;
    private String replicationStrategy = "SimpleStrategy";
    private String replicationFactorKey = "replication_factor";
    private int replicationFactorValue = 3;
    private ConsistencyLevel readConsistencyLevel = ConsistencyLevel.LOCAL_QUORUM;
    private ConsistencyLevel writeConsistencyLevel = ConsistencyLevel.LOCAL_QUORUM;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration taskDefCacheRefreshInterval = Duration.ofSeconds(60L);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration eventHandlerCacheRefreshInterval = Duration.ofSeconds(60L);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration eventExecutionPersistenceTtl = Duration.ZERO;

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public int getShardSize() {
        return this.shardSize;
    }

    public void setShardSize(int shardSize) {
        this.shardSize = shardSize;
    }

    public String getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public void setReplicationStrategy(String replicationStrategy) {
        this.replicationStrategy = replicationStrategy;
    }

    public String getReplicationFactorKey() {
        return this.replicationFactorKey;
    }

    public void setReplicationFactorKey(String replicationFactorKey) {
        this.replicationFactorKey = replicationFactorKey;
    }

    public int getReplicationFactorValue() {
        return this.replicationFactorValue;
    }

    public void setReplicationFactorValue(int replicationFactorValue) {
        this.replicationFactorValue = replicationFactorValue;
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(ConsistencyLevel readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public void setWriteConsistencyLevel(ConsistencyLevel writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
    }

    public Duration getTaskDefCacheRefreshInterval() {
        return this.taskDefCacheRefreshInterval;
    }

    public void setTaskDefCacheRefreshInterval(Duration taskDefCacheRefreshInterval) {
        this.taskDefCacheRefreshInterval = taskDefCacheRefreshInterval;
    }

    public Duration getEventHandlerCacheRefreshInterval() {
        return this.eventHandlerCacheRefreshInterval;
    }

    public void setEventHandlerCacheRefreshInterval(Duration eventHandlerCacheRefreshInterval) {
        this.eventHandlerCacheRefreshInterval = eventHandlerCacheRefreshInterval;
    }

    public Duration getEventExecutionPersistenceTtl() {
        return this.eventExecutionPersistenceTtl;
    }

    public void setEventExecutionPersistenceTtl(Duration eventExecutionPersistenceTtl) {
        this.eventExecutionPersistenceTtl = eventExecutionPersistenceTtl;
    }
}

