/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.cassandra.config.cache;

import com.netflix.conductor.annotations.Trace;
import com.netflix.conductor.cassandra.config.CassandraProperties;
import com.netflix.conductor.cassandra.dao.CassandraEventHandlerDAO;
import com.netflix.conductor.common.metadata.events.EventHandler;
import com.netflix.conductor.dao.EventHandlerDAO;
import com.netflix.conductor.metrics.Monitors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;

@Trace
public class CacheableEventHandlerDAO
implements EventHandlerDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheableEventHandlerDAO.class);
    private static final String CLASS_NAME = CacheableEventHandlerDAO.class.getSimpleName();
    private final CassandraEventHandlerDAO cassandraEventHandlerDAO;
    private final CassandraProperties properties;
    private final CacheManager cacheManager;

    public CacheableEventHandlerDAO(CassandraEventHandlerDAO cassandraEventHandlerDAO, CassandraProperties properties, CacheManager cacheManager) {
        this.cassandraEventHandlerDAO = cassandraEventHandlerDAO;
        this.properties = properties;
        this.cacheManager = cacheManager;
    }

    @PostConstruct
    public void scheduleEventHandlerRefresh() {
        long cacheRefreshTime = this.properties.getEventHandlerCacheRefreshInterval().getSeconds();
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(this::refreshEventHandlersCache, 0L, cacheRefreshTime, TimeUnit.SECONDS);
    }

    @CachePut(value={"eventHandlerCache"}, key="#eventHandler.name")
    public void addEventHandler(EventHandler eventHandler) {
        this.cassandraEventHandlerDAO.addEventHandler(eventHandler);
    }

    @CachePut(value={"eventHandlerCache"}, key="#eventHandler.name")
    public void updateEventHandler(EventHandler eventHandler) {
        this.cassandraEventHandlerDAO.updateEventHandler(eventHandler);
    }

    @CacheEvict(value={"eventHandlerCache"})
    public void removeEventHandler(String name) {
        this.cassandraEventHandlerDAO.removeEventHandler(name);
    }

    public List<EventHandler> getAllEventHandlers() {
        ConcurrentHashMap cacheMap;
        Object nativeCache = this.cacheManager.getCache("eventHandlerCache").getNativeCache();
        if (nativeCache != null && nativeCache instanceof ConcurrentHashMap && !(cacheMap = (ConcurrentHashMap)nativeCache).isEmpty()) {
            ArrayList<EventHandler> eventHandlers = new ArrayList<EventHandler>();
            cacheMap.values().stream().filter(element -> element != null && element instanceof EventHandler).forEach(element -> eventHandlers.add((EventHandler)element));
            return eventHandlers;
        }
        return this.refreshEventHandlersCache();
    }

    public List<EventHandler> getEventHandlersForEvent(String event, boolean activeOnly) {
        if (activeOnly) {
            return this.getAllEventHandlers().stream().filter(eventHandler -> eventHandler.getEvent().equals(event)).filter(EventHandler::isActive).collect(Collectors.toList());
        }
        return this.getAllEventHandlers().stream().filter(eventHandler -> eventHandler.getEvent().equals(event)).collect(Collectors.toList());
    }

    private List<EventHandler> refreshEventHandlersCache() {
        try {
            Cache eventHandlersCache = this.cacheManager.getCache("eventHandlerCache");
            eventHandlersCache.clear();
            List<EventHandler> eventHandlers = this.cassandraEventHandlerDAO.getAllEventHandlers();
            eventHandlers.forEach(eventHandler -> eventHandlersCache.put((Object)eventHandler.getName(), eventHandler));
            LOGGER.debug("Refreshed event handlers, total num: " + eventHandlers.size());
            return eventHandlers;
        }
        catch (Exception e) {
            Monitors.error((String)CLASS_NAME, (String)"refreshEventHandlersCache");
            LOGGER.error("refresh EventHandlers failed", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

