/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.cassandra.config.cache;

import com.netflix.conductor.annotations.Trace;
import com.netflix.conductor.cassandra.config.CassandraProperties;
import com.netflix.conductor.cassandra.dao.CassandraMetadataDAO;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.dao.MetadataDAO;
import com.netflix.conductor.metrics.Monitors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;

@Trace
public class CacheableMetadataDAO
implements MetadataDAO {
    private static final String CLASS_NAME = CacheableMetadataDAO.class.getSimpleName();
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheableMetadataDAO.class);
    private final CassandraMetadataDAO cassandraMetadataDAO;
    private final CassandraProperties properties;
    private final CacheManager cacheManager;

    public CacheableMetadataDAO(CassandraMetadataDAO cassandraMetadataDAO, CassandraProperties properties, CacheManager cacheManager) {
        this.cassandraMetadataDAO = cassandraMetadataDAO;
        this.properties = properties;
        this.cacheManager = cacheManager;
    }

    @PostConstruct
    public void scheduleCacheRefresh() {
        long cacheRefreshTime = this.properties.getTaskDefCacheRefreshInterval().getSeconds();
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(this::refreshTaskDefsCache, 0L, cacheRefreshTime, TimeUnit.SECONDS);
        LOGGER.info("Scheduled cache refresh for Task Definitions, every {} seconds", (Object)cacheRefreshTime);
    }

    @CachePut(value={"taskDefCache"}, key="#taskDef.name")
    public TaskDef createTaskDef(TaskDef taskDef) {
        this.cassandraMetadataDAO.createTaskDef(taskDef);
        return taskDef;
    }

    @CachePut(value={"taskDefCache"}, key="#taskDef.name")
    public TaskDef updateTaskDef(TaskDef taskDef) {
        return this.cassandraMetadataDAO.updateTaskDef(taskDef);
    }

    @Cacheable(value={"taskDefCache"})
    public TaskDef getTaskDef(String name) {
        return this.cassandraMetadataDAO.getTaskDef(name);
    }

    public List<TaskDef> getAllTaskDefs() {
        ConcurrentHashMap cacheMap;
        Object nativeCache = this.cacheManager.getCache("taskDefCache").getNativeCache();
        if (nativeCache != null && nativeCache instanceof ConcurrentHashMap && !(cacheMap = (ConcurrentHashMap)nativeCache).isEmpty()) {
            ArrayList<TaskDef> taskDefs = new ArrayList<TaskDef>();
            cacheMap.values().stream().filter(element -> element != null && element instanceof TaskDef).forEach(element -> taskDefs.add((TaskDef)element));
            return taskDefs;
        }
        return this.refreshTaskDefsCache();
    }

    @CacheEvict(value={"taskDefCache"})
    public void removeTaskDef(String name) {
        this.cassandraMetadataDAO.removeTaskDef(name);
    }

    public void createWorkflowDef(WorkflowDef workflowDef) {
        this.cassandraMetadataDAO.createWorkflowDef(workflowDef);
    }

    public void updateWorkflowDef(WorkflowDef workflowDef) {
        this.cassandraMetadataDAO.updateWorkflowDef(workflowDef);
    }

    public Optional<WorkflowDef> getLatestWorkflowDef(String name) {
        return this.cassandraMetadataDAO.getLatestWorkflowDef(name);
    }

    public Optional<WorkflowDef> getWorkflowDef(String name, int version) {
        return this.cassandraMetadataDAO.getWorkflowDef(name, version);
    }

    public void removeWorkflowDef(String name, Integer version) {
        this.cassandraMetadataDAO.removeWorkflowDef(name, version);
    }

    public List<WorkflowDef> getAllWorkflowDefs() {
        return this.cassandraMetadataDAO.getAllWorkflowDefs();
    }

    private List<TaskDef> refreshTaskDefsCache() {
        try {
            Cache taskDefsCache = this.cacheManager.getCache("taskDefCache");
            taskDefsCache.clear();
            List<TaskDef> taskDefs = this.cassandraMetadataDAO.getAllTaskDefs();
            taskDefs.forEach(taskDef -> taskDefsCache.put((Object)taskDef.getName(), taskDef));
            LOGGER.debug("Refreshed task defs, total num: " + taskDefs.size());
            return taskDefs;
        }
        catch (Exception e) {
            Monitors.error((String)CLASS_NAME, (String)"refreshTaskDefs");
            LOGGER.error("refresh TaskDefs failed ", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

