/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.cassandra.dao;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.netflix.conductor.cassandra.config.CassandraProperties;
import com.netflix.conductor.core.exception.NonTransientException;
import com.netflix.conductor.metrics.Monitors;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CassandraBaseDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraBaseDAO.class);
    private final ObjectMapper objectMapper;
    protected final Session session;
    protected final CassandraProperties properties;
    private boolean initialized = false;

    public CassandraBaseDAO(Session session, ObjectMapper objectMapper, CassandraProperties properties) {
        this.session = session;
        this.objectMapper = objectMapper;
        this.properties = properties;
        this.init();
    }

    protected static UUID toUUID(String uuidString, String message) {
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(message + " " + uuidString, iae);
        }
    }

    private void init() {
        try {
            if (!this.initialized) {
                this.session.execute(this.getCreateKeyspaceStatement());
                this.session.execute(this.getCreateWorkflowsTableStatement());
                this.session.execute(this.getCreateTaskLookupTableStatement());
                this.session.execute(this.getCreateTaskDefLimitTableStatement());
                this.session.execute(this.getCreateWorkflowDefsTableStatement());
                this.session.execute(this.getCreateWorkflowDefsIndexTableStatement());
                this.session.execute(this.getCreateTaskDefsTableStatement());
                this.session.execute(this.getCreateEventHandlersTableStatement());
                this.session.execute(this.getCreateEventExecutionsTableStatement());
                LOGGER.info("{} initialization complete! Tables created!", (Object)this.getClass().getSimpleName());
                this.initialized = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error initializing and setting up keyspace and table in cassandra", (Throwable)e);
            throw e;
        }
    }

    private String getCreateKeyspaceStatement() {
        return SchemaBuilder.createKeyspace((String)this.properties.getKeyspace()).ifNotExists().with().replication((Map)ImmutableMap.of((Object)"class", (Object)this.properties.getReplicationStrategy(), (Object)this.properties.getReplicationFactorKey(), (Object)this.properties.getReplicationFactorValue())).durableWrites(Boolean.valueOf(true)).getQueryString();
    }

    private String getCreateWorkflowsTableStatement() {
        return ((Create)((Create)SchemaBuilder.createTable((String)this.properties.getKeyspace(), (String)"workflows").ifNotExists()).addPartitionKey("workflow_id", DataType.uuid()).addPartitionKey("shard_id", DataType.cint()).addClusteringColumn("entity", DataType.text()).addClusteringColumn("task_id", DataType.text()).addColumn("payload", DataType.text())).addStaticColumn("total_tasks", DataType.cint()).addStaticColumn("total_partitions", DataType.cint()).getQueryString();
    }

    private String getCreateTaskLookupTableStatement() {
        return ((Create)((Create)SchemaBuilder.createTable((String)this.properties.getKeyspace(), (String)"task_lookup").ifNotExists()).addPartitionKey("task_id", DataType.uuid()).addColumn("workflow_id", DataType.uuid())).getQueryString();
    }

    private String getCreateTaskDefLimitTableStatement() {
        return ((Create)((Create)SchemaBuilder.createTable((String)this.properties.getKeyspace(), (String)"task_def_limit").ifNotExists()).addPartitionKey("task_def_name", DataType.text()).addClusteringColumn("task_id", DataType.uuid()).addColumn("workflow_id", DataType.uuid())).getQueryString();
    }

    private String getCreateWorkflowDefsTableStatement() {
        return ((Create)((Create)SchemaBuilder.createTable((String)this.properties.getKeyspace(), (String)"workflow_definitions").ifNotExists()).addPartitionKey("workflow_def_name", DataType.text()).addClusteringColumn("version", DataType.cint()).addColumn("workflow_definition", DataType.text())).getQueryString();
    }

    private String getCreateWorkflowDefsIndexTableStatement() {
        return ((Create)((Create)SchemaBuilder.createTable((String)this.properties.getKeyspace(), (String)"workflow_defs_index").ifNotExists()).addPartitionKey("workflow_def_version_index", DataType.text()).addClusteringColumn("workflow_def_name_version", DataType.text()).addColumn("workflow_def_index_value", DataType.text())).getQueryString();
    }

    private String getCreateTaskDefsTableStatement() {
        return ((Create)((Create)SchemaBuilder.createTable((String)this.properties.getKeyspace(), (String)"task_definitions").ifNotExists()).addPartitionKey("task_defs", DataType.text()).addClusteringColumn("task_def_name", DataType.text()).addColumn("task_definition", DataType.text())).getQueryString();
    }

    private String getCreateEventHandlersTableStatement() {
        return ((Create)((Create)SchemaBuilder.createTable((String)this.properties.getKeyspace(), (String)"event_handlers").ifNotExists()).addPartitionKey("handlers", DataType.text()).addClusteringColumn("event_handler_name", DataType.text()).addColumn("event_handler", DataType.text())).getQueryString();
    }

    private String getCreateEventExecutionsTableStatement() {
        return ((Create)((Create)SchemaBuilder.createTable((String)this.properties.getKeyspace(), (String)"event_executions").ifNotExists()).addPartitionKey("message_id", DataType.text()).addPartitionKey("event_handler_name", DataType.text()).addClusteringColumn("event_execution_id", DataType.text()).addColumn("payload", DataType.text())).getQueryString();
    }

    String toJson(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new NonTransientException("Error serializing to json", (Throwable)e);
        }
    }

    <T> T readValue(String json, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new NonTransientException("Error de-serializing json", (Throwable)e);
        }
    }

    void recordCassandraDaoRequests(String action) {
        this.recordCassandraDaoRequests(action, "n/a", "n/a");
    }

    void recordCassandraDaoRequests(String action, String taskType, String workflowType) {
        Monitors.recordDaoRequests((String)"cassandra", (String)action, (String)taskType, (String)workflowType);
    }

    void recordCassandraDaoEventRequests(String action, String event) {
        Monitors.recordDaoEventRequests((String)"cassandra", (String)action, (String)event);
    }

    void recordCassandraDaoPayloadSize(String action, int size, String taskType, String workflowType) {
        Monitors.recordDaoPayloadSize((String)"cassandra", (String)action, (String)taskType, (String)workflowType, (int)size);
    }

    static class WorkflowMetadata {
        private int totalTasks;
        private int totalPartitions;

        WorkflowMetadata() {
        }

        public int getTotalTasks() {
            return this.totalTasks;
        }

        public void setTotalTasks(int totalTasks) {
            this.totalTasks = totalTasks;
        }

        public int getTotalPartitions() {
            return this.totalPartitions;
        }

        public void setTotalPartitions(int totalPartitions) {
            this.totalPartitions = totalPartitions;
        }
    }
}

