/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.cassandra.dao;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.annotations.Trace;
import com.netflix.conductor.cassandra.config.CassandraProperties;
import com.netflix.conductor.cassandra.dao.CassandraBaseDAO;
import com.netflix.conductor.cassandra.util.Statements;
import com.netflix.conductor.common.metadata.events.EventHandler;
import com.netflix.conductor.core.exception.TransientException;
import com.netflix.conductor.dao.EventHandlerDAO;
import com.netflix.conductor.metrics.Monitors;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Trace
public class CassandraEventHandlerDAO
extends CassandraBaseDAO
implements EventHandlerDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraEventHandlerDAO.class);
    private static final String CLASS_NAME = CassandraEventHandlerDAO.class.getSimpleName();
    private final PreparedStatement insertEventHandlerStatement;
    private final PreparedStatement selectAllEventHandlersStatement;
    private final PreparedStatement deleteEventHandlerStatement;

    public CassandraEventHandlerDAO(Session session, ObjectMapper objectMapper, CassandraProperties properties, Statements statements) {
        super(session, objectMapper, properties);
        this.insertEventHandlerStatement = session.prepare(statements.getInsertEventHandlerStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.selectAllEventHandlersStatement = session.prepare(statements.getSelectAllEventHandlersStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.deleteEventHandlerStatement = session.prepare(statements.getDeleteEventHandlerStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
    }

    public void addEventHandler(EventHandler eventHandler) {
        this.insertOrUpdateEventHandler(eventHandler);
    }

    public void updateEventHandler(EventHandler eventHandler) {
        this.insertOrUpdateEventHandler(eventHandler);
    }

    public void removeEventHandler(String name) {
        try {
            this.recordCassandraDaoRequests("removeEventHandler");
            this.session.execute((Statement)this.deleteEventHandlerStatement.bind(new Object[]{name}));
        }
        catch (Exception e) {
            Monitors.error((String)CLASS_NAME, (String)"removeEventHandler");
            String errorMsg = String.format("Failed to remove event handler: %s", name);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    public List<EventHandler> getAllEventHandlers() {
        return this.getAllEventHandlersFromDB();
    }

    public List<EventHandler> getEventHandlersForEvent(String event, boolean activeOnly) {
        if (activeOnly) {
            return this.getAllEventHandlers().stream().filter(eventHandler -> eventHandler.getEvent().equals(event)).filter(EventHandler::isActive).collect(Collectors.toList());
        }
        return this.getAllEventHandlers().stream().filter(eventHandler -> eventHandler.getEvent().equals(event)).collect(Collectors.toList());
    }

    private List<EventHandler> getAllEventHandlersFromDB() {
        try {
            ResultSet resultSet = this.session.execute((Statement)this.selectAllEventHandlersStatement.bind(new Object[]{"handlers"}));
            List rows = resultSet.all();
            if (rows.size() == 0) {
                LOGGER.info("No event handlers were found.");
                return Collections.EMPTY_LIST;
            }
            return rows.stream().map(row -> this.readValue(row.getString("event_handler"), EventHandler.class)).collect(Collectors.toList());
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"getAllEventHandlersFromDB");
            String errorMsg = "Failed to get all event handlers";
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    private void insertOrUpdateEventHandler(EventHandler eventHandler) {
        try {
            String handler = this.toJson(eventHandler);
            this.session.execute((Statement)this.insertEventHandlerStatement.bind(new Object[]{eventHandler.getName(), handler}));
            this.recordCassandraDaoRequests("storeEventHandler");
            this.recordCassandraDaoPayloadSize("storeEventHandler", handler.length(), "n/a", "n/a");
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"insertOrUpdateEventHandler");
            String errorMsg = String.format("Error creating/updating event handler: %s/%s", eventHandler.getName(), eventHandler.getEvent());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }
}

