/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.cassandra.dao;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.netflix.conductor.annotations.Trace;
import com.netflix.conductor.cassandra.config.CassandraProperties;
import com.netflix.conductor.cassandra.dao.CassandraBaseDAO;
import com.netflix.conductor.cassandra.util.Statements;
import com.netflix.conductor.common.metadata.events.EventExecution;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.core.exception.NonTransientException;
import com.netflix.conductor.core.exception.NotFoundException;
import com.netflix.conductor.core.exception.TransientException;
import com.netflix.conductor.dao.ConcurrentExecutionLimitDAO;
import com.netflix.conductor.dao.ExecutionDAO;
import com.netflix.conductor.metrics.Monitors;
import com.netflix.conductor.model.TaskModel;
import com.netflix.conductor.model.WorkflowModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Trace
public class CassandraExecutionDAO
extends CassandraBaseDAO
implements ExecutionDAO,
ConcurrentExecutionLimitDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraExecutionDAO.class);
    private static final String CLASS_NAME = CassandraExecutionDAO.class.getSimpleName();
    protected final PreparedStatement insertWorkflowStatement;
    protected final PreparedStatement insertTaskStatement;
    protected final PreparedStatement insertEventExecutionStatement;
    protected final PreparedStatement selectTotalStatement;
    protected final PreparedStatement selectTaskStatement;
    protected final PreparedStatement selectWorkflowStatement;
    protected final PreparedStatement selectWorkflowWithTasksStatement;
    protected final PreparedStatement selectTaskLookupStatement;
    protected final PreparedStatement selectTasksFromTaskDefLimitStatement;
    protected final PreparedStatement selectEventExecutionsStatement;
    protected final PreparedStatement updateWorkflowStatement;
    protected final PreparedStatement updateTotalTasksStatement;
    protected final PreparedStatement updateTotalPartitionsStatement;
    protected final PreparedStatement updateTaskLookupStatement;
    protected final PreparedStatement updateTaskDefLimitStatement;
    protected final PreparedStatement updateEventExecutionStatement;
    protected final PreparedStatement deleteWorkflowStatement;
    protected final PreparedStatement deleteTaskStatement;
    protected final PreparedStatement deleteTaskLookupStatement;
    protected final PreparedStatement deleteTaskDefLimitStatement;
    protected final PreparedStatement deleteEventExecutionStatement;
    protected final int eventExecutionsTTL;

    public CassandraExecutionDAO(Session session, ObjectMapper objectMapper, CassandraProperties properties, Statements statements) {
        super(session, objectMapper, properties);
        this.eventExecutionsTTL = (int)properties.getEventExecutionPersistenceTtl().getSeconds();
        this.insertWorkflowStatement = session.prepare(statements.getInsertWorkflowStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.insertTaskStatement = session.prepare(statements.getInsertTaskStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.insertEventExecutionStatement = session.prepare(statements.getInsertEventExecutionStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.selectTotalStatement = session.prepare(statements.getSelectTotalStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.selectTaskStatement = session.prepare(statements.getSelectTaskStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.selectWorkflowStatement = session.prepare(statements.getSelectWorkflowStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.selectWorkflowWithTasksStatement = session.prepare(statements.getSelectWorkflowWithTasksStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.selectTaskLookupStatement = session.prepare(statements.getSelectTaskFromLookupTableStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.selectTasksFromTaskDefLimitStatement = session.prepare(statements.getSelectTasksFromTaskDefLimitStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.selectEventExecutionsStatement = session.prepare(statements.getSelectAllEventExecutionsForMessageFromEventExecutionsStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.updateWorkflowStatement = session.prepare(statements.getUpdateWorkflowStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.updateTotalTasksStatement = session.prepare(statements.getUpdateTotalTasksStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.updateTotalPartitionsStatement = session.prepare(statements.getUpdateTotalPartitionsStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.updateTaskLookupStatement = session.prepare(statements.getUpdateTaskLookupStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.updateTaskDefLimitStatement = session.prepare(statements.getUpdateTaskDefLimitStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.updateEventExecutionStatement = session.prepare(statements.getUpdateEventExecutionStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.deleteWorkflowStatement = session.prepare(statements.getDeleteWorkflowStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.deleteTaskStatement = session.prepare(statements.getDeleteTaskStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.deleteTaskLookupStatement = session.prepare(statements.getDeleteTaskLookupStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.deleteTaskDefLimitStatement = session.prepare(statements.getDeleteTaskDefLimitStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.deleteEventExecutionStatement = session.prepare(statements.getDeleteEventExecutionsStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
    }

    public List<TaskModel> getPendingTasksByWorkflow(String taskName, String workflowId) {
        List<TaskModel> tasks = this.getTasksForWorkflow(workflowId);
        return tasks.stream().filter(task -> taskName.equals(task.getTaskType())).filter(task -> TaskModel.Status.IN_PROGRESS.equals((Object)task.getStatus())).collect(Collectors.toList());
    }

    public List<TaskModel> getTasks(String taskType, String startKey, int count) {
        throw new UnsupportedOperationException("This method is not implemented in CassandraExecutionDAO. Please use ExecutionDAOFacade instead.");
    }

    public List<TaskModel> createTasks(List<TaskModel> tasks) {
        this.validateTasks(tasks);
        String workflowId = tasks.get(0).getWorkflowInstanceId();
        UUID workflowUUID = CassandraExecutionDAO.toUUID(workflowId, "Invalid workflow id");
        try {
            CassandraBaseDAO.WorkflowMetadata workflowMetadata = this.getWorkflowMetadata(workflowId);
            int totalTasks = workflowMetadata.getTotalTasks() + tasks.size();
            tasks.forEach(task -> {
                if (task.getScheduledTime() == 0L) {
                    task.setScheduledTime(System.currentTimeMillis());
                }
                this.session.execute((Statement)this.updateTaskLookupStatement.bind(new Object[]{workflowUUID, CassandraExecutionDAO.toUUID(task.getTaskId(), "Invalid task id")}));
            });
            BatchStatement batchStatement = new BatchStatement();
            tasks.forEach(task -> {
                String taskPayload = this.toJson(task);
                batchStatement.add((Statement)this.insertTaskStatement.bind(new Object[]{workflowUUID, 1, task.getTaskId(), taskPayload}));
                this.recordCassandraDaoRequests("createTask", task.getTaskType(), task.getWorkflowType());
                this.recordCassandraDaoPayloadSize("createTask", taskPayload.length(), task.getTaskType(), task.getWorkflowType());
            });
            batchStatement.add((Statement)this.updateTotalTasksStatement.bind(new Object[]{totalTasks, workflowUUID, 1}));
            this.session.execute((Statement)batchStatement);
            this.session.execute((Statement)this.updateTotalPartitionsStatement.bind(new Object[]{1, totalTasks, workflowUUID}));
            return tasks;
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"createTasks");
            String errorMsg = String.format("Error creating %d tasks for workflow: %s", tasks.size(), workflowId);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    public void updateTask(TaskModel task) {
        try {
            String taskPayload = this.toJson(task);
            this.recordCassandraDaoRequests("updateTask", task.getTaskType(), task.getWorkflowType());
            this.recordCassandraDaoPayloadSize("updateTask", taskPayload.length(), task.getTaskType(), task.getWorkflowType());
            this.session.execute((Statement)this.insertTaskStatement.bind(new Object[]{UUID.fromString(task.getWorkflowInstanceId()), 1, task.getTaskId(), taskPayload}));
            if (task.getTaskDefinition().isPresent() && ((TaskDef)task.getTaskDefinition().get()).concurrencyLimit() > 0) {
                if (task.getStatus().isTerminal()) {
                    this.removeTaskFromLimit(task);
                } else if (task.getStatus() == TaskModel.Status.IN_PROGRESS) {
                    this.addTaskToLimit(task);
                }
            }
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"updateTask");
            String errorMsg = String.format("Error updating task: %s in workflow: %s", task.getTaskId(), task.getWorkflowInstanceId());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    public boolean exceedsLimit(TaskModel task) {
        Optional taskDefinition = task.getTaskDefinition();
        if (taskDefinition.isEmpty()) {
            return false;
        }
        int limit = ((TaskDef)taskDefinition.get()).concurrencyLimit();
        if (limit <= 0) {
            return false;
        }
        try {
            this.recordCassandraDaoRequests("selectTaskDefLimit", task.getTaskType(), task.getWorkflowType());
            ResultSet resultSet = this.session.execute((Statement)this.selectTasksFromTaskDefLimitStatement.bind(new Object[]{task.getTaskDefName()}));
            List taskIds = resultSet.all().stream().map(row -> row.getUUID("task_id").toString()).collect(Collectors.toList());
            long current = taskIds.size();
            if (!taskIds.contains(task.getTaskId()) && current >= (long)limit) {
                LOGGER.info("Task execution count limited. task - {}:{}, limit: {}, current: {}", new Object[]{task.getTaskId(), task.getTaskDefName(), limit, current});
                Monitors.recordTaskConcurrentExecutionLimited((String)task.getTaskDefName(), (int)limit);
                return true;
            }
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"exceedsLimit");
            String errorMsg = String.format("Failed to get in progress limit - %s:%s in workflow :%s", task.getTaskDefName(), task.getTaskId(), task.getWorkflowInstanceId());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg);
        }
        return false;
    }

    public boolean removeTask(String taskId) {
        TaskModel task = this.getTask(taskId);
        if (task == null) {
            LOGGER.warn("No such task found by id {}", (Object)taskId);
            return false;
        }
        return this.removeTask(task);
    }

    public TaskModel getTask(String taskId) {
        try {
            String workflowId = this.lookupWorkflowIdFromTaskId(taskId);
            if (workflowId == null) {
                return null;
            }
            ResultSet resultSet = this.session.execute((Statement)this.selectTaskStatement.bind(new Object[]{UUID.fromString(workflowId), 1, taskId}));
            return Optional.ofNullable(resultSet.one()).map(row -> {
                String taskRow = row.getString("payload");
                TaskModel task = this.readValue(taskRow, TaskModel.class);
                this.recordCassandraDaoRequests("getTask", task.getTaskType(), task.getWorkflowType());
                this.recordCassandraDaoPayloadSize("getTask", taskRow.length(), task.getTaskType(), task.getWorkflowType());
                return task;
            }).orElse(null);
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"getTask");
            String errorMsg = String.format("Error getting task by id: %s", taskId);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg);
        }
    }

    public List<TaskModel> getTasks(List<String> taskIds) {
        Preconditions.checkNotNull(taskIds);
        Preconditions.checkArgument((taskIds.size() > 0 ? 1 : 0) != 0, (Object)"Task ids list cannot be empty");
        String workflowId = this.lookupWorkflowIdFromTaskId(taskIds.get(0));
        if (workflowId == null) {
            return null;
        }
        return this.getWorkflow(workflowId, true).getTasks().stream().filter(task -> taskIds.contains(task.getTaskId())).collect(Collectors.toList());
    }

    public List<TaskModel> getPendingTasksForTaskType(String taskType) {
        throw new UnsupportedOperationException("This method is not implemented in CassandraExecutionDAO. Please use ExecutionDAOFacade instead.");
    }

    public List<TaskModel> getTasksForWorkflow(String workflowId) {
        return this.getWorkflow(workflowId, true).getTasks();
    }

    public String createWorkflow(WorkflowModel workflow) {
        try {
            List tasks = workflow.getTasks();
            workflow.setTasks(new LinkedList());
            String payload = this.toJson(workflow);
            this.recordCassandraDaoRequests("createWorkflow", "n/a", workflow.getWorkflowName());
            this.recordCassandraDaoPayloadSize("createWorkflow", payload.length(), "n/a", workflow.getWorkflowName());
            this.session.execute((Statement)this.insertWorkflowStatement.bind(new Object[]{UUID.fromString(workflow.getWorkflowId()), 1, "", payload, 0, 1}));
            workflow.setTasks(tasks);
            return workflow.getWorkflowId();
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"createWorkflow");
            String errorMsg = String.format("Error creating workflow: %s", workflow.getWorkflowId());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    public String updateWorkflow(WorkflowModel workflow) {
        try {
            List tasks = workflow.getTasks();
            workflow.setTasks(new LinkedList());
            String payload = this.toJson(workflow);
            this.recordCassandraDaoRequests("updateWorkflow", "n/a", workflow.getWorkflowName());
            this.recordCassandraDaoPayloadSize("updateWorkflow", payload.length(), "n/a", workflow.getWorkflowName());
            this.session.execute((Statement)this.updateWorkflowStatement.bind(new Object[]{payload, UUID.fromString(workflow.getWorkflowId())}));
            workflow.setTasks(tasks);
            return workflow.getWorkflowId();
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"updateWorkflow");
            String errorMsg = String.format("Failed to update workflow: %s", workflow.getWorkflowId());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg);
        }
    }

    public boolean removeWorkflow(String workflowId) {
        WorkflowModel workflow = this.getWorkflow(workflowId, true);
        boolean removed = false;
        if (workflow != null) {
            try {
                this.recordCassandraDaoRequests("removeWorkflow", "n/a", workflow.getWorkflowName());
                ResultSet resultSet = this.session.execute((Statement)this.deleteWorkflowStatement.bind(new Object[]{UUID.fromString(workflowId), 1}));
                removed = resultSet.wasApplied();
            }
            catch (DriverException e) {
                Monitors.error((String)CLASS_NAME, (String)"removeWorkflow");
                String errorMsg = String.format("Failed to remove workflow: %s", workflowId);
                LOGGER.error(errorMsg, (Throwable)e);
                throw new TransientException(errorMsg);
            }
            workflow.getTasks().forEach(this::removeTaskLookup);
        }
        return removed;
    }

    public boolean removeWorkflowWithExpiry(String workflowId, int ttlSeconds) {
        throw new UnsupportedOperationException("This method is not currently implemented in CassandraExecutionDAO. Please use RedisDAO mode instead now for using TTLs.");
    }

    public void removeFromPendingWorkflow(String workflowType, String workflowId) {
        throw new UnsupportedOperationException("This method is not implemented in CassandraExecutionDAO. Please use ExecutionDAOFacade instead.");
    }

    public WorkflowModel getWorkflow(String workflowId) {
        return this.getWorkflow(workflowId, true);
    }

    public WorkflowModel getWorkflow(String workflowId, boolean includeTasks) {
        UUID workflowUUID = CassandraExecutionDAO.toUUID(workflowId, "Invalid workflow id");
        try {
            WorkflowModel workflow = null;
            if (includeTasks) {
                ResultSet resultSet = this.session.execute((Statement)this.selectWorkflowWithTasksStatement.bind(new Object[]{workflowUUID, 1}));
                ArrayList<TaskModel> tasks = new ArrayList<TaskModel>();
                List rows = resultSet.all();
                if (rows.size() == 0) {
                    LOGGER.info("Workflow {} not found in datastore", (Object)workflowId);
                    return null;
                }
                for (Row row2 : rows) {
                    String entityKey = row2.getString("entity");
                    if ("workflow".equals(entityKey)) {
                        workflow = this.readValue(row2.getString("payload"), WorkflowModel.class);
                        continue;
                    }
                    if ("task".equals(entityKey)) {
                        TaskModel task = this.readValue(row2.getString("payload"), TaskModel.class);
                        tasks.add(task);
                        continue;
                    }
                    throw new NonTransientException(String.format("Invalid row with entityKey: %s found in datastore for workflow: %s", entityKey, workflowId));
                }
                if (workflow != null) {
                    this.recordCassandraDaoRequests("getWorkflow", "n/a", workflow.getWorkflowName());
                    tasks.sort(Comparator.comparingInt(TaskModel::getSeq));
                    workflow.setTasks(tasks);
                }
            } else {
                ResultSet resultSet = this.session.execute((Statement)this.selectWorkflowStatement.bind(new Object[]{workflowUUID}));
                workflow = Optional.ofNullable(resultSet.one()).map(row -> {
                    WorkflowModel wf = this.readValue(row.getString("payload"), WorkflowModel.class);
                    this.recordCassandraDaoRequests("getWorkflow", "n/a", wf.getWorkflowName());
                    return wf;
                }).orElse(null);
            }
            return workflow;
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"getWorkflow");
            String errorMsg = String.format("Failed to get workflow: %s", workflowId);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg);
        }
    }

    public List<String> getRunningWorkflowIds(String workflowName, int version) {
        throw new UnsupportedOperationException("This method is not implemented in CassandraExecutionDAO. Please use ExecutionDAOFacade instead.");
    }

    public List<WorkflowModel> getPendingWorkflowsByType(String workflowName, int version) {
        throw new UnsupportedOperationException("This method is not implemented in CassandraExecutionDAO. Please use ExecutionDAOFacade instead.");
    }

    public long getPendingWorkflowCount(String workflowName) {
        throw new UnsupportedOperationException("This method is not implemented in CassandraExecutionDAO. Please use ExecutionDAOFacade instead.");
    }

    public long getInProgressTaskCount(String taskDefName) {
        throw new UnsupportedOperationException("This method is not implemented in CassandraExecutionDAO. Please use ExecutionDAOFacade instead.");
    }

    public List<WorkflowModel> getWorkflowsByType(String workflowName, Long startTime, Long endTime) {
        throw new UnsupportedOperationException("This method is not implemented in CassandraExecutionDAO. Please use ExecutionDAOFacade instead.");
    }

    public List<WorkflowModel> getWorkflowsByCorrelationId(String workflowName, String correlationId, boolean includeTasks) {
        throw new UnsupportedOperationException("This method is not implemented in CassandraExecutionDAO. Please use ExecutionDAOFacade instead.");
    }

    public boolean canSearchAcrossWorkflows() {
        return false;
    }

    public boolean addEventExecution(EventExecution eventExecution) {
        try {
            String jsonPayload = this.toJson(eventExecution);
            this.recordCassandraDaoEventRequests("addEventExecution", eventExecution.getEvent());
            this.recordCassandraDaoPayloadSize("addEventExecution", jsonPayload.length(), eventExecution.getEvent(), "n/a");
            return this.session.execute((Statement)this.insertEventExecutionStatement.bind(new Object[]{eventExecution.getMessageId(), eventExecution.getName(), eventExecution.getId(), jsonPayload})).wasApplied();
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"addEventExecution");
            String errorMsg = String.format("Failed to add event execution for event: %s, handler: %s", eventExecution.getEvent(), eventExecution.getName());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg);
        }
    }

    public void updateEventExecution(EventExecution eventExecution) {
        try {
            String jsonPayload = this.toJson(eventExecution);
            this.recordCassandraDaoEventRequests("updateEventExecution", eventExecution.getEvent());
            this.recordCassandraDaoPayloadSize("updateEventExecution", jsonPayload.length(), eventExecution.getEvent(), "n/a");
            this.session.execute((Statement)this.updateEventExecutionStatement.bind(new Object[]{this.eventExecutionsTTL, jsonPayload, eventExecution.getMessageId(), eventExecution.getName(), eventExecution.getId()}));
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"updateEventExecution");
            String errorMsg = String.format("Failed to update event execution for event: %s, handler: %s", eventExecution.getEvent(), eventExecution.getName());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg);
        }
    }

    public void removeEventExecution(EventExecution eventExecution) {
        try {
            this.recordCassandraDaoEventRequests("removeEventExecution", eventExecution.getEvent());
            this.session.execute((Statement)this.deleteEventExecutionStatement.bind(new Object[]{eventExecution.getMessageId(), eventExecution.getName(), eventExecution.getId()}));
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"removeEventExecution");
            String errorMsg = String.format("Failed to remove event execution for event: %s, handler: %s", eventExecution.getEvent(), eventExecution.getName());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg);
        }
    }

    @VisibleForTesting
    List<EventExecution> getEventExecutions(String eventHandlerName, String eventName, String messageId) {
        try {
            return this.session.execute((Statement)this.selectEventExecutionsStatement.bind(new Object[]{messageId, eventHandlerName})).all().stream().filter(row -> !row.isNull("payload")).map(row -> this.readValue(row.getString("payload"), EventExecution.class)).collect(Collectors.toList());
        }
        catch (DriverException e) {
            String errorMsg = String.format("Failed to fetch event executions for event: %s, handler: %s", eventName, eventHandlerName);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg);
        }
    }

    public void addTaskToLimit(TaskModel task) {
        try {
            this.recordCassandraDaoRequests("addTaskToLimit", task.getTaskType(), task.getWorkflowType());
            this.session.execute((Statement)this.updateTaskDefLimitStatement.bind(new Object[]{UUID.fromString(task.getWorkflowInstanceId()), task.getTaskDefName(), UUID.fromString(task.getTaskId())}));
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"addTaskToLimit");
            String errorMsg = String.format("Error updating taskDefLimit for task - %s:%s in workflow: %s", task.getTaskDefName(), task.getTaskId(), task.getWorkflowInstanceId());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    public void removeTaskFromLimit(TaskModel task) {
        try {
            this.recordCassandraDaoRequests("removeTaskFromLimit", task.getTaskType(), task.getWorkflowType());
            this.session.execute((Statement)this.deleteTaskDefLimitStatement.bind(new Object[]{task.getTaskDefName(), UUID.fromString(task.getTaskId())}));
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"removeTaskFromLimit");
            String errorMsg = String.format("Error updating taskDefLimit for task - %s:%s in workflow: %s", task.getTaskDefName(), task.getTaskId(), task.getWorkflowInstanceId());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    protected boolean removeTask(TaskModel task) {
        try {
            CassandraBaseDAO.WorkflowMetadata workflowMetadata = this.getWorkflowMetadata(task.getWorkflowInstanceId());
            int totalTasks = workflowMetadata.getTotalTasks();
            this.removeTaskLookup(task);
            this.recordCassandraDaoRequests("removeTask", task.getTaskType(), task.getWorkflowType());
            BatchStatement batchStatement = new BatchStatement();
            batchStatement.add((Statement)this.deleteTaskStatement.bind(new Object[]{UUID.fromString(task.getWorkflowInstanceId()), 1, task.getTaskId()}));
            batchStatement.add((Statement)this.updateTotalTasksStatement.bind(new Object[]{totalTasks - 1, UUID.fromString(task.getWorkflowInstanceId()), 1}));
            ResultSet resultSet = this.session.execute((Statement)batchStatement);
            if (task.getTaskDefinition().isPresent() && ((TaskDef)task.getTaskDefinition().get()).concurrencyLimit() > 0) {
                this.removeTaskFromLimit(task);
            }
            return resultSet.wasApplied();
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"removeTask");
            String errorMsg = String.format("Failed to remove task: %s", task.getTaskId());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg);
        }
    }

    protected void removeTaskLookup(TaskModel task) {
        try {
            this.recordCassandraDaoRequests("removeTaskLookup", task.getTaskType(), task.getWorkflowType());
            if (task.getTaskDefinition().isPresent() && ((TaskDef)task.getTaskDefinition().get()).concurrencyLimit() > 0) {
                this.removeTaskFromLimit(task);
            }
            this.session.execute((Statement)this.deleteTaskLookupStatement.bind(new Object[]{UUID.fromString(task.getTaskId())}));
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"removeTaskLookup");
            String errorMsg = String.format("Failed to remove task lookup: %s", task.getTaskId());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg);
        }
    }

    @VisibleForTesting
    void validateTasks(List<TaskModel> tasks) {
        Preconditions.checkNotNull(tasks, (Object)"Tasks object cannot be null");
        Preconditions.checkArgument((!tasks.isEmpty() ? 1 : 0) != 0, (Object)"Tasks object cannot be empty");
        tasks.forEach(task -> {
            Preconditions.checkNotNull((Object)task, (Object)"task object cannot be null");
            Preconditions.checkNotNull((Object)task.getTaskId(), (Object)"Task id cannot be null");
            Preconditions.checkNotNull((Object)task.getWorkflowInstanceId(), (Object)"Workflow instance id cannot be null");
            Preconditions.checkNotNull((Object)task.getReferenceTaskName(), (Object)"Task reference name cannot be null");
        });
        String workflowId = tasks.get(0).getWorkflowInstanceId();
        Optional<TaskModel> optionalTask = tasks.stream().filter(task -> !workflowId.equals(task.getWorkflowInstanceId())).findAny();
        if (optionalTask.isPresent()) {
            throw new NonTransientException("Tasks of multiple workflows cannot be created/updated simultaneously");
        }
    }

    @VisibleForTesting
    CassandraBaseDAO.WorkflowMetadata getWorkflowMetadata(String workflowId) {
        ResultSet resultSet = this.session.execute((Statement)this.selectTotalStatement.bind(new Object[]{UUID.fromString(workflowId)}));
        this.recordCassandraDaoRequests("getWorkflowMetadata");
        return Optional.ofNullable(resultSet.one()).map(row -> {
            CassandraBaseDAO.WorkflowMetadata workflowMetadata = new CassandraBaseDAO.WorkflowMetadata();
            workflowMetadata.setTotalTasks(row.getInt("total_tasks"));
            workflowMetadata.setTotalPartitions(row.getInt("total_partitions"));
            return workflowMetadata;
        }).orElseThrow(() -> new NotFoundException("Workflow with id: %s not found in data store", new Object[]{workflowId}));
    }

    @VisibleForTesting
    String lookupWorkflowIdFromTaskId(String taskId) {
        UUID taskUUID = CassandraExecutionDAO.toUUID(taskId, "Invalid task id");
        try {
            ResultSet resultSet = this.session.execute((Statement)this.selectTaskLookupStatement.bind(new Object[]{taskUUID}));
            return Optional.ofNullable(resultSet.one()).map(row -> row.getUUID("workflow_id").toString()).orElse(null);
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"lookupWorkflowIdFromTaskId");
            String errorMsg = String.format("Failed to lookup workflowId from taskId: %s", taskId);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }
}

