/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.cassandra.dao;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.annotations.Trace;
import com.netflix.conductor.annotations.VisibleForTesting;
import com.netflix.conductor.cassandra.config.CassandraProperties;
import com.netflix.conductor.cassandra.dao.CassandraBaseDAO;
import com.netflix.conductor.cassandra.util.Statements;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.core.exception.ConflictException;
import com.netflix.conductor.core.exception.TransientException;
import com.netflix.conductor.dao.MetadataDAO;
import com.netflix.conductor.metrics.Monitors;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Trace
public class CassandraMetadataDAO
extends CassandraBaseDAO
implements MetadataDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraMetadataDAO.class);
    private static final String CLASS_NAME = CassandraMetadataDAO.class.getSimpleName();
    private static final String INDEX_DELIMITER = "/";
    private final PreparedStatement insertWorkflowDefStatement;
    private final PreparedStatement insertWorkflowDefVersionIndexStatement;
    private final PreparedStatement insertTaskDefStatement;
    private final PreparedStatement selectWorkflowDefStatement;
    private final PreparedStatement selectAllWorkflowDefVersionsByNameStatement;
    private final PreparedStatement selectAllWorkflowDefsStatement;
    private final PreparedStatement selectTaskDefStatement;
    private final PreparedStatement selectAllTaskDefsStatement;
    private final PreparedStatement updateWorkflowDefStatement;
    private final PreparedStatement deleteWorkflowDefStatement;
    private final PreparedStatement deleteWorkflowDefIndexStatement;
    private final PreparedStatement deleteTaskDefStatement;

    public CassandraMetadataDAO(Session session, ObjectMapper objectMapper, CassandraProperties properties, Statements statements) {
        super(session, objectMapper, properties);
        this.insertWorkflowDefStatement = session.prepare(statements.getInsertWorkflowDefStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.insertWorkflowDefVersionIndexStatement = session.prepare(statements.getInsertWorkflowDefVersionIndexStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.insertTaskDefStatement = session.prepare(statements.getInsertTaskDefStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.selectWorkflowDefStatement = session.prepare(statements.getSelectWorkflowDefStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.selectAllWorkflowDefVersionsByNameStatement = session.prepare(statements.getSelectAllWorkflowDefVersionsByNameStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.selectAllWorkflowDefsStatement = session.prepare(statements.getSelectAllWorkflowDefsStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.selectTaskDefStatement = session.prepare(statements.getSelectTaskDefStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.selectAllTaskDefsStatement = session.prepare(statements.getSelectAllTaskDefsStatement()).setConsistencyLevel(properties.getReadConsistencyLevel());
        this.updateWorkflowDefStatement = session.prepare(statements.getUpdateWorkflowDefStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.deleteWorkflowDefStatement = session.prepare(statements.getDeleteWorkflowDefStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.deleteWorkflowDefIndexStatement = session.prepare(statements.getDeleteWorkflowDefIndexStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
        this.deleteTaskDefStatement = session.prepare(statements.getDeleteTaskDefStatement()).setConsistencyLevel(properties.getWriteConsistencyLevel());
    }

    public TaskDef createTaskDef(TaskDef taskDef) {
        return this.insertOrUpdateTaskDef(taskDef);
    }

    public TaskDef updateTaskDef(TaskDef taskDef) {
        return this.insertOrUpdateTaskDef(taskDef);
    }

    public TaskDef getTaskDef(String name) {
        return this.getTaskDefFromDB(name);
    }

    public List<TaskDef> getAllTaskDefs() {
        return this.getAllTaskDefsFromDB();
    }

    public void removeTaskDef(String name) {
        try {
            this.recordCassandraDaoRequests("removeTaskDef");
            this.session.execute((Statement)this.deleteTaskDefStatement.bind(new Object[]{name}));
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"removeTaskDef");
            String errorMsg = String.format("Failed to remove task definition: %s", name);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    public void createWorkflowDef(WorkflowDef workflowDef) {
        try {
            String workflowDefinition = this.toJson(workflowDef);
            if (!this.session.execute((Statement)this.insertWorkflowDefStatement.bind(new Object[]{workflowDef.getName(), workflowDef.getVersion(), workflowDefinition})).wasApplied()) {
                throw new ConflictException("Workflow: %s, version: %s already exists!", new Object[]{workflowDef.getName(), workflowDef.getVersion()});
            }
            String workflowDefIndex = this.getWorkflowDefIndexValue(workflowDef.getName(), workflowDef.getVersion());
            this.session.execute((Statement)this.insertWorkflowDefVersionIndexStatement.bind(new Object[]{workflowDefIndex, workflowDefIndex}));
            this.recordCassandraDaoRequests("createWorkflowDef");
            this.recordCassandraDaoPayloadSize("createWorkflowDef", workflowDefinition.length(), "n/a", workflowDef.getName());
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"createWorkflowDef");
            String errorMsg = String.format("Error creating workflow definition: %s/%d", workflowDef.getName(), workflowDef.getVersion());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    public void updateWorkflowDef(WorkflowDef workflowDef) {
        try {
            String workflowDefinition = this.toJson(workflowDef);
            this.session.execute((Statement)this.updateWorkflowDefStatement.bind(new Object[]{workflowDefinition, workflowDef.getName(), workflowDef.getVersion()}));
            String workflowDefIndex = this.getWorkflowDefIndexValue(workflowDef.getName(), workflowDef.getVersion());
            this.session.execute((Statement)this.insertWorkflowDefVersionIndexStatement.bind(new Object[]{workflowDefIndex, workflowDefIndex}));
            this.recordCassandraDaoRequests("updateWorkflowDef");
            this.recordCassandraDaoPayloadSize("updateWorkflowDef", workflowDefinition.length(), "n/a", workflowDef.getName());
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"updateWorkflowDef");
            String errorMsg = String.format("Error updating workflow definition: %s/%d", workflowDef.getName(), workflowDef.getVersion());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    public Optional<WorkflowDef> getLatestWorkflowDef(String name) {
        List<WorkflowDef> workflowDefList = this.getAllWorkflowDefVersions(name);
        if (workflowDefList != null && workflowDefList.size() > 0) {
            workflowDefList.sort(Comparator.comparingInt(WorkflowDef::getVersion));
            return Optional.of(workflowDefList.get(workflowDefList.size() - 1));
        }
        return Optional.empty();
    }

    public Optional<WorkflowDef> getWorkflowDef(String name, int version) {
        try {
            this.recordCassandraDaoRequests("getWorkflowDef");
            ResultSet resultSet = this.session.execute((Statement)this.selectWorkflowDefStatement.bind(new Object[]{name, version}));
            WorkflowDef workflowDef = Optional.ofNullable(resultSet.one()).map(row -> this.readValue(row.getString("workflow_definition"), WorkflowDef.class)).orElse(null);
            return Optional.ofNullable(workflowDef);
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"getTaskDef");
            String errorMsg = String.format("Error fetching workflow def: %s/%d", name, version);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    public void removeWorkflowDef(String name, Integer version) {
        try {
            this.session.execute((Statement)this.deleteWorkflowDefStatement.bind(new Object[]{name, version}));
            this.session.execute((Statement)this.deleteWorkflowDefIndexStatement.bind(new Object[]{"workflow_def_version_index", this.getWorkflowDefIndexValue(name, version)}));
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"removeWorkflowDef");
            String errorMsg = String.format("Failed to remove workflow definition: %s/%d", name, version);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    public List<WorkflowDef> getAllWorkflowDefs() {
        try {
            ResultSet resultSet = this.session.execute((Statement)this.selectAllWorkflowDefsStatement.bind(new Object[]{"workflow_def_version_index"}));
            List rows = resultSet.all();
            if (rows.size() == 0) {
                LOGGER.info("No workflow definitions were found.");
                return Collections.EMPTY_LIST;
            }
            return rows.stream().map(row -> {
                String defNameVersion = row.getString("workflow_def_name_version");
                ImmutablePair<String, Integer> nameVersion = this.getWorkflowNameAndVersion(defNameVersion);
                return this.getWorkflowDef((String)nameVersion.getLeft(), (Integer)nameVersion.getRight()).orElse(null);
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"getAllWorkflowDefs");
            String errorMsg = "Error retrieving all workflow defs";
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    private TaskDef getTaskDefFromDB(String name) {
        try {
            ResultSet resultSet = this.session.execute((Statement)this.selectTaskDefStatement.bind(new Object[]{name}));
            this.recordCassandraDaoRequests("getTaskDef", name, null);
            return Optional.ofNullable(resultSet.one()).map(this::setDefaults).orElse(null);
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"getTaskDef");
            String errorMsg = String.format("Failed to get task def: %s", name);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    private List<TaskDef> getAllTaskDefsFromDB() {
        try {
            ResultSet resultSet = this.session.execute((Statement)this.selectAllTaskDefsStatement.bind(new Object[]{"task_defs"}));
            List rows = resultSet.all();
            if (rows.size() == 0) {
                LOGGER.info("No task definitions were found.");
                return Collections.EMPTY_LIST;
            }
            return rows.stream().map(this::setDefaults).collect(Collectors.toList());
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"getAllTaskDefs");
            String errorMsg = "Failed to get all task defs";
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    private List<WorkflowDef> getAllWorkflowDefVersions(String name) {
        try {
            ResultSet resultSet = this.session.execute((Statement)this.selectAllWorkflowDefVersionsByNameStatement.bind(new Object[]{name}));
            this.recordCassandraDaoRequests("getAllWorkflowDefVersions", "n/a", name);
            List rows = resultSet.all();
            if (rows.size() == 0) {
                LOGGER.info("Not workflow definitions were found for : {}", (Object)name);
                return null;
            }
            return rows.stream().map(row -> this.readValue(row.getString("workflow_definition"), WorkflowDef.class)).collect(Collectors.toList());
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"getAllWorkflowDefVersions");
            String errorMsg = String.format("Failed to get workflows defs for : %s", name);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
    }

    private TaskDef insertOrUpdateTaskDef(TaskDef taskDef) {
        try {
            String taskDefinition = this.toJson(taskDef);
            this.session.execute((Statement)this.insertTaskDefStatement.bind(new Object[]{taskDef.getName(), taskDefinition}));
            this.recordCassandraDaoRequests("storeTaskDef");
            this.recordCassandraDaoPayloadSize("storeTaskDef", taskDefinition.length(), taskDef.getName(), "n/a");
        }
        catch (DriverException e) {
            Monitors.error((String)CLASS_NAME, (String)"insertOrUpdateTaskDef");
            String errorMsg = String.format("Error creating/updating task definition: %s", taskDef.getName());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new TransientException(errorMsg, (Throwable)e);
        }
        return taskDef;
    }

    @VisibleForTesting
    String getWorkflowDefIndexValue(String name, int version) {
        return name + INDEX_DELIMITER + version;
    }

    @VisibleForTesting
    ImmutablePair<String, Integer> getWorkflowNameAndVersion(String nameVersionStr) {
        int lastIndexOfDelimiter = nameVersionStr.lastIndexOf(INDEX_DELIMITER);
        if (lastIndexOfDelimiter == -1) {
            throw new IllegalStateException(nameVersionStr + " is not in the 'workflowName/version' pattern.");
        }
        String workflowName = nameVersionStr.substring(0, lastIndexOfDelimiter);
        String versionStr = nameVersionStr.substring(lastIndexOfDelimiter + 1);
        try {
            return new ImmutablePair((Object)workflowName, (Object)Integer.parseInt(versionStr));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(versionStr + " in " + nameVersionStr + " is not a valid number.");
        }
    }

    private TaskDef setDefaults(Row row) {
        TaskDef taskDef = this.readValue(row.getString("task_definition"), TaskDef.class);
        if (taskDef != null && taskDef.getResponseTimeoutSeconds() == 0L) {
            taskDef.setResponseTimeoutSeconds(taskDef.getTimeoutSeconds() == 0L ? 3600L : taskDef.getTimeoutSeconds() - 1L);
        }
        return taskDef;
    }
}

