/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.cassandra.util;

import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;

public class Statements {
    private final String keyspace;

    public Statements(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getInsertWorkflowDefStatement() {
        return QueryBuilder.insertInto((String)this.keyspace, (String)"workflow_definitions").value("workflow_def_name", (Object)QueryBuilder.bindMarker()).value("version", (Object)QueryBuilder.bindMarker()).value("workflow_definition", (Object)QueryBuilder.bindMarker()).ifNotExists().getQueryString();
    }

    public String getInsertWorkflowDefVersionIndexStatement() {
        return QueryBuilder.insertInto((String)this.keyspace, (String)"workflow_defs_index").value("workflow_def_version_index", (Object)"workflow_def_version_index").value("workflow_def_name_version", (Object)QueryBuilder.bindMarker()).value("workflow_def_index_value", (Object)QueryBuilder.bindMarker()).getQueryString();
    }

    public String getInsertTaskDefStatement() {
        return QueryBuilder.insertInto((String)this.keyspace, (String)"task_definitions").value("task_defs", (Object)"task_defs").value("task_def_name", (Object)QueryBuilder.bindMarker()).value("task_definition", (Object)QueryBuilder.bindMarker()).getQueryString();
    }

    public String getSelectWorkflowDefStatement() {
        return QueryBuilder.select((String[])new String[]{"workflow_definition"}).from(this.keyspace, "workflow_definitions").where(QueryBuilder.eq((String)"workflow_def_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"version", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getSelectAllWorkflowDefVersionsByNameStatement() {
        return QueryBuilder.select().all().from(this.keyspace, "workflow_definitions").where(QueryBuilder.eq((String)"workflow_def_name", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getSelectAllWorkflowDefsStatement() {
        return QueryBuilder.select().all().from(this.keyspace, "workflow_defs_index").where(QueryBuilder.eq((String)"workflow_def_version_index", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getSelectTaskDefStatement() {
        return QueryBuilder.select((String[])new String[]{"task_definition"}).from(this.keyspace, "task_definitions").where(QueryBuilder.eq((String)"task_defs", (Object)"task_defs")).and(QueryBuilder.eq((String)"task_def_name", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getSelectAllTaskDefsStatement() {
        return QueryBuilder.select().all().from(this.keyspace, "task_definitions").where(QueryBuilder.eq((String)"task_defs", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getUpdateWorkflowDefStatement() {
        return QueryBuilder.update((String)this.keyspace, (String)"workflow_definitions").with(QueryBuilder.set((String)"workflow_definition", (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"workflow_def_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"version", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getDeleteWorkflowDefStatement() {
        return QueryBuilder.delete().from(this.keyspace, "workflow_definitions").where(QueryBuilder.eq((String)"workflow_def_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"version", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getDeleteWorkflowDefIndexStatement() {
        return QueryBuilder.delete().from(this.keyspace, "workflow_defs_index").where(QueryBuilder.eq((String)"workflow_def_version_index", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"workflow_def_name_version", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getDeleteTaskDefStatement() {
        return QueryBuilder.delete().from(this.keyspace, "task_definitions").where(QueryBuilder.eq((String)"task_defs", (Object)"task_defs")).and(QueryBuilder.eq((String)"task_def_name", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getInsertWorkflowStatement() {
        return QueryBuilder.insertInto((String)this.keyspace, (String)"workflows").value("workflow_id", (Object)QueryBuilder.bindMarker()).value("shard_id", (Object)QueryBuilder.bindMarker()).value("task_id", (Object)QueryBuilder.bindMarker()).value("entity", (Object)"workflow").value("payload", (Object)QueryBuilder.bindMarker()).value("total_tasks", (Object)QueryBuilder.bindMarker()).value("total_partitions", (Object)QueryBuilder.bindMarker()).getQueryString();
    }

    public String getInsertTaskStatement() {
        return QueryBuilder.insertInto((String)this.keyspace, (String)"workflows").value("workflow_id", (Object)QueryBuilder.bindMarker()).value("shard_id", (Object)QueryBuilder.bindMarker()).value("task_id", (Object)QueryBuilder.bindMarker()).value("entity", (Object)"task").value("payload", (Object)QueryBuilder.bindMarker()).getQueryString();
    }

    public String getInsertEventExecutionStatement() {
        return QueryBuilder.insertInto((String)this.keyspace, (String)"event_executions").value("message_id", (Object)QueryBuilder.bindMarker()).value("event_handler_name", (Object)QueryBuilder.bindMarker()).value("event_execution_id", (Object)QueryBuilder.bindMarker()).value("payload", (Object)QueryBuilder.bindMarker()).ifNotExists().getQueryString();
    }

    public String getSelectTotalStatement() {
        return QueryBuilder.select((String[])new String[]{"total_tasks", "total_partitions"}).from(this.keyspace, "workflows").where(QueryBuilder.eq((String)"workflow_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"shard_id", (Object)1)).getQueryString();
    }

    public String getSelectTaskStatement() {
        return QueryBuilder.select((String[])new String[]{"payload"}).from(this.keyspace, "workflows").where(QueryBuilder.eq((String)"workflow_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"shard_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"entity", (Object)"task")).and(QueryBuilder.eq((String)"task_id", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getSelectWorkflowStatement() {
        return QueryBuilder.select((String[])new String[]{"payload"}).from(this.keyspace, "workflows").where(QueryBuilder.eq((String)"workflow_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"shard_id", (Object)1)).and(QueryBuilder.eq((String)"entity", (Object)"workflow")).getQueryString();
    }

    public String getSelectWorkflowWithTasksStatement() {
        return QueryBuilder.select().all().from(this.keyspace, "workflows").where(QueryBuilder.eq((String)"workflow_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"shard_id", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getSelectTaskFromLookupTableStatement() {
        return QueryBuilder.select((String[])new String[]{"workflow_id"}).from(this.keyspace, "task_lookup").where(QueryBuilder.eq((String)"task_id", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getSelectTasksFromTaskDefLimitStatement() {
        return QueryBuilder.select().all().from(this.keyspace, "task_def_limit").where(QueryBuilder.eq((String)"task_def_name", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getSelectAllEventExecutionsForMessageFromEventExecutionsStatement() {
        return QueryBuilder.select().all().from(this.keyspace, "event_executions").where(QueryBuilder.eq((String)"message_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"event_handler_name", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getUpdateWorkflowStatement() {
        return QueryBuilder.update((String)this.keyspace, (String)"workflows").with(QueryBuilder.set((String)"payload", (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"workflow_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"shard_id", (Object)1)).and(QueryBuilder.eq((String)"entity", (Object)"workflow")).and(QueryBuilder.eq((String)"task_id", (Object)"")).getQueryString();
    }

    public String getUpdateTotalTasksStatement() {
        return QueryBuilder.update((String)this.keyspace, (String)"workflows").with(QueryBuilder.set((String)"total_tasks", (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"workflow_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"shard_id", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getUpdateTotalPartitionsStatement() {
        return QueryBuilder.update((String)this.keyspace, (String)"workflows").with(QueryBuilder.set((String)"total_partitions", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.set((String)"total_tasks", (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"workflow_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"shard_id", (Object)1)).getQueryString();
    }

    public String getUpdateTaskLookupStatement() {
        return QueryBuilder.update((String)this.keyspace, (String)"task_lookup").with(QueryBuilder.set((String)"workflow_id", (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"task_id", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getUpdateTaskDefLimitStatement() {
        return QueryBuilder.update((String)this.keyspace, (String)"task_def_limit").with(QueryBuilder.set((String)"workflow_id", (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"task_def_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"task_id", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getUpdateEventExecutionStatement() {
        return QueryBuilder.update((String)this.keyspace, (String)"event_executions").using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker())).with(QueryBuilder.set((String)"payload", (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"message_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"event_handler_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"event_execution_id", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getDeleteWorkflowStatement() {
        return QueryBuilder.delete().from(this.keyspace, "workflows").where(QueryBuilder.eq((String)"workflow_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"shard_id", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getDeleteTaskLookupStatement() {
        return QueryBuilder.delete().from(this.keyspace, "task_lookup").where(QueryBuilder.eq((String)"task_id", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getDeleteTaskStatement() {
        return QueryBuilder.delete().from(this.keyspace, "workflows").where(QueryBuilder.eq((String)"workflow_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"shard_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"entity", (Object)"task")).and(QueryBuilder.eq((String)"task_id", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getDeleteTaskDefLimitStatement() {
        return QueryBuilder.delete().from(this.keyspace, "task_def_limit").where(QueryBuilder.eq((String)"task_def_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"task_id", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getDeleteEventExecutionsStatement() {
        return QueryBuilder.delete().from(this.keyspace, "event_executions").where(QueryBuilder.eq((String)"message_id", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"event_handler_name", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"event_execution_id", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getInsertEventHandlerStatement() {
        return QueryBuilder.insertInto((String)this.keyspace, (String)"event_handlers").value("handlers", (Object)"handlers").value("event_handler_name", (Object)QueryBuilder.bindMarker()).value("event_handler", (Object)QueryBuilder.bindMarker()).getQueryString();
    }

    public String getSelectAllEventHandlersStatement() {
        return QueryBuilder.select().all().from(this.keyspace, "event_handlers").where(QueryBuilder.eq((String)"handlers", (Object)QueryBuilder.bindMarker())).getQueryString();
    }

    public String getDeleteEventHandlerStatement() {
        return QueryBuilder.delete().from(this.keyspace, "event_handlers").where(QueryBuilder.eq((String)"handlers", (Object)"handlers")).and(QueryBuilder.eq((String)"event_handler_name", (Object)QueryBuilder.bindMarker())).getQueryString();
    }
}

