/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.net.URI;
import java.util.Collection;
import java.util.function.Function;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBase {
    private static Logger logger = LoggerFactory.getLogger(ClientBase.class);
    protected final Client client;
    protected String root = "";
    protected ObjectMapper objectMapper = new ObjectMapper();

    protected ClientBase() {
        this((ClientConfig)new DefaultClientConfig(), null);
    }

    protected ClientBase(ClientConfig clientConfig) {
        this(clientConfig, null);
    }

    protected ClientBase(ClientConfig clientConfig, ClientHandler handler) {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        JacksonJsonProvider provider = new JacksonJsonProvider(this.objectMapper);
        clientConfig.getSingletons().add(provider);
        this.client = handler == null ? Client.create((ClientConfig)clientConfig) : new Client(handler, clientConfig);
    }

    public void setRootURI(String root) {
        this.root = root;
    }

    protected void delete(String url, Object ... uriVariables) {
        this.delete(null, url, uriVariables);
    }

    protected void delete(Object[] queryParams, String url, Object ... uriVariables) {
        URI uri = null;
        try {
            uri = this.getURIBuilder(this.root + url, queryParams).build(uriVariables);
            this.client.resource(uri).delete();
        }
        catch (RuntimeException e) {
            this.handleException(uri, e);
        }
    }

    protected void put(String url, Object[] queryParams, Object request, Object ... uriVariables) {
        URI uri = null;
        try {
            uri = this.getURIBuilder(this.root + url, queryParams).build(uriVariables);
            this.getWebResourceBuilder(uri, request).put();
        }
        catch (RuntimeException e) {
            this.handleException(uri, e);
        }
    }

    @Deprecated
    protected void postForEntity(String url, Object request) {
        this.postForEntityWithRequestOnly(url, request);
    }

    protected void postForEntityWithRequestOnly(String url, Object request) {
        Class type = null;
        this.postForEntity(url, request, null, type, new Object[0]);
    }

    @Deprecated
    protected void postForEntity1(String url, Object ... uriVariables) {
        this.postForEntityWithUriVariablesOnly(url, uriVariables);
    }

    protected void postForEntityWithUriVariablesOnly(String url, Object ... uriVariables) {
        Class type = null;
        this.postForEntity(url, null, null, type, uriVariables);
    }

    protected <T> T postForEntity(String url, Object request, Object[] queryParams, Class<T> responseType, Object ... uriVariables) {
        return (T)this.postForEntity(url, request, queryParams, (Object)responseType, (Function<WebResource.Builder, T>)((Function<WebResource.Builder, Object>)builder -> builder.post(responseType)), uriVariables);
    }

    protected <T> T postForEntity(String url, Object request, Object[] queryParams, GenericType<T> responseType, Object ... uriVariables) {
        return (T)this.postForEntity(url, request, queryParams, responseType, (WebResource.Builder builder) -> builder.post(responseType), uriVariables);
    }

    private <T> T postForEntity(String url, Object request, Object[] queryParams, Object responseType, Function<WebResource.Builder, T> postWithEntity, Object ... uriVariables) {
        URI uri = null;
        try {
            uri = this.getURIBuilder(this.root + url, queryParams).build(uriVariables);
            WebResource.Builder webResourceBuilder = this.getWebResourceBuilder(uri, request);
            if (responseType == null) {
                webResourceBuilder.post();
                return null;
            }
            return postWithEntity.apply(webResourceBuilder);
        }
        catch (RuntimeException e) {
            this.handleException(uri, e);
            return null;
        }
    }

    protected <T> T getForEntity(String url, Object[] queryParams, Class<T> responseType, Object ... uriVariables) {
        return (T)this.getForEntity(url, queryParams, (ClientResponse response) -> response.getEntity(responseType), uriVariables);
    }

    protected <T> T getForEntity(String url, Object[] queryParams, GenericType<T> responseType, Object ... uriVariables) {
        return (T)this.getForEntity(url, queryParams, (ClientResponse response) -> response.getEntity(responseType), uriVariables);
    }

    private <T> T getForEntity(String url, Object[] queryParams, Function<ClientResponse, T> entityPvoider, Object ... uriVariables) {
        URI uri = null;
        try {
            uri = this.getURIBuilder(this.root + url, queryParams).build(uriVariables);
            ClientResponse response = (ClientResponse)this.client.resource(uri).accept(new String[]{"application/json", "text/plain"}).get(ClientResponse.class);
            if (response.getStatus() < 300) {
                return entityPvoider.apply(response);
            }
            throw new UniformInterfaceException(response);
        }
        catch (RuntimeException e) {
            this.handleException(uri, e);
            return null;
        }
    }

    private WebResource.Builder getWebResourceBuilder(URI URI2, Object entity) {
        return (WebResource.Builder)((WebResource.Builder)this.client.resource(URI2).type("application/json").entity(entity)).accept(new String[]{"text/plain", "application/json"});
    }

    private void handleException(URI uri, RuntimeException e) {
        if (e instanceof ClientHandlerException) {
            logger.error("Unable to invoke Conductor API with uri: {}, failure to process request or response", (Object)uri, (Object)e);
        } else if (e instanceof UniformInterfaceException) {
            logger.error("Unable to invoke Conductor API with uri: {}, unexpected response from server: {}", new Object[]{uri, this.clientResponseToString(((UniformInterfaceException)e).getResponse()), e});
        } else {
            logger.error("Unable to invoke Conductor API with uri: {}, runtime exception occurred", (Object)uri, (Object)e);
        }
        throw e;
    }

    private String clientResponseToString(ClientResponse response) {
        if (response == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[status: ").append(response.getStatus());
        builder.append(", media type: ").append(response.getType());
        if (response.getStatus() != 404) {
            try {
                String responseBody = (String)response.getEntity(String.class);
                if (responseBody != null) {
                    builder.append(", response body: ").append(responseBody);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        builder.append(", response headers: ").append(response.getHeaders());
        builder.append("]");
        return builder.toString();
    }

    private UriBuilder getURIBuilder(String path, Object[] queryParams) {
        if (path == null) {
            path = "";
        }
        UriBuilder builder = UriBuilder.fromPath((String)path);
        if (queryParams != null) {
            for (int i = 0; i < queryParams.length; i += 2) {
                String param = queryParams[i].toString();
                Object value = queryParams[i + 1];
                if (value == null) continue;
                if (value instanceof Collection) {
                    Object[] values = ((Collection)value).toArray();
                    builder.queryParam(param, values);
                    continue;
                }
                builder.queryParam(param, new Object[]{value});
            }
        }
        return builder;
    }
}

