/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.task;

import com.google.common.base.Joiner;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class WorkflowTaskMetrics {
    private static final String TASK_TYPE = "taskType";
    private static final String EXCEPTION = "exception";
    private static final String TASK_EXECUTION_QUEUE_FULL = "task_execution_queue_full";
    private static final String TASK_POLL_ERROR = "task_poll_error";
    private static final String TASK_PAUSED = "task_paused";
    private static final String TASK_EXECUTE_ERROR = "task_execute_error";
    private static final String TASK_ACK_FAILED = "task_ack_failed";
    private static final String TASK_ACK_ERROR = "task_ack_error";
    private static final String TASK_UPDATE_ERROR = "task_update_error";
    private static final String TASK_POLL_COUNTER = "task_poll_counter";
    private static final String TASK_EXECUTE_TIME = "task_execute_time";
    private static final String TASK_POLL_TIME = "task_poll_time";
    public static final String TASK_RESULT_SIZE = "task_result_size";
    private static Registry registry = Spectator.globalRegistry();
    private static ConcurrentHashMap<String, Timer> monitors = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Counter> errors = new ConcurrentHashMap();
    private static Map<String, AtomicLong> gauges = new ConcurrentHashMap<String, AtomicLong>();
    private static final String className = WorkflowTaskMetrics.class.getSimpleName();

    private WorkflowTaskMetrics() {
    }

    public static Timer getPollTimer(String taskType) {
        return WorkflowTaskMetrics.getTimer(TASK_POLL_TIME, TASK_TYPE, taskType);
    }

    public static Timer getExecutionTimer(String taskType) {
        return WorkflowTaskMetrics.getTimer(TASK_EXECUTE_TIME, TASK_TYPE, taskType);
    }

    private static Timer getTimer(String name, String ... additionalTags) {
        String key = className + "." + name + "." + Joiner.on((String)",").join((Object[])additionalTags);
        return monitors.computeIfAbsent(key, k -> {
            List<Tag> tagList = WorkflowTaskMetrics.getTags(additionalTags);
            tagList.add((Tag)new BasicTag("unit", TimeUnit.MILLISECONDS.name()));
            return registry.timer(name, tagList);
        });
    }

    private static List<Tag> getTags(String[] additionalTags) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        tagList.add((Tag)new BasicTag("class", className));
        for (int j = 0; j < additionalTags.length - 1; ++j) {
            tagList.add((Tag)new BasicTag(additionalTags[j], additionalTags[j + 1]));
            ++j;
        }
        return tagList;
    }

    private static void incrementCount(String name, String ... additionalTags) {
        WorkflowTaskMetrics.getCounter(name, additionalTags).increment();
    }

    private static Counter getCounter(String name, String ... additionalTags) {
        String key = className + "." + name + "." + Joiner.on((String)",").join((Object[])additionalTags);
        return errors.computeIfAbsent(key, k -> {
            List<Tag> tags = WorkflowTaskMetrics.getTags(additionalTags);
            return registry.counter(name, tags);
        });
    }

    public static void incrementTaskExecutionQueueFullCount(String taskType) {
        WorkflowTaskMetrics.incrementCount(TASK_EXECUTION_QUEUE_FULL, TASK_TYPE, taskType);
    }

    public static void incrementTaskPollErrorCount(String taskType, Exception e) {
        WorkflowTaskMetrics.incrementCount(TASK_POLL_ERROR, TASK_TYPE, taskType, EXCEPTION, e.getClass().getSimpleName());
    }

    public static void incrementTaskPausedCount(String taskType) {
        WorkflowTaskMetrics.incrementCount(TASK_PAUSED, TASK_TYPE, taskType);
    }

    public static void incrementTaskExecutionErrorCount(String taskType, Throwable e) {
        WorkflowTaskMetrics.incrementCount(TASK_EXECUTE_ERROR, TASK_TYPE, taskType, EXCEPTION, e.getClass().getSimpleName());
    }

    public static void incrementTaskAckFailedCount(String taskType) {
        WorkflowTaskMetrics.incrementCount(TASK_ACK_FAILED, TASK_TYPE, taskType);
    }

    public static void incrementTaskAckErrorCount(String taskType, Exception e) {
        WorkflowTaskMetrics.incrementCount(TASK_ACK_ERROR, TASK_TYPE, taskType, EXCEPTION, e.getClass().getSimpleName());
    }

    private static AtomicLong getGauge(String name, String ... additionalTags) {
        String key = className + "." + name + "." + Joiner.on((String)",").join((Object[])additionalTags);
        return gauges.computeIfAbsent(key, pollTimer -> {
            Id id = registry.createId(name, WorkflowTaskMetrics.getTags(additionalTags));
            return (AtomicLong)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withId(id)).monitorValue((Number)new AtomicLong(0L));
        });
    }

    public static void recordTaskResultPayloadSize(String taskType, long payloadSize) {
        WorkflowTaskMetrics.getGauge(TASK_RESULT_SIZE, TASK_TYPE, taskType).getAndSet(payloadSize);
    }

    public static void incrementTaskUpdateErrorCount(String taskType, Throwable t) {
        WorkflowTaskMetrics.incrementCount(TASK_UPDATE_ERROR, TASK_TYPE, taskType, EXCEPTION, t.getClass().getSimpleName());
    }

    public static void incrementTaskPollCount(String taskType, int taskCount) {
        WorkflowTaskMetrics.getCounter(TASK_POLL_COUNTER, TASK_TYPE, taskType).increment((long)taskCount);
    }
}

