/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.google.common.base.Preconditions;
import com.google.common.io.CountingOutputStream;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.client.task.WorkflowTaskMetrics;
import com.netflix.conductor.common.metadata.tasks.PollData;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.TaskSummary;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskClient
extends ClientBase {
    private static GenericType<List<Task>> taskList = new GenericType<List<Task>>(){};
    private static GenericType<List<TaskDef>> taskDefList = new GenericType<List<TaskDef>>(){};
    private static GenericType<List<TaskExecLog>> taskExecLogList = new GenericType<List<TaskExecLog>>(){};
    private static GenericType<List<PollData>> pollDataList = new GenericType<List<PollData>>(){};
    private static GenericType<SearchResult<TaskSummary>> searchResultTaskSummary = new GenericType<SearchResult<TaskSummary>>(){};
    private static final Logger logger = LoggerFactory.getLogger(TaskClient.class);

    public TaskClient() {
    }

    public TaskClient(ClientConfig config) {
        super(config);
    }

    public TaskClient(ClientConfig config, ClientHandler handler) {
        super(config, handler);
    }

    public TaskClient(ClientConfig config, ClientHandler handler, ClientFilter ... filters) {
        super(config, handler);
        for (ClientFilter filter : filters) {
            this.client.addFilter(filter);
        }
    }

    public Task pollTask(String taskType, String workerId, String domain) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)domain), (Object)"Domain cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workerId), (Object)"Worker id cannot be blank");
        Object[] params = new Object[]{"workerid", workerId, "domain", domain};
        return this.getForEntity("tasks/poll/{taskType}", params, Task.class, taskType);
    }

    @Deprecated
    public List<Task> poll(String taskType, String workerId, int count, int timeoutInMillisecond) {
        return this.batchPollTasksByTaskType(taskType, workerId, count, timeoutInMillisecond);
    }

    public List<Task> batchPollTasksByTaskType(String taskType, String workerId, int count, int timeoutInMillisecond) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workerId), (Object)"Worker id cannot be blank");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be greater than 0");
        Object[] params = new Object[]{"workerid", workerId, "count", count, "timeout", timeoutInMillisecond};
        return this.getForEntity("tasks/poll/batch/{taskType}", params, taskList, taskType);
    }

    @Deprecated
    public List<Task> poll(String taskType, String domain, String workerId, int count, int timeoutInMillisecond) {
        return this.batchPollTasksInDomain(taskType, domain, workerId, count, timeoutInMillisecond);
    }

    public List<Task> batchPollTasksInDomain(String taskType, String domain, String workerId, int count, int timeoutInMillisecond) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workerId), (Object)"Worker id cannot be blank");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be greater than 0");
        Object[] params = new Object[]{"workerid", workerId, "count", count, "timeout", timeoutInMillisecond, "domain", domain};
        return this.getForEntity("tasks/poll/batch/{taskType}", params, taskList, taskType);
    }

    @Deprecated
    public List<Task> getTasks(String taskType, String startKey, Integer count) {
        return this.getPendingTasksByType(taskType, startKey, count);
    }

    public List<Task> getPendingTasksByType(String taskType, String startKey, Integer count) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Object[] params = new Object[]{"startKey", startKey, "count", count};
        return this.getForEntity("tasks/in_progress/{taskType}", params, taskList, taskType);
    }

    public Task getPendingTaskForWorkflow(String workflowId, String taskReferenceName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"Workflow id cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskReferenceName), (Object)"Task reference name cannot be blank");
        return this.getForEntity("tasks/in_progress/{workflowId}/{taskRefName}", null, Task.class, workflowId, taskReferenceName);
    }

    public void updateTask(TaskResult taskResult, String taskType) {
        Preconditions.checkNotNull((Object)taskResult, (Object)"Task result cannot be null");
        long taskResultSize = 0L;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)byteArrayOutputStream);){
            this.objectMapper.writeValue((OutputStream)countingOutputStream, (Object)taskResult);
            taskResultSize = countingOutputStream.getCount();
            WorkflowTaskMetrics.recordTaskResultPayloadSize(taskType, taskResultSize);
            if (taskResultSize > 0x300000L) {
                taskResult.setReasonForIncompletion(String.format("The TaskResult payload: %d is greater than the permissible 3MB", taskResultSize));
                taskResult.setStatus(TaskResult.Status.FAILED_WITH_TERMINAL_ERROR);
                taskResult.setOutputData(null);
            }
        }
        catch (Exception e) {
            logger.error("Unable to parse the TaskResult: {}", (Object)taskResult);
            throw new RuntimeException(e);
        }
        this.postForEntity("tasks", taskResult);
    }

    public Boolean ack(String taskId, String workerId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskId), (Object)"Task id cannot be blank");
        String response = this.postForEntity("tasks/{taskId}/ack", null, new Object[]{"workerid", workerId}, String.class, taskId);
        return Boolean.valueOf(response);
    }

    @Deprecated
    public void log(String taskId, String logMessage) {
        this.logMessageForTask(taskId, logMessage);
    }

    public void logMessageForTask(String taskId, String logMessage) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskId), (Object)"Task id cannot be blank");
        this.postForEntity("tasks/" + taskId + "/log", logMessage);
    }

    public List<TaskExecLog> getTaskLogs(String taskId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskId), (Object)"Task id cannot be blank");
        return this.getForEntity("tasks/{taskId}/log", null, taskExecLogList, taskId);
    }

    @Deprecated
    public Task get(String taskId) {
        return this.getTaskDetails(taskId);
    }

    public Task getTaskDetails(String taskId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskId), (Object)"Task id cannot be blank");
        return this.getForEntity("tasks/{taskId}", null, Task.class, taskId);
    }

    public void removeTaskFromQueue(String taskType, String taskId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskId), (Object)"Task id cannot be blank");
        this.delete("tasks/queue/{taskType}/{taskId}", taskType, taskId);
    }

    public int getQueueSizeForTask(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Map queueSizeMap = this.getForEntity("tasks/queue/sizes", new Object[]{"taskType", taskType}, Map.class, new Object[0]);
        if (queueSizeMap.keySet().contains(taskType)) {
            return (Integer)queueSizeMap.get(taskType);
        }
        return 0;
    }

    public List<PollData> getPollData(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Object[] params = new Object[]{"taskType", taskType};
        return this.getForEntity("tasks/queue/polldata", params, pollDataList, new Object[0]);
    }

    public List<PollData> getAllPollData() {
        return this.getForEntity("tasks/queue/polldata/all", null, pollDataList, new Object[0]);
    }

    public String requeueAllPendingTasks() {
        return this.postForEntity("tasks/queue/requeue", null, null, String.class, new Object[0]);
    }

    public String requeuePendingTasksByTaskType(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        return this.postForEntity("tasks/queue/requeue/{taskType}", null, null, String.class, taskType);
    }

    public SearchResult<TaskSummary> search(String query) {
        return this.getForEntity("tasks/search", new Object[]{"query", query}, searchResultTaskSummary, new Object[0]);
    }

    public SearchResult<TaskSummary> search(Integer start, Integer size, String sort, String freeText, String query) {
        Object[] params = new Object[]{"start", start, "size", size, "sort", sort, "freeText", freeText, "query", query};
        return this.getForEntity("tasks/search", params, searchResultTaskSummary, new Object[0]);
    }

    @Deprecated
    public List<TaskDef> getTaskDef() {
        return this.getForEntity("metadata/taskdefs", null, taskDefList, new Object[0]);
    }

    @Deprecated
    public TaskDef getTaskDef(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        return this.getForEntity("metadata/taskdefs/{tasktype}", null, TaskDef.class, taskType);
    }

    @Deprecated
    public void unregisterTaskDef(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        this.delete("metadata/taskdefs/{tasktype}", taskType);
    }

    @Deprecated
    public void registerTaskDefs(List<TaskDef> taskDefs) {
        Preconditions.checkNotNull(taskDefs, (Object)"Task defs cannot be null");
        this.postForEntity("metadata/taskdefs", taskDefs);
    }
}

