/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.google.common.base.Preconditions;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.common.metadata.workflow.RerunWorkflowRequest;
import com.netflix.conductor.common.metadata.workflow.StartWorkflowRequest;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.common.run.WorkflowSummary;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WorkflowClient
extends ClientBase {
    private static GenericType<List<WorkflowDef>> workflowDefList = new GenericType<List<WorkflowDef>>(){};
    private static GenericType<SearchResult<WorkflowSummary>> searchResultWorkflowSummary = new GenericType<SearchResult<WorkflowSummary>>(){};

    public WorkflowClient() {
    }

    public WorkflowClient(ClientConfig config) {
        super(config);
    }

    public WorkflowClient(ClientConfig config, ClientHandler handler) {
        super(config, handler);
    }

    public WorkflowClient(ClientConfig config, ClientHandler handler, ClientFilter ... filters) {
        super(config, handler);
        for (ClientFilter filter : filters) {
            this.client.addFilter(filter);
        }
    }

    @Deprecated
    public List<WorkflowDef> getAllWorkflowDefs() {
        return this.getForEntity("metadata/workflow", null, workflowDefList, new Object[0]);
    }

    @Deprecated
    public void registerWorkflow(WorkflowDef workflowDef) {
        Preconditions.checkNotNull((Object)workflowDef, (Object)"Worfklow definition cannot be null");
        this.postForEntity("metadata/workflow", workflowDef);
    }

    @Deprecated
    public WorkflowDef getWorkflowDef(String name, Integer version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"name cannot be blank");
        return this.getForEntity("metadata/workflow/{name}", new Object[]{"version", version}, WorkflowDef.class, name);
    }

    public String startWorkflow(String name, Integer version, String correlationId, Map<String, Object> input) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"name cannot be blank");
        Object[] params = new Object[]{"version", version, "correlationId", correlationId};
        return this.postForEntity("workflow/{name}", input, params, String.class, name);
    }

    public String startWorkflow(StartWorkflowRequest startWorkflowRequest) {
        Preconditions.checkNotNull((Object)startWorkflowRequest, (Object)"StartWorkflowRequest cannot be null");
        return this.postForEntity("workflow", (Object)startWorkflowRequest, null, String.class, startWorkflowRequest.getName());
    }

    @Deprecated
    public Workflow getExecutionStatus(String workflowId, boolean includeTasks) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        return this.getWorkflow(workflowId, includeTasks);
    }

    public Workflow getWorkflow(String workflowId, boolean includeTasks) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        return this.getForEntity("workflow/{workflowId}", new Object[]{"includeTasks", includeTasks}, Workflow.class, workflowId);
    }

    public List<Workflow> getWorkflows(String name, String correlationId, boolean includeClosed, boolean includeTasks) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"name cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)correlationId), (Object)"correlationId cannot be blank");
        Object[] params = new Object[]{"includeClosed", includeClosed, "includeTasks", includeTasks};
        return this.getForEntity("workflow/{name}/correlated/{correlationId}", params, new GenericType<List<Workflow>>(){}, name, correlationId);
    }

    public void deleteWorkflow(String workflowId, boolean archiveWorkflow) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"Workflow id cannot be blank");
        Object[] params = new Object[]{"archiveWorkflow", archiveWorkflow};
        this.delete(params, "workflow/{workflowId}/remove", workflowId);
    }

    public List<String> getRunningWorkflow(String workflowName, Integer version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowName), (Object)"Workflow name cannot be blank");
        return this.getForEntity("workflow/running/{name}", new Object[]{"version", version}, new GenericType<List<String>>(){}, workflowName);
    }

    public List<String> getWorkflowsByTimePeriod(String workflowName, int version, Long startTime, Long endTime) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowName), (Object)"Workflow name cannot be blank");
        Preconditions.checkNotNull((Object)startTime, (Object)"Start time cannot be null");
        Preconditions.checkNotNull((Object)endTime, (Object)"End time cannot be null");
        Object[] params = new Object[]{"version", version, "startTime", startTime, "endTime", endTime};
        return this.getForEntity("workflow/running/{name}", params, new GenericType<List<String>>(){}, workflowName);
    }

    public void runDecider(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.put("workflow/decide/{workflowId}", null, null, workflowId);
    }

    public void pauseWorkflow(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.put("workflow/{workflowId}/pause", null, null, workflowId);
    }

    public void resumeWorkflow(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.put("workflow/{workflowId}/resume", null, null, workflowId);
    }

    public void skipTaskFromWorkflow(String workflowId, String taskReferenceName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskReferenceName), (Object)"Task reference name cannot be blank");
        this.put("workflow/{workflowId}/skiptask/{taskReferenceName}", null, workflowId, taskReferenceName);
    }

    public String rerunWorkflow(String workflowId, RerunWorkflowRequest rerunWorkflowRequest) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        Preconditions.checkNotNull((Object)rerunWorkflowRequest, (Object)"RerunWorkflowRequest cannot be null");
        return this.postForEntity("workflow/{workflowId}/rerun", (Object)rerunWorkflowRequest, null, String.class, workflowId);
    }

    public void restart(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.postForEntity1("workflow/{workflowId}/restart", workflowId);
    }

    public void retryLastFailedTask(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.postForEntity1("workflow/{workflowId}/retry", workflowId);
    }

    public void resetCallbacksForInProgressTasks(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.postForEntity1("workflow/{workflowId}/resetcallbacks", workflowId);
    }

    public void terminateWorkflow(String workflowId, String reason) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.delete(new Object[]{"reason", reason}, "workflow/{workflowId}", workflowId);
    }

    public SearchResult<WorkflowSummary> search(String query) {
        return this.getForEntity("workflow/search", new Object[]{"query", query}, searchResultWorkflowSummary, new Object[0]);
    }

    public SearchResult<WorkflowSummary> search(Integer start, Integer size, String sort, String freeText, String query) {
        Object[] params = new Object[]{"start", start, "size", size, "sort", sort, "freeText", freeText, "query", query};
        return this.getForEntity("workflow/search", params, searchResultWorkflowSummary, new Object[0]);
    }
}

