/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.core.UriBuilder;

public abstract class ClientBase {
    protected Client client;
    protected String root = "";

    protected ClientBase() {
        this((ClientConfig)new DefaultClientConfig(), null);
    }

    protected ClientBase(ClientConfig cc) {
        this(cc, null);
    }

    protected ClientBase(ClientConfig cc, ClientHandler handler) {
        JacksonJsonProvider provider = new JacksonJsonProvider(this.objectMapper());
        cc.getSingletons().add(provider);
        this.client = handler == null ? Client.create((ClientConfig)cc) : new Client(handler, cc);
    }

    public void setRootURI(String root) {
        this.root = root;
    }

    private UriBuilder getURI(String path, Object[] queryParams) {
        if (path == null) {
            path = "";
        }
        UriBuilder builder = UriBuilder.fromPath((String)path);
        if (queryParams != null) {
            for (int i = 0; i < queryParams.length; i += 2) {
                String param = queryParams[i].toString();
                Object value = queryParams[i + 1];
                if (value == null) continue;
                if (value instanceof Collection) {
                    Object[] values = ((Collection)value).toArray();
                    builder.queryParam(param, values);
                    continue;
                }
                builder.queryParam(param, new Object[]{value});
            }
        }
        return builder;
    }

    protected void delete(String url, Object ... uriVariables) {
        this.delete(null, url, uriVariables);
    }

    protected void delete(Object[] queryParams, String url, Object ... uriVariables) {
        try {
            URI URI2 = this.getURI(this.root + url, queryParams).build(uriVariables);
            this.client.resource(URI2).delete();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void put(String url, Object[] queryParams, Object request, Object ... uriVariables) {
        try {
            URI URI2 = this.getURI(this.root + url, queryParams).build(uriVariables);
            this.resource(URI2, request).put();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void postForEntity(String url, Object request) {
        Class type = null;
        this.postForEntity(url, request, null, type, new Object[0]);
    }

    protected void postForEntity1(String url, Object ... uriVariables) {
        Class type = null;
        this.postForEntity(url, null, null, type, uriVariables);
    }

    protected <T> T postForEntity(String url, Object request, Object[] queryParams, Class<T> responseType, Object ... uriVariables) {
        try {
            URI URI2 = this.getURI(this.root + url, queryParams).build(uriVariables);
            if (responseType == null) {
                this.resource(URI2, request).post();
                return null;
            }
            Object response = this.resource(URI2, request).post(responseType);
            return (T)response;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected <T> T postForEntity(String url, Object request, Object[] queryParams, GenericType<T> responseType, Object ... uriVariables) {
        try {
            URI URI2 = this.getURI(this.root + url, queryParams).build(uriVariables);
            if (responseType == null) {
                this.resource(URI2, request).post();
                return null;
            }
            Object response = this.resource(URI2, request).post(responseType);
            return (T)response;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected <T> T getForEntity(String url, Object[] queryParams, Class<T> responseType, Object ... uriVariables) {
        try {
            URI URI2 = this.getURI(this.root + url, queryParams).build(uriVariables);
            Object response = this.client.resource(URI2).accept(new String[]{"application/json", "text/plain"}).get(responseType);
            return (T)response;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected <T> T getForEntity(String url, Object[] queryParams, GenericType<T> responseType, Object ... uriVariables) {
        try {
            URI URI2 = this.getURI(this.root + url, queryParams).build(uriVariables);
            Object response = this.client.resource(URI2).accept(new String[]{"application/json", "text/plain"}).get(responseType);
            return (T)response;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private WebResource.Builder resource(URI URI2, Object entity) {
        return (WebResource.Builder)((WebResource.Builder)this.client.resource(URI2).type("application/json").entity(entity)).accept(new String[]{"application/json", "text/plain"});
    }

    private void handleException(Exception e) {
        e.printStackTrace();
        throw new RuntimeException(e);
    }

    protected ObjectMapper objectMapper() {
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        om.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        om.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        om.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        om.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return om;
    }
}

