/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.worker;

import com.netflix.conductor.common.metadata.tasks.Task;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Worker {
    public String getTaskDefName();

    public Task execute(Task var1);

    default public void onErrorUpdate(Task task) {
    }

    default public boolean paused() {
        return false;
    }

    default public String getIdentity() {
        String serverId;
        try {
            serverId = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            serverId = System.getenv("HOSTNAME");
        }
        if (serverId == null) {
            serverId = System.getProperty("user.name");
        }
        return serverId;
    }

    default public int getPollCount() {
        return 1;
    }

    default public int getLongPollTimeoutInMS() {
        return 100;
    }

    public static Worker create(String taskType, Function<Task, Task> executor) {
        return Worker.create(taskType, executor, () -> false);
    }

    public static Worker create(final String taskType, final Function<Task, Task> executor, final Supplier<Boolean> paused) {
        return new Worker(){

            @Override
            public String getTaskDefName() {
                return taskType;
            }

            @Override
            public Task execute(Task task) {
                return (Task)executor.apply(task);
            }

            @Override
            public boolean paused() {
                return (Boolean)paused.get();
            }
        };
    }
}

