/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.common.metadata.workflow.RerunWorkflowRequest;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.common.run.WorkflowSummary;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public class WorkflowClient
extends ClientBase {
    public WorkflowClient() {
    }

    public WorkflowClient(ClientConfig config) {
        super(config);
    }

    public WorkflowClient(ClientConfig config, ClientHandler handler) {
        super(config, handler);
    }

    public WorkflowClient(ClientConfig config, ClientHandler handler, ClientFilter ... filters) {
        super(config, handler);
        for (ClientFilter filter : filters) {
            this.client.addFilter(filter);
        }
    }

    public List<WorkflowDef> getAllWorkflowDefs() {
        WorkflowDef[] defs = this.getForEntity("metadata/workflow", null, WorkflowDef[].class, new Object[0]);
        return Arrays.asList(defs);
    }

    public void registerWorkflow(WorkflowDef def) {
        this.postForEntity("metadata/workflow", def);
    }

    public WorkflowDef getWorkflowDef(@PathParam(value="name") String name, @QueryParam(value="version") Integer version) {
        return this.getForEntity("metadata/workflow/{name}", new Object[]{"version", version}, WorkflowDef.class, name);
    }

    public String startWorkflow(String name, Integer version, String correlationId, Map<String, Object> input) {
        Object[] params = new Object[]{"version", version, "correlationId", correlationId};
        return this.postForEntity("workflow/{name}", input, params, String.class, name);
    }

    public Workflow getExecutionStatus(String workflowId, boolean includeTasks) {
        return this.getWorkflow(workflowId, includeTasks);
    }

    public Workflow getWorkflow(String workflowId, boolean includeTasks) {
        return this.getForEntity("workflow/{workflowId}", new Object[]{"includeTasks", includeTasks}, Workflow.class, workflowId);
    }

    public List<Workflow> getWorkflows(String name, String correlationId, boolean includeClosed, boolean includeTasks) {
        Object[] params = new Object[]{"includeClosed", includeClosed, "includeTasks", includeTasks};
        return this.getForEntity("workflow/{name}/correlated/{correlationId}", params, new GenericType<List<Workflow>>(){}, name, correlationId);
    }

    public List<String> getRunningWorkflow(String workflowName, Integer version) {
        return this.getForEntity("workflow/running/{name}", new Object[]{"version", version}, new GenericType<List<String>>(){}, workflowName);
    }

    public void pauseWorkflow(String workflowId) {
        this.put("workflow/{workflowId}/pause", null, workflowId, new Object[0]);
    }

    public void resumeWorkflow(String workflowId) {
        this.put("workflow/{workflowId}/resume", null, workflowId, new Object[0]);
    }

    public void restart(String workflowId) {
        this.postForEntity1("workflow/{workflowId}/restart", workflowId);
    }

    public void retryLastFailedTask(String workflowId) {
        this.postForEntity1("workflow/{workflowId}/retry", workflowId);
    }

    public void terminateWorkflow(String workflowId, String reason) {
        this.delete(new Object[]{"reason", reason}, "workflow/{workflowId}", workflowId);
    }

    public String rerunWorkflow(String workflowId, RerunWorkflowRequest request) {
        return this.postForEntity("workflow/{workflowId}/rerun", (Object)request, null, String.class, workflowId);
    }

    public void skipTaskFromWorkflow(String workflowId, String taskReferenceName) {
        this.put("workflow/{workflowId}/skiptask/{taskReferenceName}", null, workflowId, taskReferenceName);
    }

    public void runDecider(String workflowId) {
        this.put("workflow/decide/{workflowId}", null, null, workflowId);
    }

    public SearchResult<WorkflowSummary> search(String query) {
        SearchResult<WorkflowSummary> result = this.getForEntity("workflow/search", new Object[]{"query", query}, new GenericType<SearchResult<WorkflowSummary>>(){}, new Object[0]);
        return result;
    }
}

