/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.task;

import com.google.common.base.Joiner;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicStopwatch;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.StatsMonitor;
import com.netflix.servo.monitor.StatsTimer;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.stats.StatsConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class WorkflowTaskMetrics {
    private static StatsConfig statsConfig = new StatsConfig.Builder().withPublishCount(true).withPublishMax(true).withPublishMean(true).withPublishMin(true).withPublishTotal(true).build();
    private static MonitorRegistry registry = DefaultMonitorRegistry.getInstance();
    private static ConcurrentHashMap<String, StatsTimer> monitors = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, BasicCounter> errors = new ConcurrentHashMap();
    private static final String className = WorkflowTaskMetrics.class.getSimpleName();

    private WorkflowTaskMetrics() {
    }

    private static Stopwatch start(String name, String taskType) {
        return WorkflowTaskMetrics.start((StatsMonitor)WorkflowTaskMetrics.getTimer(name, "taskType", taskType));
    }

    private static StatsTimer getTimer(String name, String ... additionalTags) {
        String key = className + "." + name + "." + Joiner.on((String)",").join((Object[])additionalTags);
        return monitors.computeIfAbsent(key, k -> {
            MonitorConfig.Builder cb = MonitorConfig.builder((String)name).withTag("class", className).withTag("unit", TimeUnit.MILLISECONDS.name());
            for (int j = 0; j < additionalTags.length - 1; ++j) {
                String tk = additionalTags[j];
                String tv = additionalTags[j + 1];
                cb.withTag(tk, tv);
                ++j;
            }
            MonitorConfig config = cb.build();
            StatsTimer sm = new StatsTimer(config, statsConfig);
            registry.register((Monitor)sm);
            return sm;
        });
    }

    private static void counter(String name, String ... additionalTags) {
        WorkflowTaskMetrics.getCounter(name, additionalTags).increment();
    }

    private static BasicCounter getCounter(String name, String ... additionalTags) {
        String key = className + "." + name + "." + Joiner.on((String)",").join((Object[])additionalTags);
        return errors.computeIfAbsent(key, k -> {
            MonitorConfig.Builder cb = MonitorConfig.builder((String)name).withTag("class", className);
            for (int j = 0; j < additionalTags.length - 1; ++j) {
                String tk = additionalTags[j];
                String tv = additionalTags[j + 1];
                cb.withTag(tk, tv);
                ++j;
            }
            MonitorConfig config = cb.build();
            BasicCounter bc = new BasicCounter(config);
            registry.register((Monitor)bc);
            return bc;
        });
    }

    private static Stopwatch start(final StatsMonitor sm) {
        BasicStopwatch sw = new BasicStopwatch(){

            public void stop() {
                super.stop();
                long duration = this.getDuration(TimeUnit.MILLISECONDS);
                sm.record(duration);
            }
        };
        sw.start();
        return sw;
    }

    public static void queueFull(String taskType) {
        WorkflowTaskMetrics.counter("task_execution_queue_full", "taskType", taskType);
    }

    public static void pollingException(String taskType, Exception e) {
        WorkflowTaskMetrics.counter("task_poll_error", "taskType", taskType, "exception", e.getClass().getSimpleName());
    }

    public static void paused(String taskType) {
        WorkflowTaskMetrics.counter("task_poll_error", "taskType", taskType);
    }

    public static void executionException(String taskType, Throwable e) {
        WorkflowTaskMetrics.counter("task_execute_error", "taskType", taskType, "exception", e.getClass().getSimpleName());
    }

    public static void ackFailed(String taskType) {
        WorkflowTaskMetrics.counter("task_ack_failed", "taskType", taskType);
    }

    public static void ackException(String taskType, Exception e) {
        WorkflowTaskMetrics.counter("task_ack_error", "taskType", taskType, "exception", e.getClass().getSimpleName());
    }

    public static void updateTaskError(String taskType, Throwable t) {
        WorkflowTaskMetrics.counter("task_update_error", "taskType", taskType, "exception", t.getClass().getSimpleName());
    }

    public static void polled(String taskType) {
        WorkflowTaskMetrics.counter("task_poll_counter", "taskType", taskType);
    }

    public static Stopwatch executionTimer(String taskType) {
        return WorkflowTaskMetrics.start("task_execute_time", taskType);
    }

    public static Stopwatch pollTimer(String taskType) {
        return WorkflowTaskMetrics.start("task_poll_time", taskType);
    }
}

