/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.List;

public class TaskClient
extends ClientBase {
    private static GenericType<List<Task>> tasks = new GenericType<List<Task>>(){};
    private static GenericType<List<TaskDef>> task_def_types = new GenericType<List<TaskDef>>(){};

    public TaskClient() {
    }

    public TaskClient(ClientConfig config) {
        super(config);
    }

    public TaskClient(ClientConfig config, ClientHandler handler) {
        super(config, handler);
    }

    public TaskClient(ClientConfig config, ClientHandler handler, ClientFilter ... filters) {
        super(config, handler);
        for (ClientFilter filter : filters) {
            this.client.addFilter(filter);
        }
    }

    public List<Task> poll(String taskType, String workerId, int count, int timeoutInMillisecond) {
        Object[] params = new Object[]{"workerid", workerId, "count", count, "timeout", timeoutInMillisecond};
        return this.getForEntity("tasks/poll/batch/{taskType}", params, tasks, taskType);
    }

    public List<Task> poll(String taskType, String domain, String workerId, int count, int timeoutInMillisecond) {
        Object[] params = new Object[]{"workerid", workerId, "count", count, "timeout", timeoutInMillisecond, "domain", domain};
        return this.getForEntity("tasks/poll/batch/{taskType}", params, tasks, taskType);
    }

    public Task get(String taskId) {
        Task task = this.getForEntity("tasks/{taskId}", null, Task.class, taskId);
        return task;
    }

    public List<Task> getTasks(String taskType, String startKey, Integer count) {
        Object[] params = new Object[]{"startKey", startKey, "count", count};
        return this.getForEntity("tasks/in_progress/{taskType}", params, tasks, taskType);
    }

    public Task getPendingTaskForWorkflow(String workflowId, String taskReferenceName) {
        return this.getForEntity("tasks/in_progress/{workflowId}/{taskRefName}", null, Task.class, workflowId, taskReferenceName);
    }

    public void updateTask(TaskResult task) {
        this.postForEntity("tasks", task);
    }

    public void log(String taskId, String logMessage) {
        this.postForEntity("tasks/" + taskId + "/log", logMessage);
    }

    public Boolean ack(String taskId, String workerId) {
        Object[] params = new Object[]{"workerid", workerId};
        String response = this.postForEntity("tasks/{taskId}/ack", null, params, String.class, taskId);
        return Boolean.valueOf(response);
    }

    public List<TaskDef> getTaskDef() {
        return this.getForEntity("metadata/taskdefs", null, task_def_types, new Object[0]);
    }

    public TaskDef getTaskDef(String taskType) {
        return this.getForEntity("metadata/taskdefs/{tasktype}", null, TaskDef.class, taskType);
    }

    public void unregisterTaskDef(String taskType) {
        this.delete("metadata/taskdefs/{tasktype}", taskType);
    }

    public void registerTaskDefs(List<TaskDef> taskDefs) {
        this.postForEntity("metadata/taskdefs", taskDefs);
    }
}

