/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.google.common.base.Preconditions;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.exceptions.ConductorClientException;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.client.task.WorkflowTaskMetrics;
import com.netflix.conductor.common.metadata.workflow.RerunWorkflowRequest;
import com.netflix.conductor.common.metadata.workflow.StartWorkflowRequest;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.common.run.WorkflowSummary;
import com.netflix.conductor.common.utils.ExternalPayloadStorage;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowClient
extends ClientBase {
    private static GenericType<List<WorkflowDef>> workflowDefList = new GenericType<List<WorkflowDef>>(){};
    private static GenericType<SearchResult<WorkflowSummary>> searchResultWorkflowSummary = new GenericType<SearchResult<WorkflowSummary>>(){};
    private static final Logger logger = LoggerFactory.getLogger(WorkflowClient.class);

    public WorkflowClient() {
        this((ClientConfig)new DefaultClientConfig(), new DefaultConductorClientConfiguration(), null, new ClientFilter[0]);
    }

    public WorkflowClient(ClientConfig config) {
        this(config, new DefaultConductorClientConfiguration(), null, new ClientFilter[0]);
    }

    public WorkflowClient(ClientConfig config, ClientHandler handler) {
        this(config, new DefaultConductorClientConfiguration(), handler, new ClientFilter[0]);
    }

    public WorkflowClient(ClientConfig config, ClientHandler handler, ClientFilter ... filters) {
        this(config, new DefaultConductorClientConfiguration(), handler, filters);
    }

    public WorkflowClient(ClientConfig config, ConductorClientConfiguration clientConfiguration, ClientHandler handler, ClientFilter ... filters) {
        super(config, clientConfiguration, handler);
        for (ClientFilter filter : filters) {
            this.client.addFilter(filter);
        }
    }

    @Deprecated
    public List<WorkflowDef> getAllWorkflowDefs() {
        return this.getForEntity("metadata/workflow", null, workflowDefList, new Object[0]);
    }

    @Deprecated
    public void registerWorkflow(WorkflowDef workflowDef) {
        Preconditions.checkNotNull((Object)workflowDef, (Object)"Worfklow definition cannot be null");
        this.postForEntityWithRequestOnly("metadata/workflow", workflowDef);
    }

    @Deprecated
    public WorkflowDef getWorkflowDef(String name, Integer version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"name cannot be blank");
        return this.getForEntity("metadata/workflow/{name}", new Object[]{"version", version}, WorkflowDef.class, name);
    }

    @Deprecated
    public String startWorkflow(String name, Integer version, String correlationId, Map<String, Object> input) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"name cannot be blank");
        StartWorkflowRequest startWorkflowRequest = new StartWorkflowRequest();
        startWorkflowRequest.setName(name);
        startWorkflowRequest.setVersion(version);
        startWorkflowRequest.setCorrelationId(correlationId);
        startWorkflowRequest.setInput(input);
        return this.startWorkflow(startWorkflowRequest);
    }

    public String startWorkflow(StartWorkflowRequest startWorkflowRequest) {
        Preconditions.checkNotNull((Object)startWorkflowRequest, (Object)"StartWorkflowRequest cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)startWorkflowRequest.getName()), (Object)"Workflow name cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isBlank((String)startWorkflowRequest.getExternalInputPayloadStoragePath()), (Object)"External Storage Path must not be set");
        String version = startWorkflowRequest.getVersion() != null ? startWorkflowRequest.getVersion().toString() : "latest";
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.objectMapper.writeValue((OutputStream)byteArrayOutputStream, (Object)startWorkflowRequest.getInput());
            byte[] workflowInputBytes = byteArrayOutputStream.toByteArray();
            long workflowInputSize = workflowInputBytes.length;
            WorkflowTaskMetrics.recordWorkflowInputPayloadSize(startWorkflowRequest.getName(), version, workflowInputSize);
            if (workflowInputSize > (long)(this.conductorClientConfiguration.getWorkflowInputPayloadThresholdKB() * 1024)) {
                if (!this.conductorClientConfiguration.isExternalPayloadStorageEnabled() || workflowInputSize > (long)(this.conductorClientConfiguration.getWorkflowInputMaxPayloadThresholdKB() * 1024)) {
                    String errorMsg = String.format("Input payload larger than the allowed threshold of: %d KB", this.conductorClientConfiguration.getWorkflowInputPayloadThresholdKB());
                    throw new ConductorClientException(errorMsg);
                }
                WorkflowTaskMetrics.incrementExternalPayloadUsedCount(startWorkflowRequest.getName(), ExternalPayloadStorage.Operation.WRITE.name(), ExternalPayloadStorage.PayloadType.WORKFLOW_INPUT.name());
                String externalStoragePath = this.uploadToExternalPayloadStorage(ExternalPayloadStorage.PayloadType.WORKFLOW_INPUT, workflowInputBytes, workflowInputSize);
                startWorkflowRequest.setExternalInputPayloadStoragePath(externalStoragePath);
                startWorkflowRequest.setInput(null);
            }
        }
        catch (IOException e) {
            String errorMsg = String.format("Unable to start workflow:%s, version:%s", startWorkflowRequest.getName(), version);
            logger.error(errorMsg, (Throwable)e);
            throw new ConductorClientException(errorMsg, e);
        }
        return this.postForEntity("workflow", (Object)startWorkflowRequest, null, String.class, startWorkflowRequest.getName());
    }

    @Deprecated
    public Workflow getExecutionStatus(String workflowId, boolean includeTasks) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        return this.getWorkflow(workflowId, includeTasks);
    }

    public Workflow getWorkflow(String workflowId, boolean includeTasks) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        Workflow workflow = this.getForEntity("workflow/{workflowId}", new Object[]{"includeTasks", includeTasks}, Workflow.class, workflowId);
        this.populateWorkflowOutput(workflow);
        return workflow;
    }

    public List<Workflow> getWorkflows(String name, String correlationId, boolean includeClosed, boolean includeTasks) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"name cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)correlationId), (Object)"correlationId cannot be blank");
        Object[] params = new Object[]{"includeClosed", includeClosed, "includeTasks", includeTasks};
        List<Workflow> workflows = this.getForEntity("workflow/{name}/correlated/{correlationId}", params, new GenericType<List<Workflow>>(){}, name, correlationId);
        workflows.forEach(this::populateWorkflowOutput);
        return workflows;
    }

    private void populateWorkflowOutput(Workflow workflow) {
        if (StringUtils.isNotBlank((String)workflow.getExternalOutputPayloadStoragePath())) {
            WorkflowTaskMetrics.incrementExternalPayloadUsedCount(workflow.getWorkflowName(), ExternalPayloadStorage.Operation.READ.name(), ExternalPayloadStorage.PayloadType.WORKFLOW_OUTPUT.name());
            workflow.setOutput(this.downloadFromExternalStorage(ExternalPayloadStorage.PayloadType.WORKFLOW_OUTPUT, workflow.getExternalOutputPayloadStoragePath()));
        }
    }

    public void deleteWorkflow(String workflowId, boolean archiveWorkflow) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"Workflow id cannot be blank");
        Object[] params = new Object[]{"archiveWorkflow", archiveWorkflow};
        this.delete(params, "workflow/{workflowId}/remove", workflowId);
    }

    public List<String> getRunningWorkflow(String workflowName, Integer version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowName), (Object)"Workflow name cannot be blank");
        return this.getForEntity("workflow/running/{name}", new Object[]{"version", version}, new GenericType<List<String>>(){}, workflowName);
    }

    public List<String> getWorkflowsByTimePeriod(String workflowName, int version, Long startTime, Long endTime) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowName), (Object)"Workflow name cannot be blank");
        Preconditions.checkNotNull((Object)startTime, (Object)"Start time cannot be null");
        Preconditions.checkNotNull((Object)endTime, (Object)"End time cannot be null");
        Object[] params = new Object[]{"version", version, "startTime", startTime, "endTime", endTime};
        return this.getForEntity("workflow/running/{name}", params, new GenericType<List<String>>(){}, workflowName);
    }

    public void runDecider(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.put("workflow/decide/{workflowId}", null, null, workflowId);
    }

    public void pauseWorkflow(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.put("workflow/{workflowId}/pause", null, null, workflowId);
    }

    public void resumeWorkflow(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.put("workflow/{workflowId}/resume", null, null, workflowId);
    }

    public void skipTaskFromWorkflow(String workflowId, String taskReferenceName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskReferenceName), (Object)"Task reference name cannot be blank");
        this.put("workflow/{workflowId}/skiptask/{taskReferenceName}", null, workflowId, taskReferenceName);
    }

    public String rerunWorkflow(String workflowId, RerunWorkflowRequest rerunWorkflowRequest) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        Preconditions.checkNotNull((Object)rerunWorkflowRequest, (Object)"RerunWorkflowRequest cannot be null");
        return this.postForEntity("workflow/{workflowId}/rerun", (Object)rerunWorkflowRequest, null, String.class, workflowId);
    }

    public void restart(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.postForEntityWithUriVariablesOnly("workflow/{workflowId}/restart", workflowId);
    }

    public void retryLastFailedTask(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.postForEntityWithUriVariablesOnly("workflow/{workflowId}/retry", workflowId);
    }

    public void resetCallbacksForInProgressTasks(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.postForEntityWithUriVariablesOnly("workflow/{workflowId}/resetcallbacks", workflowId);
    }

    public void terminateWorkflow(String workflowId, String reason) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"workflow id cannot be blank");
        this.delete(new Object[]{"reason", reason}, "workflow/{workflowId}", workflowId);
    }

    public SearchResult<WorkflowSummary> search(String query) {
        return this.getForEntity("workflow/search", new Object[]{"query", query}, searchResultWorkflowSummary, new Object[0]);
    }

    public SearchResult<WorkflowSummary> search(Integer start, Integer size, String sort, String freeText, String query) {
        Object[] params = new Object[]{"start", start, "size", size, "sort", sort, "freeText", freeText, "query", query};
        return this.getForEntity("workflow/search", params, searchResultWorkflowSummary, new Object[0]);
    }
}

