/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.amazonaws.util.IOUtils;
import com.netflix.conductor.client.exceptions.ConductorClientException;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.common.run.ExternalStorageLocation;
import com.netflix.conductor.common.utils.ExternalPayloadStorage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PayloadStorage
implements ExternalPayloadStorage {
    private static final Logger logger = LoggerFactory.getLogger(PayloadStorage.class);
    private final ClientBase clientBase;

    PayloadStorage(ClientBase clientBase) {
        this.clientBase = clientBase;
    }

    public ExternalStorageLocation getLocation(ExternalPayloadStorage.Operation operation, ExternalPayloadStorage.PayloadType payloadType, String path) {
        String uri;
        switch (payloadType) {
            case WORKFLOW_INPUT: 
            case WORKFLOW_OUTPUT: {
                uri = "workflow";
                break;
            }
            case TASK_INPUT: 
            case TASK_OUTPUT: {
                uri = "tasks";
                break;
            }
            default: {
                throw new ConductorClientException(String.format("Invalid payload type: %s for operation: %s", payloadType.toString(), operation.toString()));
            }
        }
        return this.clientBase.getForEntity(String.format("%s/externalstoragelocation", uri), new Object[]{"path", path, "operation", operation.toString(), "payloadType", payloadType.toString()}, ExternalStorageLocation.class, new Object[0]);
    }

    public void upload(String uri, InputStream payload, long payloadSize) {
        HttpURLConnection connection = null;
        try {
            URL url = new URI(uri).toURL();
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(connection.getOutputStream());){
                long count = IOUtils.copy((InputStream)payload, (OutputStream)bufferedOutputStream);
                bufferedOutputStream.flush();
                logger.debug("Uploaded {} bytes to uri: {}", (Object)count, (Object)uri);
                int responseCode = connection.getResponseCode();
                logger.debug("Upload completed with HTTP response code: {}", (Object)responseCode);
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            String errorMsg = String.format("Invalid path specified: %s", uri);
            logger.error(errorMsg, (Throwable)e);
            throw new ConductorClientException(errorMsg, e);
        }
        catch (IOException e) {
            String errorMsg = String.format("Error uploading to path: %s", uri);
            logger.error(errorMsg, (Throwable)e);
            throw new ConductorClientException(errorMsg, e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            try {
                if (payload != null) {
                    payload.close();
                }
            }
            catch (IOException e) {
                logger.warn("Unable to close inputstream when uploading to uri: {}", (Object)uri);
            }
        }
    }

    public InputStream download(String uri) {
        HttpURLConnection connection = null;
        try {
            URL url = new URI(uri).toURL();
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(false);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                logger.debug("Download completed with HTTP response code: {}", (Object)connection.getResponseCode());
                InputStream inputStream = org.apache.commons.io.IOUtils.toBufferedInputStream((InputStream)connection.getInputStream());
                return inputStream;
            }
            try {
                String errorMsg = String.format("Unable to download. Response code: %d", responseCode);
                logger.error(errorMsg);
                throw new ConductorClientException(errorMsg);
            }
            catch (MalformedURLException | URISyntaxException e) {
                String errorMsg = String.format("Invalid uri specified: %s", uri);
                logger.error(errorMsg, (Throwable)e);
                throw new ConductorClientException(errorMsg, e);
            }
            catch (IOException e) {
                String errorMsg = String.format("Error downloading from uri: %s", uri);
                logger.error(errorMsg, (Throwable)e);
                throw new ConductorClientException(errorMsg, e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

