/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.automator;

import com.google.common.base.Preconditions;
import com.netflix.conductor.client.automator.TaskPollExecutor;
import com.netflix.conductor.client.http.TaskClient;
import com.netflix.conductor.client.telemetry.MetricsContainer;
import com.netflix.conductor.client.worker.Worker;
import com.netflix.discovery.EurekaClient;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TaskRunnerConfigurer {
    private ScheduledExecutorService scheduledExecutorService;
    private final EurekaClient eurekaClient;
    private final TaskClient taskClient;
    private List<Worker> workers = new LinkedList<Worker>();
    private final int sleepWhenRetry;
    private final int updateRetryCount;
    private final int threadCount;
    private final String workerNamePrefix;
    private final Map<String, String> taskToDomain;
    private TaskPollExecutor taskPollExecutor;

    private TaskRunnerConfigurer(Builder builder) {
        this.eurekaClient = builder.eurekaClient;
        this.taskClient = builder.taskClient;
        this.sleepWhenRetry = builder.sleepWhenRetry;
        this.updateRetryCount = builder.updateRetryCount;
        this.workerNamePrefix = builder.workerNamePrefix;
        this.taskToDomain = builder.taskToDomain;
        builder.workers.forEach(this.workers::add);
        this.threadCount = builder.threadCount == -1 ? this.workers.size() : builder.threadCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getSleepWhenRetry() {
        return this.sleepWhenRetry;
    }

    public int getUpdateRetryCount() {
        return this.updateRetryCount;
    }

    public String getWorkerNamePrefix() {
        return this.workerNamePrefix;
    }

    public synchronized void init() {
        MetricsContainer.incrementInitializationCount(this.getClass().getCanonicalName());
        this.taskPollExecutor = new TaskPollExecutor(this.eurekaClient, this.taskClient, this.threadCount, this.updateRetryCount, this.taskToDomain, this.workerNamePrefix);
        this.scheduledExecutorService = Executors.newScheduledThreadPool(this.workers.size());
        this.workers.forEach(worker -> this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.taskPollExecutor.pollAndExecute((Worker)worker), worker.getPollingInterval(), worker.getPollingInterval(), TimeUnit.MILLISECONDS));
    }

    public void shutdown() {
        this.taskPollExecutor.shutdownExecutorService(this.scheduledExecutorService);
    }

    public static class Builder {
        private String workerNamePrefix = "workflow-worker-%d";
        private int sleepWhenRetry = 500;
        private int updateRetryCount = 3;
        private int threadCount = -1;
        private Iterable<Worker> workers;
        private EurekaClient eurekaClient;
        private TaskClient taskClient;
        private Map<String, String> taskToDomain = new HashMap<String, String>();

        public Builder(TaskClient taskClient, Iterable<Worker> workers) {
            Preconditions.checkNotNull((Object)taskClient, (Object)"TaskClient cannot be null");
            Preconditions.checkNotNull(workers, (Object)"Workers cannot be null");
            this.taskClient = taskClient;
            this.workers = workers;
        }

        public Builder withWorkerNamePrefix(String workerNamePrefix) {
            this.workerNamePrefix = workerNamePrefix;
            return this;
        }

        public Builder withSleepWhenRetry(int sleepWhenRetry) {
            this.sleepWhenRetry = sleepWhenRetry;
            return this;
        }

        public Builder withUpdateRetryCount(int updateRetryCount) {
            this.updateRetryCount = updateRetryCount;
            return this;
        }

        public Builder withThreadCount(int threadCount) {
            if (threadCount < 1) {
                throw new IllegalArgumentException("No. of threads cannot be less than 1");
            }
            this.threadCount = threadCount;
            return this;
        }

        public Builder withEurekaClient(EurekaClient eurekaClient) {
            this.eurekaClient = eurekaClient;
            return this;
        }

        public Builder withTaskToDomain(Map<String, String> taskToDomain) {
            this.taskToDomain = taskToDomain;
            return this;
        }

        public TaskRunnerConfigurer build() {
            return new TaskRunnerConfigurer(this);
        }
    }
}

