/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.exceptions;

import com.netflix.conductor.client.exceptions.ErrorResponse;
import com.netflix.conductor.common.validation.ValidationError;
import java.util.List;

public class ConductorClientException
extends RuntimeException {
    private int status;
    private String message;
    private String instance;
    private String code;
    private boolean retryable;
    private List<ValidationError> validationErrors;

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public ConductorClientException() {
    }

    public ConductorClientException(String message) {
        super(message);
        this.message = message;
    }

    public ConductorClientException(String message, Throwable cause) {
        super(message, cause);
        this.message = message;
    }

    public ConductorClientException(int status, String message) {
        super(message);
        this.status = status;
        this.message = message;
    }

    public ConductorClientException(int status, ErrorResponse errorResponse) {
        super(errorResponse.getMessage());
        this.status = status;
        this.message = errorResponse.getMessage();
        this.code = errorResponse.getCode();
        this.instance = errorResponse.getInstance();
        this.validationErrors = errorResponse.getValidationErrors();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append(": ");
        if (this.message != null) {
            builder.append(this.message);
        }
        if (this.status > 0) {
            builder.append(" {status=").append(this.status);
            if (this.code != null) {
                builder.append(", code='").append(this.code).append("'");
            }
            builder.append(", retryable: ").append(this.retryable);
        }
        if (this.instance != null) {
            builder.append(", instance: ").append(this.instance);
        }
        builder.append("}");
        return builder.toString();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public boolean isRetryable() {
        return this.retryable;
    }

    public void setRetryable(boolean retryable) {
        this.retryable = retryable;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }
}

