/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.google.common.base.Preconditions;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.exceptions.ConductorClientException;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.client.task.WorkflowTaskMetrics;
import com.netflix.conductor.common.metadata.tasks.PollData;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.TaskSummary;
import com.netflix.conductor.common.utils.ExternalPayloadStorage;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskClient
extends ClientBase {
    private static GenericType<List<Task>> taskList = new GenericType<List<Task>>(){};
    private static GenericType<List<TaskExecLog>> taskExecLogList = new GenericType<List<TaskExecLog>>(){};
    private static GenericType<List<PollData>> pollDataList = new GenericType<List<PollData>>(){};
    private static GenericType<SearchResult<TaskSummary>> searchResultTaskSummary = new GenericType<SearchResult<TaskSummary>>(){};
    private static GenericType<Map<String, Integer>> queueSizeMap = new GenericType<Map<String, Integer>>(){};
    private static final Logger logger = LoggerFactory.getLogger(TaskClient.class);

    public TaskClient() {
        this((ClientConfig)new DefaultClientConfig(), new DefaultConductorClientConfiguration(), null, new ClientFilter[0]);
    }

    public TaskClient(ClientConfig config) {
        this(config, new DefaultConductorClientConfiguration(), null, new ClientFilter[0]);
    }

    public TaskClient(ClientConfig config, ClientHandler handler) {
        this(config, new DefaultConductorClientConfiguration(), handler, new ClientFilter[0]);
    }

    public TaskClient(ClientConfig config, ClientHandler handler, ClientFilter ... filters) {
        this(config, new DefaultConductorClientConfiguration(), handler, filters);
    }

    public TaskClient(ClientConfig config, ConductorClientConfiguration clientConfiguration, ClientHandler handler, ClientFilter ... filters) {
        super(config, clientConfiguration, handler);
        for (ClientFilter filter : filters) {
            this.client.addFilter(filter);
        }
    }

    public Task pollTask(String taskType, String workerId, String domain) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)domain), (Object)"Domain cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workerId), (Object)"Worker id cannot be blank");
        Object[] params = new Object[]{"workerid", workerId, "domain", domain};
        Task task = this.getForEntity("tasks/poll/{taskType}", params, Task.class, taskType);
        this.populateTaskInput(task);
        return task;
    }

    public List<Task> batchPollTasksByTaskType(String taskType, String workerId, int count, int timeoutInMillisecond) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workerId), (Object)"Worker id cannot be blank");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be greater than 0");
        Object[] params = new Object[]{"workerid", workerId, "count", count, "timeout", timeoutInMillisecond};
        List<Task> tasks = this.getForEntity("tasks/poll/batch/{taskType}", params, taskList, taskType);
        tasks.forEach(this::populateTaskInput);
        return tasks;
    }

    public List<Task> batchPollTasksInDomain(String taskType, String domain, String workerId, int count, int timeoutInMillisecond) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workerId), (Object)"Worker id cannot be blank");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be greater than 0");
        Object[] params = new Object[]{"workerid", workerId, "count", count, "timeout", timeoutInMillisecond, "domain", domain};
        List<Task> tasks = this.getForEntity("tasks/poll/batch/{taskType}", params, taskList, taskType);
        tasks.forEach(this::populateTaskInput);
        return tasks;
    }

    private void populateTaskInput(Task task) {
        if (StringUtils.isNotBlank((String)task.getExternalInputPayloadStoragePath())) {
            WorkflowTaskMetrics.incrementExternalPayloadUsedCount(task.getTaskDefName(), ExternalPayloadStorage.Operation.READ.name(), ExternalPayloadStorage.PayloadType.TASK_INPUT.name());
            task.setInputData(this.downloadFromExternalStorage(ExternalPayloadStorage.PayloadType.TASK_INPUT, task.getExternalInputPayloadStoragePath()));
            task.setExternalInputPayloadStoragePath(null);
        }
    }

    public List<Task> getPendingTasksByType(String taskType, String startKey, Integer count) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Object[] params = new Object[]{"startKey", startKey, "count", count};
        return this.getForEntity("tasks/in_progress/{taskType}", params, taskList, taskType);
    }

    public Task getPendingTaskForWorkflow(String workflowId, String taskReferenceName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workflowId), (Object)"Workflow id cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskReferenceName), (Object)"Task reference name cannot be blank");
        return this.getForEntity("tasks/in_progress/{workflowId}/{taskRefName}", null, Task.class, workflowId, taskReferenceName);
    }

    public void updateTask(TaskResult taskResult, String taskType) {
        Preconditions.checkNotNull((Object)taskResult, (Object)"Task result cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isBlank((String)taskResult.getExternalOutputPayloadStoragePath()), (Object)"External Storage Path must not be set");
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.objectMapper.writeValue((OutputStream)byteArrayOutputStream, (Object)taskResult.getOutputData());
            byte[] taskOutputBytes = byteArrayOutputStream.toByteArray();
            long taskResultSize = taskOutputBytes.length;
            WorkflowTaskMetrics.recordTaskResultPayloadSize(taskType, taskResultSize);
            long payloadSizeThreshold = this.conductorClientConfiguration.getTaskOutputPayloadThresholdKB() * 1024;
            if (taskResultSize > payloadSizeThreshold) {
                if (!this.conductorClientConfiguration.isExternalPayloadStorageEnabled() || taskResultSize > (long)(this.conductorClientConfiguration.getTaskOutputMaxPayloadThresholdKB() * 1024)) {
                    taskResult.setReasonForIncompletion(String.format("The TaskResult payload size: %d is greater than the permissible %d MB", taskResultSize, payloadSizeThreshold));
                    taskResult.setStatus(TaskResult.Status.FAILED_WITH_TERMINAL_ERROR);
                    taskResult.setOutputData(null);
                } else {
                    WorkflowTaskMetrics.incrementExternalPayloadUsedCount(taskType, ExternalPayloadStorage.Operation.WRITE.name(), ExternalPayloadStorage.PayloadType.TASK_OUTPUT.name());
                    String externalStoragePath = this.uploadToExternalPayloadStorage(ExternalPayloadStorage.PayloadType.TASK_OUTPUT, taskOutputBytes, taskResultSize);
                    taskResult.setExternalOutputPayloadStoragePath(externalStoragePath);
                    taskResult.setOutputData(null);
                }
            }
        }
        catch (IOException e) {
            String errorMsg = String.format("Unable to update task: %s with task result", taskResult.getTaskId());
            logger.error(errorMsg, (Throwable)e);
            throw new ConductorClientException(errorMsg, e);
        }
        this.postForEntityWithRequestOnly("tasks", taskResult);
    }

    public Boolean ack(String taskId, String workerId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskId), (Object)"Task id cannot be blank");
        String response = this.postForEntity("tasks/{taskId}/ack", null, new Object[]{"workerid", workerId}, String.class, taskId);
        return Boolean.valueOf(response);
    }

    public void logMessageForTask(String taskId, String logMessage) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskId), (Object)"Task id cannot be blank");
        this.postForEntityWithRequestOnly("tasks/" + taskId + "/log", logMessage);
    }

    public List<TaskExecLog> getTaskLogs(String taskId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskId), (Object)"Task id cannot be blank");
        return this.getForEntity("tasks/{taskId}/log", null, taskExecLogList, taskId);
    }

    public Task getTaskDetails(String taskId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskId), (Object)"Task id cannot be blank");
        return this.getForEntity("tasks/{taskId}", null, Task.class, taskId);
    }

    public void removeTaskFromQueue(String taskType, String taskId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskId), (Object)"Task id cannot be blank");
        this.delete("tasks/queue/{taskType}/{taskId}", taskType, taskId);
    }

    public int getQueueSizeForTask(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Map<String, Integer> taskTypeToQueueSizeMap = this.getForEntity("tasks/queue/sizes", new Object[]{"taskType", taskType}, queueSizeMap, new Object[0]);
        if (taskTypeToQueueSizeMap.containsKey(taskType)) {
            return taskTypeToQueueSizeMap.get(taskType);
        }
        return 0;
    }

    public List<PollData> getPollData(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        Object[] params = new Object[]{"taskType", taskType};
        return this.getForEntity("tasks/queue/polldata", params, pollDataList, new Object[0]);
    }

    public List<PollData> getAllPollData() {
        return this.getForEntity("tasks/queue/polldata/all", null, pollDataList, new Object[0]);
    }

    public String requeueAllPendingTasks() {
        return this.postForEntity("tasks/queue/requeue", null, null, String.class, new Object[0]);
    }

    public String requeuePendingTasksByTaskType(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)taskType), (Object)"Task type cannot be blank");
        return this.postForEntity("tasks/queue/requeue/{taskType}", null, null, String.class, taskType);
    }

    public SearchResult<TaskSummary> search(String query) {
        return this.getForEntity("tasks/search", new Object[]{"query", query}, searchResultTaskSummary, new Object[0]);
    }

    public SearchResult<TaskSummary> search(Integer start, Integer size, String sort, String freeText, String query) {
        Object[] params = new Object[]{"start", start, "size", size, "sort", sort, "freeText", freeText, "query", query};
        return this.getForEntity("tasks/search", params, searchResultTaskSummary, new Object[0]);
    }
}

