/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http.jersey;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.netflix.conductor.client.exception.RequestHandlerException;
import com.netflix.conductor.client.http.RequestHandler;
import com.netflix.conductor.common.config.ObjectMapperProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.InputStream;
import java.net.URI;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyRequestHandler
implements RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JerseyRequestHandler.class);
    private final Client client;

    public JerseyRequestHandler() {
        this(new ClientFilter[0]);
    }

    public JerseyRequestHandler(ClientFilter ... filters) {
        this((ClientHandler)null, filters);
    }

    public JerseyRequestHandler(ClientHandler clientHandler, ClientFilter ... filters) {
        this(null, clientHandler, filters);
    }

    public JerseyRequestHandler(ClientConfig config, ClientHandler handler, ClientFilter ... filters) {
        if (config == null) {
            config = new DefaultClientConfig();
            ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();
            if (this.isNewerJacksonVersion()) {
                objectMapper.registerModule((Module)new JavaTimeModule());
            }
            JacksonJsonProvider provider = new JacksonJsonProvider(objectMapper);
            config.getSingletons().add(provider);
        }
        this.client = handler == null ? Client.create((ClientConfig)config) : new Client(handler, config);
        for (ClientFilter filter : filters) {
            this.client.addFilter(filter);
        }
    }

    @Override
    public void delete(URI uri) {
        try {
            this.client.resource(uri).delete();
        }
        catch (UniformInterfaceException e) {
            this.handleUniformInterfaceException(e, uri);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e, uri);
        }
    }

    @Override
    @Nullable
    public InputStream put(URI uri, Object body) {
        try {
            ClientResponse clientResponse = (ClientResponse)this.getWebResourceBuilder(uri, body).put(ClientResponse.class);
            if (clientResponse.getStatus() < 300) {
                return clientResponse.getEntityInputStream();
            }
            throw new UniformInterfaceException(clientResponse);
        }
        catch (RuntimeException e) {
            this.handleException(uri, e);
            return null;
        }
    }

    @Override
    @Nullable
    public InputStream post(URI uri, Object body) {
        try {
            ClientResponse clientResponse = (ClientResponse)this.getWebResourceBuilder(uri, body).post(ClientResponse.class);
            if (clientResponse.getStatus() < 300) {
                return clientResponse.getEntityInputStream();
            }
            throw new UniformInterfaceException(clientResponse);
        }
        catch (UniformInterfaceException e) {
            this.handleUniformInterfaceException(e, uri);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e, uri);
        }
        return null;
    }

    @Override
    @Nullable
    public InputStream get(URI uri) {
        try {
            ClientResponse clientResponse = (ClientResponse)this.client.resource(uri).accept(new String[]{"application/json", "text/plain"}).get(ClientResponse.class);
            if (clientResponse.getStatus() == 204) {
                clientResponse.close();
                return null;
            }
            if (clientResponse.getStatus() < 300) {
                return clientResponse.getEntityInputStream();
            }
            throw new UniformInterfaceException(clientResponse);
        }
        catch (UniformInterfaceException e) {
            this.handleUniformInterfaceException(e, uri);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e, uri);
        }
        return null;
    }

    private void handleClientHandlerException(ClientHandlerException exception, URI uri) {
        String errorMessage = String.format("Unable to invoke Conductor API with uri: %s, failure to process request or response", uri);
        LOGGER.error(errorMessage, (Throwable)exception);
        throw new RequestHandlerException(errorMessage, exception);
    }

    private void handleRuntimeException(RuntimeException exception, URI uri) {
        String errorMessage = String.format("Unable to invoke Conductor API with uri: %s, runtime exception occurred", uri);
        LOGGER.error(errorMessage, (Throwable)exception);
        throw new RequestHandlerException(errorMessage, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUniformInterfaceException(UniformInterfaceException exception, URI uri) {
        ClientResponse clientResponse = exception.getResponse();
        if (clientResponse == null) {
            throw new RequestHandlerException(String.format("Unable to invoke Conductor API with uri: %s", uri));
        }
        try {
            if (clientResponse.getStatus() < 300) {
                return;
            }
            try {
                LOGGER.warn("Unable to invoke Conductor API with uri: {}, unexpected response from server: statusCode={}", (Object)uri, (Object)clientResponse.getStatus());
                throw new RequestHandlerException(clientResponse.getEntityInputStream(), clientResponse.getStatus());
            }
            catch (RequestHandlerException e) {
                throw e;
            }
            catch (ClientHandlerException e) {
                this.handleClientHandlerException(e, uri);
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e, uri);
            }
        }
        finally {
            clientResponse.close();
        }
    }

    private void handleException(URI uri, RuntimeException e) {
        if (e instanceof UniformInterfaceException) {
            this.handleUniformInterfaceException((UniformInterfaceException)((Object)e), uri);
        } else if (e instanceof ClientHandlerException) {
            this.handleClientHandlerException((ClientHandlerException)((Object)e), uri);
        } else {
            this.handleRuntimeException(e, uri);
        }
    }

    private WebResource.Builder getWebResourceBuilder(URI URI2, Object entity) {
        return (WebResource.Builder)((WebResource.Builder)this.client.resource(URI2).type("application/json").entity(entity)).accept(new String[]{"text/plain", "application/json"});
    }

    private boolean isNewerJacksonVersion() {
        Version version = PackageVersion.VERSION;
        return version.getMajorVersion() == 2 && version.getMinorVersion() >= 12;
    }
}

