/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.exception.ConductorClientException;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.client.http.RequestHandler;
import com.netflix.conductor.client.telemetry.MetricsContainer;
import com.netflix.conductor.common.metadata.tasks.PollData;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.TaskSummary;
import com.netflix.conductor.common.utils.ExternalPayloadStorage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskClient
extends ClientBase {
    private static final TypeReference<List<Task>> taskList = new TypeReference<List<Task>>(){};
    private static final TypeReference<List<TaskExecLog>> taskExecLogList = new TypeReference<List<TaskExecLog>>(){};
    private static final TypeReference<List<PollData>> pollDataList = new TypeReference<List<PollData>>(){};
    private static final TypeReference<SearchResult<TaskSummary>> searchResultTaskSummary = new TypeReference<SearchResult<TaskSummary>>(){};
    private static final TypeReference<SearchResult<Task>> searchResultTask = new TypeReference<SearchResult<Task>>(){};
    private static final TypeReference<Map<String, Integer>> queueSizeMap = new TypeReference<Map<String, Integer>>(){};
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskClient.class);

    public TaskClient() {
        this(null);
    }

    public TaskClient(RequestHandler requestHandler) {
        this(requestHandler, null);
    }

    public TaskClient(RequestHandler requestHandler, ConductorClientConfiguration clientConfiguration) {
        super(requestHandler, clientConfiguration);
    }

    public Task pollTask(String taskType, String workerId, String domain) {
        Validate.notBlank((CharSequence)taskType, (String)"Task type cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)workerId, (String)"Worker id cannot be blank", (Object[])new Object[0]);
        Object[] params = new Object[]{"workerid", workerId, "domain", domain};
        Task task = (Task)ObjectUtils.defaultIfNull((Object)this.getForEntity("tasks/poll/{taskType}", params, Task.class, taskType), (Object)new Task());
        this.populateTaskPayloads(task);
        return task;
    }

    public List<Task> batchPollTasksByTaskType(String taskType, String workerId, int count, int timeoutInMillisecond) {
        Validate.notBlank((CharSequence)taskType, (String)"Task type cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)workerId, (String)"Worker id cannot be blank", (Object[])new Object[0]);
        Validate.isTrue((count > 0 ? 1 : 0) != 0, (String)"Count must be greater than 0", (Object[])new Object[0]);
        Object[] params = new Object[]{"workerid", workerId, "count", count, "timeout", timeoutInMillisecond};
        List<Task> tasks = this.getForEntity("tasks/poll/batch/{taskType}", params, taskList, taskType);
        tasks.forEach(this::populateTaskPayloads);
        return tasks;
    }

    public List<Task> batchPollTasksInDomain(String taskType, String domain, String workerId, int count, int timeoutInMillisecond) {
        Validate.notBlank((CharSequence)taskType, (String)"Task type cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)workerId, (String)"Worker id cannot be blank", (Object[])new Object[0]);
        Validate.isTrue((count > 0 ? 1 : 0) != 0, (String)"Count must be greater than 0", (Object[])new Object[0]);
        Object[] params = new Object[]{"workerid", workerId, "count", count, "timeout", timeoutInMillisecond, "domain", domain};
        List<Task> tasks = this.getForEntity("tasks/poll/batch/{taskType}", params, taskList, taskType);
        tasks.forEach(this::populateTaskPayloads);
        return tasks;
    }

    private void populateTaskPayloads(Task task) {
        if (StringUtils.isNotBlank((CharSequence)task.getExternalInputPayloadStoragePath())) {
            MetricsContainer.incrementExternalPayloadUsedCount(task.getTaskDefName(), ExternalPayloadStorage.Operation.READ.name(), ExternalPayloadStorage.PayloadType.TASK_INPUT.name());
            task.setInputData(this.downloadFromExternalStorage(ExternalPayloadStorage.PayloadType.TASK_INPUT, task.getExternalInputPayloadStoragePath()));
            task.setExternalInputPayloadStoragePath(null);
        }
        if (StringUtils.isNotBlank((CharSequence)task.getExternalOutputPayloadStoragePath())) {
            MetricsContainer.incrementExternalPayloadUsedCount(task.getTaskDefName(), ExternalPayloadStorage.Operation.READ.name(), ExternalPayloadStorage.PayloadType.TASK_OUTPUT.name());
            task.setOutputData(this.downloadFromExternalStorage(ExternalPayloadStorage.PayloadType.TASK_OUTPUT, task.getExternalOutputPayloadStoragePath()));
            task.setExternalOutputPayloadStoragePath(null);
        }
    }

    public void updateTask(TaskResult taskResult) {
        Validate.notNull((Object)taskResult, (String)"Task result cannot be null", (Object[])new Object[0]);
        this.post("tasks", taskResult);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> evaluateAndUploadLargePayload(Map<String, Object> taskOutputData, String taskType) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.objectMapper.writeValue((OutputStream)byteArrayOutputStream, taskOutputData);
            byte[] taskOutputBytes = byteArrayOutputStream.toByteArray();
            long taskResultSize = taskOutputBytes.length;
            MetricsContainer.recordTaskResultPayloadSize(taskType, taskResultSize);
            long payloadSizeThreshold = (long)this.conductorClientConfiguration.getTaskOutputPayloadThresholdKB() * 1024L;
            if (taskResultSize > payloadSizeThreshold) {
                if (this.conductorClientConfiguration.isExternalPayloadStorageEnabled() && taskResultSize <= (long)this.conductorClientConfiguration.getTaskOutputMaxPayloadThresholdKB() * 1024L) {
                    MetricsContainer.incrementExternalPayloadUsedCount(taskType, ExternalPayloadStorage.Operation.WRITE.name(), ExternalPayloadStorage.PayloadType.TASK_OUTPUT.name());
                    Optional<String> optional = Optional.of(this.uploadToExternalPayloadStorage(ExternalPayloadStorage.PayloadType.TASK_OUTPUT, taskOutputBytes, taskResultSize));
                    return optional;
                }
                throw new IllegalArgumentException(String.format("The TaskResult payload size: %d is greater than the permissible %d bytes", taskResultSize, payloadSizeThreshold));
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            String errorMsg = String.format("Unable to update task: %s with task result", taskType);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new ConductorClientException(errorMsg, e);
        }
    }

    public Boolean ack(String taskId, String workerId) {
        Validate.notBlank((CharSequence)taskId, (String)"Task id cannot be blank", (Object[])new Object[0]);
        String response = this.postForString("tasks/{taskId}/ack", null, new Object[]{"workerid", workerId}, taskId);
        return Boolean.valueOf(response);
    }

    public void logMessageForTask(String taskId, String logMessage) {
        Validate.notBlank((CharSequence)taskId, (String)"Task id cannot be blank", (Object[])new Object[0]);
        this.post("tasks/" + taskId + "/log", logMessage);
    }

    public List<TaskExecLog> getTaskLogs(String taskId) {
        Validate.notBlank((CharSequence)taskId, (String)"Task id cannot be blank", (Object[])new Object[0]);
        return this.getForEntity("tasks/{taskId}/log", null, taskExecLogList, taskId);
    }

    public Task getTaskDetails(String taskId) {
        Validate.notBlank((CharSequence)taskId, (String)"Task id cannot be blank", (Object[])new Object[0]);
        return this.getForEntity("tasks/{taskId}", null, Task.class, taskId);
    }

    public void removeTaskFromQueue(String taskType, String taskId) {
        Validate.notBlank((CharSequence)taskType, (String)"Task type cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)taskId, (String)"Task id cannot be blank", (Object[])new Object[0]);
        this.delete("tasks/queue/{taskType}/{taskId}", taskType, taskId);
    }

    public int getQueueSizeForTask(String taskType) {
        Validate.notBlank((CharSequence)taskType, (String)"Task type cannot be blank", (Object[])new Object[0]);
        Integer queueSize = this.getForEntity("tasks/queue/size", new Object[]{"taskType", taskType}, new TypeReference<Integer>(){}, new Object[0]);
        return queueSize != null ? queueSize : 0;
    }

    public int getQueueSizeForTask(String taskType, String domain, String isolationGroupId, String executionNamespace) {
        Integer queueSize;
        Validate.notBlank((CharSequence)taskType, (String)"Task type cannot be blank", (Object[])new Object[0]);
        LinkedList<String> params = new LinkedList<String>();
        params.add("taskType");
        params.add(taskType);
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            params.add("domain");
            params.add(domain);
        }
        if (StringUtils.isNotBlank((CharSequence)isolationGroupId)) {
            params.add("isolationGroupId");
            params.add(isolationGroupId);
        }
        if (StringUtils.isNotBlank((CharSequence)executionNamespace)) {
            params.add("executionNamespace");
            params.add(executionNamespace);
        }
        return (queueSize = this.getForEntity("tasks/queue/size", params.toArray(new Object[0]), new TypeReference<Integer>(){}, new Object[0])) != null ? queueSize : 0;
    }

    public List<PollData> getPollData(String taskType) {
        Validate.notBlank((CharSequence)taskType, (String)"Task type cannot be blank", (Object[])new Object[0]);
        Object[] params = new Object[]{"taskType", taskType};
        return this.getForEntity("tasks/queue/polldata", params, pollDataList, new Object[0]);
    }

    public List<PollData> getAllPollData() {
        return this.getForEntity("tasks/queue/polldata/all", null, pollDataList, new Object[0]);
    }

    public String requeueAllPendingTasks() {
        return this.postForString("tasks/queue/requeue", null, null, new Object[0]);
    }

    public String requeuePendingTasksByTaskType(String taskType) {
        Validate.notBlank((CharSequence)taskType, (String)"Task type cannot be blank", (Object[])new Object[0]);
        return this.postForString("tasks/queue/requeue/{taskType}", null, null, taskType);
    }

    public SearchResult<TaskSummary> search(String query) {
        return this.getForEntity("tasks/search", new Object[]{"query", query}, searchResultTaskSummary, new Object[0]);
    }

    public SearchResult<Task> searchV2(String query) {
        return this.getForEntity("tasks/search-v2", new Object[]{"query", query}, searchResultTask, new Object[0]);
    }

    public SearchResult<TaskSummary> search(Integer start, Integer size, String sort, String freeText, String query) {
        Object[] params = new Object[]{"start", start, "size", size, "sort", sort, "freeText", freeText, "query", query};
        return this.getForEntity("tasks/search", params, searchResultTaskSummary, new Object[0]);
    }

    public SearchResult<Task> searchV2(Integer start, Integer size, String sort, String freeText, String query) {
        Object[] params = new Object[]{"start", start, "size", size, "sort", sort, "freeText", freeText, "query", query};
        return this.getForEntity("tasks/search-v2", params, searchResultTask, new Object[0]);
    }
}

