/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.client.http.RequestHandler;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class MetadataClient
extends ClientBase {
    public MetadataClient() {
        this(null);
    }

    public MetadataClient(RequestHandler requestHandler) {
        this(requestHandler, null);
    }

    public MetadataClient(RequestHandler requestHandler, ConductorClientConfiguration clientConfiguration) {
        super(requestHandler, clientConfiguration);
    }

    public void registerWorkflowDef(WorkflowDef workflowDef) {
        Validate.notNull((Object)workflowDef, (String)"Workflow definition cannot be null", (Object[])new Object[0]);
        this.post("metadata/workflow", workflowDef);
    }

    public void validateWorkflowDef(WorkflowDef workflowDef) {
        Validate.notNull((Object)workflowDef, (String)"Workflow definition cannot be null", (Object[])new Object[0]);
        this.post("metadata/workflow/validate", workflowDef);
    }

    public void updateWorkflowDefs(List<WorkflowDef> workflowDefs) {
        Validate.notNull(workflowDefs, (String)"Worfklow defs list cannot be null", (Object[])new Object[0]);
        this.put("metadata/workflow", null, workflowDefs, new Object[0]);
    }

    public WorkflowDef getWorkflowDef(String name, Integer version) {
        Validate.notBlank((CharSequence)name, (String)"name cannot be blank", (Object[])new Object[0]);
        return this.getForEntity("metadata/workflow/{name}", new Object[]{"version", version}, WorkflowDef.class, name);
    }

    public void unregisterWorkflowDef(String name, Integer version) {
        Validate.notBlank((CharSequence)name, (String)"Workflow name cannot be blank", (Object[])new Object[0]);
        Validate.notNull((Object)version, (String)"Version cannot be null", (Object[])new Object[0]);
        this.delete("metadata/workflow/{name}/{version}", name, version);
    }

    public void registerTaskDefs(List<TaskDef> taskDefs) {
        Validate.notNull(taskDefs, (String)"Task defs list cannot be null", (Object[])new Object[0]);
        this.post("metadata/taskdefs", taskDefs);
    }

    public void updateTaskDef(TaskDef taskDef) {
        Validate.notNull((Object)taskDef, (String)"Task definition cannot be null", (Object[])new Object[0]);
        this.put("metadata/taskdefs", null, taskDef, new Object[0]);
    }

    public TaskDef getTaskDef(String taskType) {
        Validate.notBlank((CharSequence)taskType, (String)"Task type cannot be blank", (Object[])new Object[0]);
        return this.getForEntity("metadata/taskdefs/{tasktype}", null, TaskDef.class, taskType);
    }

    public void unregisterTaskDef(String taskType) {
        Validate.notBlank((CharSequence)taskType, (String)"Task type cannot be blank", (Object[])new Object[0]);
        this.delete("metadata/taskdefs/{tasktype}", taskType);
    }
}

