/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.netflix.conductor.common.config.ObjectMapperProvider;
import com.netflix.conductor.common.model.BulkResponse;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import javax.ws.rs.core.MediaType;

public class ClientRequestHandler {
    private final Client client;

    public ClientRequestHandler(ClientConfig config, ClientHandler handler, ClientFilter ... filters) {
        ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();
        if (this.isNewerJacksonVersion()) {
            objectMapper.registerModule((Module)new JavaTimeModule());
        }
        JacksonJsonProvider provider = new JacksonJsonProvider(objectMapper);
        config.getSingletons().add(provider);
        this.client = handler == null ? Client.create((ClientConfig)config) : new Client(handler, config);
        for (ClientFilter filter : filters) {
            this.client.addFilter(filter);
        }
    }

    public BulkResponse delete(URI uri, Object body) {
        if (body != null) {
            return (BulkResponse)this.client.resource(uri).type(MediaType.APPLICATION_JSON_TYPE).delete(BulkResponse.class, body);
        }
        this.client.resource(uri).delete();
        return null;
    }

    public ClientResponse get(URI uri) {
        return (ClientResponse)this.client.resource(uri).accept(new String[]{"application/json", "text/plain"}).get(ClientResponse.class);
    }

    public WebResource.Builder getWebResourceBuilder(URI URI2, Object entity) {
        return (WebResource.Builder)((WebResource.Builder)this.client.resource(URI2).type("application/json").entity(entity)).accept(new String[]{"text/plain", "application/json"});
    }

    private boolean isNewerJacksonVersion() {
        Version version = PackageVersion.VERSION;
        return version.getMajorVersion() == 2 && version.getMinorVersion() >= 12;
    }
}

