/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.automator;

import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PollingSemaphore {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollingSemaphore.class);
    private final Semaphore semaphore;

    PollingSemaphore(int numSlots) {
        LOGGER.debug("Polling semaphore initialized with {} permits", (Object)numSlots);
        this.semaphore = new Semaphore(numSlots);
    }

    void complete(int numSlots) {
        LOGGER.debug("Completed execution; releasing permit");
        this.semaphore.release(numSlots);
    }

    int availableSlots() {
        int available = this.semaphore.availablePermits();
        LOGGER.debug("Number of available permits: {}", (Object)available);
        return available;
    }

    public boolean acquireSlots(int numSlots) {
        boolean acquired = this.semaphore.tryAcquire(numSlots);
        LOGGER.debug("Trying to acquire {} permit: {}", (Object)numSlots, (Object)acquired);
        return acquired;
    }
}

